% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gquant_analysis.R
\name{gquant_analysis}
\alias{gquant_analysis}
\title{GerminaQuant data analysis}
\usage{
gquant_analysis(
  data,
  response,
  factors,
  block = NA,
  comparison = NA,
  type = "snk",
  sig = 0.05
)
}
\arguments{
\item{data}{data from ger_summary() function}

\item{response}{germination indices to analyse}

\item{factors}{factor as vector or factor model as string}

\item{block}{block factor for RCBD}

\item{comparison}{treatments will be compared.}

\item{type}{method for made comparison analysis: c("snk", "tukey", "duncan").}

\item{sig}{significance level. Default 0.05}
}
\value{
list
}
\description{
Function analysis of variance for summary data.
}
\details{
Function for the analysis module in the app
}
\examples{
 

\dontrun{

library(GerminaR)

smr <- ger_summary(SeedN = "seeds", evalName = "D", data = prosopis)

mc <- gquant_analysis(data = smr
                      , response = "grp"
                      , factors = c("nacl", "temp")
                      , block = "rep"
                      , comparison = c("nacl", "temp")
                      )
                      
mc

} 

}
