% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_states.R
\name{add_states}
\alias{add_states}
\title{Add states to a dataset based on groups and start/end times}
\usage{
add_states(
  dataset,
  States.dataset,
  Datetime.colname = Datetime,
  start.colname = start,
  end.colname = end,
  force.tz = FALSE,
  leave.out = c("duration", "epoch")
)
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{States.dataset}{A light logger dataset. Needs to be a dataframe. This
dataset must contain the same variables as the \code{dataset} grouping, as well
as a start and end time. Any other column, that is not in \code{leave.out} will
be added to the dataset.}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{start.colname, end.colname}{The columns that contain the start and end
time. Need to be \code{POSIXct} and part of the \code{States.dataset}.}

\item{force.tz}{If \code{TRUE}, the start and end times of the \code{States.dataset}
will be forced to the same time zone as the \code{dataset} using
\code{\link[lubridate:force_tz]{lubridate::force_tz()}}. If \code{FALSE} (default), the start and end times of
the \code{States.dataset} will be used as is.}

\item{leave.out}{A character vector of columns that should not be carried
over to the \code{dataset}}
}
\value{
a modified \code{dataset} with the states added. The states are added as
new columns to the \code{dataset}. The columns are named after the columns in
the \code{States.dataset}, except for the start and end times, which are
removed.
}
\description{
\code{\link[=add_states]{add_states()}} brings states to a time series dataset. It uses the
\code{States.dataset} to add states to the \code{dataset}. The \code{States.dataset} must at
least contain the same variables as the \code{dataset} grouping, as well as a
start and end time. Beware if both datasets operate on different time zones
and consider to set \code{force.tz = TRUE}.
}
\details{
Beware if columns in the \code{dataset} and \code{States.dataset} have the same name
(other then grouping variables). The underlying function,
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}} will mark the columns in the \code{dataset} with a suffix
\code{.x}, and in the \code{States.dataset} with a suffix \code{.y}.
}
\examples{
states <-
sample.data.environment |>
  filter_Date(length = "1 day") |> 
  extract_states(Daylight, MEDI > 1000)

states |> head(2)

#add states to a dataset and plot them - as we only looked for states on the
# first day (see above), only the first day will show up in the plot
sample.data.environment |> 
 filter_Date(length = "2 day") |> 
 add_states(states) |> 
 gg_days() |> 
 gg_state(Daylight)
}
