% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_09_PREDICT_NMD_1_ParseGTF.R
\name{ParseGTF}
\alias{ParseGTF}
\title{Parse gene transfer file (GTF)}
\usage{
ParseGTF(MarvelObject)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.PSI} function.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$NMD$GTF}.
}
\description{
Parses the gene transfer file (GTF) for downstream nonsense-mediated decay (NMD) prediction.
}
\details{
This function parses the GTF in order to generate new columns for gene IDs, transcript IDs, and transcript type. These information are extracted from the attribute (9th) column for a standard GTF. These information will be used for downstream NMD prediction.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ParseGTF(MarvelObject=marvel.demo)
}
