% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{make_group}
\alias{make_group}
\title{Creates a group of Makefile items}
\usage{
make_group(..., .dots = NULL, sep = NULL)
}
\arguments{
\item{...}{\code{[MakefileR]}\cr Items created by \code{\link{make_rule}} or other \code{make_}
functions}

\item{.dots}{\code{[list]}\cr Further rules in addition to \code{...}}

\item{sep}{\code{[character(1)]}\cr Separator between group items,
\code{NULL} (the default) means no separator.}
}
\value{
An object of class \code{MakefileR_group}
}
\description{
Helps separating similar rules.
}
\details{
Use the
\code{\link[base]{c}} function or the \code{\link[base]{+}} operator
to append groups to other groups and Makefiles (thus creating nested groups).
}
\examples{
makefile(make_rule("all", c("first_target", "second_target")))

}
\references{
\url{https://www.gnu.org/software/make/manual/}
}
\seealso{
\code{\link{c.MakefileR_group}}

Other items: \code{\link{make_comment}},
  \code{\link{make_def}}, \code{\link{make_rule}},
  \code{\link{make_text}}
}

