% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{make_rule}
\alias{make_rule}
\title{Creates a Makefile rule}
\usage{
make_rule(targets, deps = NULL, script = NULL)
}
\arguments{
\item{targets}{\code{[character]}\cr Target names}

\item{deps}{\code{[character]}\cr Dependency names}

\item{script}{\code{[character]}\cr A script to execute to build the targets.}
}
\value{
An object of class \code{MakefileR_rule}
}
\description{
A rule in a \code{Makefile} consists of a (list of) targets which may
depend on one or more dependencies each.  Optionally, a script is executed to
create the target.  Generally, multiple targets mean that the rule is
identical for each of the individual targets, and multiple dependencies mean
that \emph{all} of them are required to build \emph{each} of the targets.
In the script, the target can be referenced by \code{$@}, and the first
dependency can be referenced by \code{$<}.  Note that the dollar sign has a
special meaning in a \code{Makefile}, use \code{$$} in scripts that need
to use the dollar sign themselves.
}
\details{
Use the
\code{\link[base]{c}} function or the \code{\link[base]{+}} operator
to append rules to groups and Makefiles.
}
\examples{
make_rule("all", c("first_target", "second_target"))
make_rule(".FORCE")
make_rule("first_target", ".FORCE", "echo 'Building first target'")
make_rule("second_target", "first_target",
 c("echo 'Building second target'", "echo 'Done'"))

makefile() +
  make_rule("all", c("first_target", "second_target")) +
  make_rule(".FORCE") +
  make_rule("first_target", ".FORCE", "echo 'Building first target'") +
  make_rule("second_target", "first_target",
    c("echo 'Building second target'", "echo 'Done'"))

}
\references{
\url{https://www.gnu.org/software/make/manual/}
}
\seealso{
\code{\link{makefile}}

Other items: \code{\link{make_comment}},
  \code{\link{make_def}}, \code{\link{make_group}},
  \code{\link{make_text}}
}

