% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{hist_plots_mortality}
\alias{hist_plots_mortality}
\title{hist_plots_mortality}
\usage{
hist_plots_mortality(mort_score, phenotypes)
}
\arguments{
\item{mort_score}{data.frame containing the mortality score}

\item{phenotypes}{data.frame containing age}
}
\value{
plotly image with the histogram of the mortality score separated in 3 age ranges
}
\description{
#' Function to plot the histogram of the mortality score separated for different age ranges as a plotly image
}
\examples{
library(MiMIR)
library(plotly)
#' #load the dataset
metabolic_measures <- synthetic_metabolic_dataset
phenotypes <- synthetic_phenotypic_dataset

#Compute the mortality score
mortScore<-comp.mort_score(metabolic_measures,quiet=TRUE)
#Plot the mortality score histogram at different ages
hist_plots_mortality(mortScore, phenotypes)

}
