% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrendsea.R
\name{centrendsea}
\alias{centrendsea}
\title{Trend analysis of censored data with a covariate and seasonal blocks}
\usage{
centrendsea(
  y.var,
  y.cens,
  x.var,
  time.var,
  season,
  R = 4999,
  nmin = 4,
  link = "identity",
  Smooth = "cs",
  printstat = TRUE,
  seaplots = TRUE
)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits}

\item{y.cens}{The column of indicators, where 1 (or \code{TRUE}) indicates a detectionlimit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{x.var}{Column of a covariate (not time).  \code{y.var} will be smoothed versus \code{x.var} and residuals taken to subtract out the relationship between \code{y} and \code{x}.}

\item{time.var}{Column of the numerical time variable, either a sequence of numbered days or decimal times, etc.  Will be the scale used for time in ATS trend analysis.}

\item{season}{Column of the seasonal variable.  Usually a text variable but may be numeric.  Will be converted to a factor..}

\item{R}{The number of repetitions in the permutation process.  R is often between 999 and 9999 (adding +1 to represent the observed test statistic produces 1000 to 10000 repetitions). By default R=4999. Increasing R results in lower variation in the p-values produced between runs.}

\item{nmin}{The minimum number of observations needed for the entire time period to be tested, per season.  For example, with 1 sample per year per season over an 8-year period, you have 8 observations for each season.  You can increase this number if you want a higher minimum.  Don’t decrease it below the default of 4.  If there are fewer than nmin values that season is skipped and not included in the overall test and a note of this will be printed in the console.}

\item{link}{Default = \code{"identity"} which means it uses data in the original units. See details.}

\item{Smooth}{Type of smoother used in the GAM. Default is \code{"cs"}, shrinkage cubic regression splines. See details for other options.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}

\item{seaplots}{logical 'TRUE'/'FALSE' option to print plots with trend line for each season.  Default is 'TRUE'.}
}
\value{
Prints four plots: 1. Y data vs X covariate with GAM Smooth, 2. Residuals from GAM Smooth vs X covariate, 3. histogram of the SK test results illlustrating the p-value, and 4. Seasonal Kendall trend line of residuals vs time.  Plots of data and SK trend line for each season are produced when the seaplots option is TRUE.

Returns the seasonal Kendall trend test results on residuals (intercept, slope, Kendall's tau, p-value for trend)
}
\description{
Computes the Seasonal Kendall trend test for censored data after adjustment of censored data for a covariate. The adjustment is by subtracting off a censored GAM smooth, removing the effect of the covariate.  Trend analysis is performed on the residuals from the GAM smooth.
}
\details{
Default \code{link} = identity. The y variables are then used in their original units. Other options are available see \code{cenGAM::tobit1} for more options.

Default \code{Smooth} is \code{"cs"} for shrinkage cubic regression splines. See \code{mgcv::smooth.terms} for other types of smoothing algorithms.  '"ts"' is a thin-plate regression spline and is also commonly used.

As with the censeaken function, observations are not edited when there are more data in some seasons than others. Seasons with more data will have more influence on the overall SK test than seasons with fewer data. To avoid this (as done with some Seasonal Kendall software) data in the seasons with more can be selectively deleted to better match the data frequency of the seasons with fewer data.
}
\examples{

data(Gales_Creek)
with(Gales_Creek,centrendsea(TCr,CrND,discharge,dectime,Season))
}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
\seealso{
\link[mgcv:gam]{mgcv::gam}
}
\keyword{GAM}
\keyword{Kendall}
\keyword{Seasonal}
\keyword{analysis}
\keyword{spline}
\keyword{trend}
