% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{calculate_drawdown_series}
\alias{calculate_drawdown_series}
\title{Calculate Drawdown Time Series}
\usage{
calculate_drawdown_series(values)
}
\arguments{
\item{values}{Numeric vector of portfolio values}
}
\value{
Numeric vector of drawdowns (as negative percentages)
}
\description{
Computes drawdown series from portfolio values.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
sel <- filter_top_n(momentum, n = 10)
W   <- weight_equally(sel)
res <- run_backtest(sample_prices_weekly, W)
dd_series <- calculate_drawdown_series(res$portfolio_values)
dd_stats  <- analyze_drawdowns(dd_series, res$returns)
}
