% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{simulate_dgm}
\alias{simulate_dgm}
\title{Simulate From Data-Generating Mechanism}
\usage{
simulate_dgm(dgm_name, settings)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM type}

\item{settings}{List containing the required parameters for the DGM or
numeric condition_id}
}
\value{
A data frame containing the generated data with standardized structure
}
\description{
This function provides a unified interface to various data-generating
mechanisms for simulation studies. The specific DGM is determined by
the first argument. See
\href{../doc/Adding_New_DGMs.html}{\code{vignette("Adding_New_DGMs", package = "PublicationBiasBenchmark")}}
for details of extending the package with new DGMs.
}
\section{Output Structure}{

The returned data frame follows a standardized schema that downstream
functions rely on. Across the currently implemented DGMs, the following
columns are used:
\itemize{
\item \code{yi} (numeric): The effect size estimate.
\item \code{sei} (numeric): Standard error of \code{yi}.
\item \code{ni} (integer): Total sample size for the estimate
(e.g., sum over groups where applicable).
\item \code{es_type} (character): Effect size type, used to disambiguate
the scale of \code{yi}. Currently used values are
\code{"SMD"} (standardized mean difference / Cohen's d),
\code{"logOR"} (log odds ratio), and \code{"none"}
(unspecified generic continuous coefficient).
\item \code{study_id} (integer/character, optional): Identifier of the
primary study/cluster when a DGM yields multiple estimates per study
(e.g., Alinaghi2018, PRE). If absent, each row is treated as an
independent study.
}
}

\examples{

simulate_dgm("Carter2019", 1)

simulate_dgm("Carter2019", list(mean_effect = 0, effect_heterogeneity = 0,
                       bias = "high", QRP = "high", n_studies = 10))

simulate_dgm("Stanley2017", list(environment = "SMD", mean_effect = 0,
                        effect_heterogeneity = 0, bias = 0, n_studies = 5,
                        sample_sizes = c(32,64,125,250,500)))


}
\seealso{
\code{\link[=validate_dgm_setting]{validate_dgm_setting()}},
\code{\link[=dgm.Stanley2017]{dgm.Stanley2017()}},
\code{\link[=dgm.Alinaghi2018]{dgm.Alinaghi2018()}},
\code{\link[=dgm.Bom2019]{dgm.Bom2019()}},
\code{\link[=dgm.Carter2019]{dgm.Carter2019()}}
}
