% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tacks.R
\name{tacks}
\alias{tacks}
\title{Beckett and Diaconis flipping tacks data}
\format{
A data frame with 320 observations on 2 variables.
\describe{
    \item{\code{x}}{a numeric vector giving the number of tacks landed point up.}
    \item{\code{k}}{a numeric vector giving the number of trials.}
}
}
\source{
Beckett, L. and Diaconis. P. (1994). Spectral analysis 
for discrete longitudinal data, Adv. Math., 103: 107-128.
}
\usage{
tacks
}
\description{
This data was generated by Beckett and Diaconis (1994).  
They describe it as follows: 
"The example involves repeated rolls of a common thumbtack.  A one was
recorded if the tack landed point up and a zero was recorded if the tack
landed point down.  All tacks started point down.  Each tack was flicked
or hit with the fingers from where it last rested.  A fixed tack was flicked
9 times. The data are recorded in Table 1.  There are 320 9-tuples.  These
arose from 16 different tacks, 2 ``flickers,''  and 10 surfaces.  The tacks
vary considerably in shape and in proportion of ones.  The surfaces varied
from rugs through tablecloths through bathroom floors."
Following Liu (1996), we treat the data as though they came from 
320 independent binomials.  See \code{demo(Bmix1)} for further details.
}
\references{
Liu, J.S. (1996). Nonparametric Hierarchical Bayes via 
Sequential Imputations.  \emph{Annals of Statistics}, 24: 911-930.
}
\keyword{datasets}
