% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RESTK_training.R
\name{RESTK_training}
\alias{RESTK_training}
\title{RESTK Training}
\usage{
RESTK_training(
  training_data = NULL,
  probs = NULL,
  probs_interest = NULL,
  bootstrap_size = NULL,
  bootstrap_training_sims = NULL
)
}
\arguments{
\item{training_data}{training data}

\item{probs}{Probabilities where maxk was evaluated}

\item{probs_interest}{Probabilities of interest to estimate}

\item{bootstrap_size}{size of bootstrap simulations on the training data}

\item{bootstrap_training_sims}{number of bootstrap simulations on the training data}
}
\value{
Returns the estimated maxk line from the probabilities of interest
}
\description{
\code{RESTK_training} function used to project the maxk line into the probabilities of interest
}
\examples{
training_data <- rnorm(1e3, mean = 100, sd = 10)
probs <- c(1-1e-1, 1-0.5e-1, 1-1e-2)
probs_interest <- c(1-1e-6, 1-1e-7)
bootstrap_size <- 1000
bootstrap_training_sims <- 100

maxk_line <- RESTK_training(training_data = training_data,
                           probs = probs,
                           probs_interest = probs_interest,
                           bootstrap_size = bootstrap_size,
                           bootstrap_training_sims = bootstrap_training_sims)
}
\keyword{RESTK}
