% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invgauss.R
\name{invgauss}
\alias{invgauss}
\alias{dinvgauss}
\alias{pinvgauss}
\alias{qinvgauss}
\alias{rinvgauss}
\title{Inverse Gaussian distribution}
\usage{
dinvgauss(x, mean = 1, shape = 1, log = FALSE)

pinvgauss(q, mean = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

qinvgauss(p, mean = 1, shape = 1, lower.tail = TRUE, log.p = FALSE, ...)

rinvgauss(n, mean = 1, shape = 1)
}
\arguments{
\item{x, q}{vector of quantiles, must be positive.}

\item{mean}{location parameter}

\item{shape}{shape parameter, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{...}{additional parameter passed to \code{statmod::qinvgauss} for numerical evaluation of the quantile function.}

\item{n}{number of random values to return}
}
\value{
\code{dinvgauss} gives the density, \code{pinvgauss} gives the distribution function, \code{qinvgauss} gives the quantile function, and \code{rinvgauss} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the inverse Gaussian distribution.
}
\details{
This implementation of \code{dinvgauss} allows for automatic differentiation with \code{RTMB}.
\code{qinvgauss} and \code{rinvgauss} are imported from the \code{statmod} package.
}
\examples{
x <- rinvgauss(1, 1, 0.5)
d <- dinvgauss(x, 1, 0.5)
p <- pinvgauss(x, 1, 0.5)
q <- qinvgauss(p, 1, 0.5)
}
