% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.bin_width_estimator.R
\name{bin_width_estimator}
\alias{bin_width_estimator}
\title{bin_width_estimator method}
\usage{
bin_width_estimator(X, method = "auto")
}
\arguments{
\item{X}{[matrix] A matrix containing data, nrow = n_samples,
ncol = n_features}

\item{method}{[string] Method to estimate bin_width, values are "auto", "FD"
(Friedman Draconis, robust over outliners) or "Sturges". If "auto" is
used and if nrow(X) < 1000, "Sturges" is used, else "FD" is used.}
}
\value{
[vector] Lenght of bins
}
\description{
Lenght of cell to compute an histogram
}
\examples{
X = base::cbind( stats::rnorm( n = 2000 ) , stats::rexp(2000) )
## Friedman Draconis is used
binw_width = SBCK::bin_width_estimator( X , method = "auto" ) 
X = stats::rnorm( n = 500 )
## Sturges is used
binw_width = SBCK::bin_width_estimator( X , method = "auto" ) 

}
