% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{sampler.rj}
\alias{sampler.rj}
\title{reversible jump Markov chain Monte Carlo split-merge sampler}
\usage{
sampler.rj(currsbm, edges, sbmmod, sigma, rho = 10)
}
\arguments{
\item{currsbm}{the current state of the sampler}

\item{edges}{an \code{\link{edges}} object}

\item{sbmmod}{an \code{\link{sbmmod}} model}

\item{sigma}{random walk parameter for \code{theta}}

\item{rho}{propensity to add a block}
}
\value{
next state of \code{currsbm} object
}
\description{
reversible jump Markov chain Monte Carlo split-merge sampler
}
\examples{
model <- sbmmod(dma(1,10), param_nbin(1,1,4,4,0.5,0.5,0.5,0.5), edges_nbin())
trueSBM <- model$r(100)
Edges <- redges(trueSBM, model$edge)
rj_out <- sampler(Edges, model, 10, "rj", sigma=0.1)
}
\seealso{
For full algorithm details see \url{http://doi.org/10.17635/lancaster/thesis/296}
}
