% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-plate-outputs.R
\name{merge_plate_outputs}
\alias{merge_plate_outputs}
\title{Merge Normalised Data from Multiple Plates}
\usage{
merge_plate_outputs(
  plates,
  normalisation_type,
  column_collision_strategy = "intersection",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{plates}{A named list of \code{\link{Plate}} objects, typically returned by \code{\link[=process_dir]{process_dir()}} with parameter \code{return_plates = TRUE}.}

\item{normalisation_type}{(\code{character(1)}) The type of normalisation to merge. Options: \code{"MFI"}, \code{"RAU"}, \code{"nMFI"}.}

\item{column_collision_strategy}{(\code{character(1)}, default = \code{"intersection"})
\itemize{
\item Determines how to handle mismatched columns across plates.
\item Options: \code{"intersection"} (only shared columns), \code{"union"} (include all columns).
}}

\item{verbose}{(\code{logical(1)}, default = \code{TRUE}) Whether to print verbose output.}

\item{...}{Additional arguments passed to \code{\link[=process_plate]{process_plate()}}, such as \code{sample_type_filter = "TEST"}
to include only certain sample types in the merged result.}
}
\value{
A merged \code{data.frame} containing normalised data across all plates.
}
\description{
This function merges normalised data from a list of \code{\link{Plate}} objects into a single \code{data.frame}.
It supports different normalisation types and handles column mismatches based on the specified strategy.
}
\examples{
# creating temporary directory for the example
output_dir <- tempdir(check = TRUE)

dir_with_luminex_files <- system.file("extdata", "multiplate_reallife_reduced",
  package = "SerolyzeR", mustWork = TRUE
)
list_of_plates <- process_dir(dir_with_luminex_files,
  return_plates = TRUE, format = "xPONENT", output_dir = output_dir
)

df <- merge_plate_outputs(list_of_plates, "RAU", sample_type_filter = c("TEST", "STANDARD CURVE"))

}
