# SouthKoreAPIs - Access South Korean Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# get_country_info_kr

library(testthat)

test_that("get_country_info_kr() devuelve tibble con estructura correcta", {
  result <- get_country_info_kr()

  expect_s3_class(result, "tbl_df")
  expect_named(result, c("name_common", "name_official", "region", "subregion",
                         "capital", "area", "population", "languages"))
  expect_equal(nrow(result), 1)
  expect_equal(ncol(result), 8)
})

test_that("get_country_info_kr() devuelve datos de tipo correcto", {
  result <- get_country_info_kr()

  expect_type(result$name_common, "character")
  expect_type(result$name_official, "character")
  expect_type(result$region, "character")
  expect_type(result$subregion, "character")
  expect_type(result$capital, "character")
  expect_type(result$area, "double")
  expect_type(result$population, "integer")
  expect_type(result$languages, "character")
})

test_that("get_country_info_kr() devuelve valores esperados", {
  result <- get_country_info_kr()

  expect_equal(result$name_common, "South Korea")
  expect_equal(result$name_official, "Republic of Korea")
  expect_equal(result$region, "Asia")
  expect_equal(result$subregion, "Eastern Asia")
  expect_equal(result$capital, "Seoul")
  expect_true(result$area > 90000)
  expect_true(result$population > 50000000)
  expect_true(grepl("Korean", result$languages))
})
