% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{testModel}
\alias{testModel}
\title{Computes a classification from a pretrained discriminant}
\usage{
testModel(model, test, labels, returnClassification = FALSE, ...)
}
\arguments{
\item{model}{Trained linear discriminant.
see \code{\link{trainModel}}}

\item{test}{MultiWaveAnalysis class object to be used as test set.}

\item{labels}{Vector that determines the class to which each of the
observations provided in the test set belongs.}

\item{returnClassification}{Allows to select if the raw result classification
is returned.}

\item{...}{Additional arguments}
}
\value{
\itemize{
\item if returnClassification is false return a object of class
confusionMatrix
\item if returnClassification is true, it returns a list containing an
object of the confusionMatrix class and a vector with the
classification result.
}
}
\description{
This function uses a pretrained linear discriminant to classify a set of
test data. As output it returns a confusion matrix and optionally the raw
classification result.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# The dataset has the first 5 elements of class 1
# and the last 5 of class 2.
labels <- c(rep(1, 5), rep(2, 5))
MWA <- generateStepDiscrim(ECGExample, labels, "haar", maxvars = 5, features = c("var"))
aux <- extractSubset(MWA, c(1, 2, 9, 10))
MWATest <- aux[[1]]
MWATrain <- aux[[2]]
ldaDiscriminant <- trainModel(MWATrain, labels[3:8], "linear")
CM <- testModel(ldaDiscriminant, MWATest, labels[c(1, 2, 9, 10)])
}

}
\seealso{
\code{\link{testModel}}
}
