% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_helpers.R
\name{extract_all_metrics}
\alias{extract_all_metrics}
\title{Extract all metrics from QCA solution object}
\usage{
extract_all_metrics(IC, sol_obj = NULL)
}
\arguments{
\item{IC}{IC object from QCA solution.}

\item{sol_obj}{Full solution object (optional, for fallback).}
}
\value{
List with elements:
  \itemize{
    \item \code{sol_inclS} — solution consistency (or NA)
    \item \code{sol_PRI} — solution PRI (or NA)
    \item \code{sol_covS} — solution coverage (or NA)
    \item \code{term_df} — data frame of per-term metrics (or NULL)
  }
}
\description{
Safely extracts solution-level and term-level metrics from
various QCA solution object structures. Handles cases where
multiple solutions exist and sol.incl.cov may be NULL.
}
\keyword{internal}
