% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/modelling.R
\name{fit_msm}
\alias{fit_msm}
\alias{fit_msm,trial_sequence-method}
\title{Fit the marginal structural model for the sequence of emulated trials}
\usage{
fit_msm(
  object,
  weight_cols = c("weight", "sample_weight"),
  modify_weights = NULL
)

\S4method{fit_msm}{trial_sequence}(
  object,
  weight_cols = c("weight", "sample_weight"),
  modify_weights = NULL
)
}
\arguments{
\item{object}{A \code{trial_sequence} object}

\item{weight_cols}{character vector of column names in expanded outcome dataset, ie \code{outcome_data(object)}. If
multiple columns are specified, the element wise product will be used. Specify \code{NULL} if no weight columns should be
used.}

\item{modify_weights}{a function to transform the weights (or \code{NULL} for no transformation).
Must take a numeric vector of weights and a vector of positive, finite weights of the same length.
See examples for some possible function definitions.

Before the outcome marginal structural model can be fit, the outcome model must be specified with
\code{\link[=set_outcome_model]{set_outcome_model()}} and the data must be expanded into the trial sequence with \code{\link[=expand_trials]{expand_trials()}}.

The model is fit based on the \code{model_fitter} specified in \link{set_outcome_model} using the internal \code{fit_outcome_model}
method.}
}
\value{
A modified \code{trial_sequence} object with updated \code{outcome_model} slot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
trial_seq_object <- trial_sequence("ITT") |>
  set_data(data_censored) |>
  set_outcome_model(
    adjustment_terms = ~age_s,
    followup_time_terms = ~ stats::poly(followup_time, degree = 2)
  ) |>
  set_expansion_options(output = save_to_datatable(), chunk_size = 500) |>
  expand_trials() |>
  load_expanded_data()

fit_msm(trial_seq_object)

# Using modify_weights functions ----

# returns a function that truncates weights to limits
limit_weight <- function(lower_limit, upper_limit) {
  function(w) {
    w[w > upper_limit] <- upper_limit
    w[w < lower_limit] <- lower_limit
    w
  }
}

# calculate 1st and 99th percentile limits and truncate
p99_weight <- function(w) {
  p99 <- quantile(w, prob = c(0.01, 0.99), type = 1)
  limit_weight(p99[1], p99[2])(w)
}

# set all weights to 1
all_ones <- function(w) {
  rep(1, length(w))
}

fit_msm(trial_seq_object, modify_weights = limit_weight(0.01, 4))
fit_msm(trial_seq_object, modify_weights = p99_weight)
}
