% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VUSvar.R
\name{VUSvar}
\alias{VUSvar}
\title{Variance of the volume under the ROC surface}
\usage{
VUSvar(y, fx, ncores = 1, clusterType = "SOCK")
}
\arguments{
\item{y}{a vector of realized categories.}

\item{fx}{a vector of predicted values of the ranking function f.}

\item{ncores}{number of cores to be used for parallelized computations. The default value is 1.}

\item{clusterType}{type of cluster to be initialized in case more than one core is used for calculations. The default values is "SOCK". For details regarding the different types to be used, see \code{\link[parallel]{makeCluster}}.}
}
\value{
The implemented algorithm is based on Waegeman, De Baets and Boullart (2008). A list of length two is returned, containing the following components:
\item{var}{variance of the volume under the ROC surface}
\item{val}{volume under the ROC surface}
}
\description{
Computes the volume under the ROC surface (VUS) and its variance for a vector of realisations \code{y} (i.e. realised categories) and a vector of predictions \code{fx} (i.e. values of the a ranking function f) for the purpose of assessing the discrimiatory power in a multi-class classification problem.
}
\examples{
VUSvar(rep(1:5,each=3),c(1,2,3,rep(2:5,each=3)))
}
\references{
Waegeman W., De Baets B., Boullart L., 2008. On the scalability of ordered multi-class ROC analysis. Computational Statistics & Data Analysis 52, 3371-3388.
}
