% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_imputation_target_date}
\alias{get_imputation_target_date}
\title{Get Date Imputation Targets}
\usage{
get_imputation_target_date(date_imputation, month)
}
\arguments{
\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

A character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the 15th
of June,
\item or as a keyword: \code{"first"}, \code{"mid"}, \code{"last"} to impute to the first/mid/last
day/month.
}

\describe{
\item{Default value}{none}
}}

\item{month}{Month component of the partial date

\describe{
\item{Default value}{none}
}}
}
\value{
A list of character vectors. The elements of the list are named
"year", "month", "day".
}
\description{
Get Date Imputation Targets
}
\details{
\itemize{
\item For \code{date_imputation = "first"} \code{"0000"}, \code{"01"}, \code{"01"} are returned.
\item For \code{date_imputation = "mid"} \code{"xxxx"}, \code{"06"}, \code{"30"} if \code{month} is \code{NA}.
otherwise \code{"15"} returned.
\item For \code{date_imputation = "last"} \code{"9999"}, \code{"12"}, \code{"28"} are returned.
\item For \code{date_imputation = "<mm>-<dd>"} \code{"xxxx"}, \code{"<mm>"}, \code{"<dd>"} are returned.
}

\code{"xxxx"} indicates that the component is undefined. If an undefined
component occurs in the imputed \code{--DTC} value, the imputed \code{--DTC} value is set to
\code{NA_character_} in the imputation functions.
}
\examples{
# Get imputation target for "first"
target_first <- admiral:::get_imputation_target_date("first", month = NA)
print(target_first)

# Get imputation target for "mid" with specified month
target_mid <- admiral:::get_imputation_target_date("mid", month = "03")
print(target_mid)

# Get imputation target for "mid" with NA month
target_mid_na <- admiral:::get_imputation_target_date("mid", month = NA)
print(target_mid_na)

# Get imputation target for "last"
target_last <- admiral:::get_imputation_target_date("last", month = NA)
print(target_last)

# Get imputation target for custom date imputation "06-15"
target_custom <- admiral:::get_imputation_target_date("06-15", month = NA)
print(target_custom)

}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}, \code{\link[=impute_dtc_dt]{impute_dtc_dt()}}

Utilities used for date imputation:
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_time}()},
\code{\link{get_partialdatetime}()},
\code{\link{restrict_imputed_dtc_dt}()},
\code{\link{restrict_imputed_dtc_dtm}()}
}
\concept{utils_impute}
\keyword{internal}
