% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_coord.r
\name{as_coord3d}
\alias{as_coord3d}
\alias{as_coord3d.angle}
\alias{as_coord3d.character}
\alias{as_coord3d.data.frame}
\alias{as_coord3d.list}
\alias{as_coord3d.matrix}
\alias{as_coord3d.numeric}
\alias{as_coord3d.Coord3D}
\alias{as_coord3d.Coord2D}
\title{Cast to coord3d object}
\usage{
as_coord3d(x, ...)

\method{as_coord3d}{angle}(x, radius = 1, inclination = NULL, z = NULL, ...)

\method{as_coord3d}{character}(x, ...)

\method{as_coord3d}{data.frame}(x, ..., z = NULL)

\method{as_coord3d}{list}(x, ..., z = NULL)

\method{as_coord3d}{matrix}(x, ...)

\method{as_coord3d}{numeric}(x, y = rep_len(0, length(x)), z = rep_len(0, length(x)), ...)

\method{as_coord3d}{Coord3D}(x, ...)

\method{as_coord3d}{Coord2D}(x, z = rep_len(0, length(x)), ...)
}
\arguments{
\item{x}{An object that can be cast to a \link{Coord3D} class object
such as a matrix or data frame of coordinates.}

\item{...}{Further arguments passed to or from other methods}

\item{radius}{A numeric vector.  If \code{inclination} is not \code{NULL} represents spherical distances
of spherical coordinates and if \code{z} is not \code{NULL} represents
radial distances of cylindrical coordinates.}

\item{inclination}{Spherical coordinates inclination angle aka polar angle.
\code{x} represents the azimuth aka azimuthal angle.}

\item{z}{Numeric vector of z-coordinates to be used}

\item{y}{Numeric vector of y-coordinates to be used
if \code{hasName(x, "z")} is \code{FALSE}.}
}
\value{
A \link{Coord3D} class object
}
\description{
\code{as_coord3d()} casts to a \link{Coord3D} class object
}
\examples{
as_coord3d(x = 1, y = 2, z = 3)
df <- data.frame(x = sample.int(10, 3),
                 y = sample.int(10, 3),
                 z = sample.int(10, 3))
as_coord3d(df)
# Cylindrical coordinates
as_coord3d(degrees(90), z = 1, radius = 1)
# Spherical coordinates
as_coord3d(degrees(90), inclination = degrees(90), radius = 1)
}
