% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_aggpref.R
\name{ahp.aggpref}
\alias{ahp.aggpref}
\title{Aggregate priority weights}
\usage{
ahp.aggpref(ahpmat, atts, method = "geometric", aggmethod = method, qt = 0)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{a list of attributes in the correct order}

\item{method}{if \code{method = "eigen"}, the individual priority weights are computed using the Dominant Eigenvalues method described in \insertCite{Saaty2003;textual}{ahpsurvey}. Otherwise, then the priorities are computed based on the averages of normalized values. Basically it normalizes the matrices so that all of the columns add up to 1, and then computes the averages of the row as the priority weights of each attribute. Three modes of finding the averages are available:  \code{arithmetic}: the arithmetic mean; \code{geometric}: the geometric mean (the default); \code{rootmean}: the square root of the sum of the squared value.}

\item{aggmethod}{how to aggregate the individual priorities. By default \code{aggmethod = method}. Apart from the methods offered in \code{method}, \code{aggmethod} also permits three other options: \code{tmean} computes the trimmed arithmetic mean, \code{tgmean} computes the trimmed geometric mean (both with quantiles trimmed based on \code{qt}), and \code{sd} computes the standard deviation from the arithmetic mean. If \code{method = "eigen"} and \code{aggmethod} is not specified, \code{aggmethod} defaults to \code{"geometric"}.}

\item{qt}{specifies the quantile which the top \strong{and} bottom priority weights are trimmed. Used only if \code{aggmethod = 'tmean'} or \code{aggmethod = 'tgmean'}. For example, \code{qt = 0.25} specifies that the aggregation is the arithmetic mean of the values from the 25 to 75 percentile. By default \code{qt = 0}.}
}
\value{
A \code{data.frame} of the aggregated priorities of all the decision-makers.
}
\description{
Compute and aggregate individual priority weights from pairwise comparison matrices
}
\examples{

## Computes individual priorities with geometric mean and aggregates them
## with a trimmed arithmetic mean

library(magrittr)

data(city200)
atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

cityahp <- ahp.mat(df = city200, atts = atts, negconvert = TRUE)
ahp.aggpref(cityahp, atts, method = 'geometric', aggmethod = 'tmean', qt = 0.1)

}
\references{
\insertAllCited{}
}
\author{
Frankie Cho
}
