% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{re}
\alias{re}
\title{Relative efficiency (RE) calculation}
\usage{
re(od, subod, rounded = TRUE, verbose = TRUE)
}
\arguments{
\item{od}{Returned object of first design (e.g., unconstrained optimal design)
from function \code{\link{od.1.eq}}.}

\item{subod}{Returned object of second design (e.g., constrained optimal design)
from function \code{\link{od.1.eq}}.}

\item{rounded}{Logical; round the values of \code{p}
to two decimal places if TRUE.
No rounding if FALSE; default is TRUE.}

\item{verbose}{Logical; print the value of relative efficiency if TRUE,
otherwise not; default is TRUE.}
}
\value{
Relative efficiency value.
}
\description{
Calculate the relative efficiency (RE) between two designs using
   the re function from the R package odr.
}
\examples{
# Unconstrained optimal design #----------
  myod1 <- od.1.eq(r12 = 0.5, c1 = 1, c1t = 20)
# Constrained optimal design with p = .50
  myod2 <- od.1.eq(r12 = 0.5, c1 = 1, c1t = 20, p = .50)
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.71

}
