% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{RW2}
\alias{RW2}
\title{Second-Order Random Walk Prior}
\usage{
RW2(s = 1, sd = 1, sd_slope = 1, along = NULL, con = c("none", "by"))
}
\arguments{
\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{sd}{Standard deviation
of initial value. Default is \code{1}. Can be \code{0}.}

\item{sd_slope}{Standard deviation
of initial slope. Default is \code{1}.}

\item{along}{Name of the variable to be used
as the 'along' variable. Only used with
interactions.}

\item{con}{Constraints on parameters.
Current choices are \code{"none"} and \code{"by"}.
Default is \code{"none"}. See below for details.}
}
\value{
An object of class \code{"bage_prior_rw2random"}
or \code{"bage_prior_rw2zero"}.
}
\description{
Use a second-order random walk as a model for
a main effect, or use multiple second-order random walks
as a model for an interaction.
A second-order random walk is
a random walk with drift where the
drift term varies. It is typically
used with terms that involve age or time,
where there are sustained
trends upward or downward.
}
\details{
If \code{RW2()} is used with an interaction,
a separate random walk is constructed
within each combination of the
'by' variables.

Argument \code{s} controls the size of innovations.
Smaller values for \code{s} tend to give smoother series.

Argument \code{sd} controls variance in
initial values. Setting \code{sd} to \code{0} fixes
initial values at \code{0}.

Argument \code{sd_slope} controls variance in the
initial slope.
}
\section{Mathematical details}{


When \code{RW2()} is used with a main effect,

\deqn{\beta_1 \sim \text{N}(0, \mathtt{sd}^2)}
\deqn{\beta_2 \sim \text{N}(\beta_1, \mathtt{sd\_slope}^2)}
\deqn{\beta_j \sim \text{N}(2 \beta_{j-1} - \beta_{j-2}, \tau^2), \quad j = 2, \cdots, J}

and when it is used with an interaction,

\deqn{\beta_{u,1} \sim \text{N}(0, \mathtt{sd}^2)}
\deqn{\beta_{u,2} \sim \text{N}(\beta_{u,1}, \mathtt{sd\_slope}^2)}
\deqn{\beta_{u,v} \sim \text{N}(2\beta_{u,v-1} - \beta_{u,v-2}, \tau^2), \quad v = 3, \cdots, V}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the 'along' variable of the interaction; and
\item \eqn{u} denotes position within the 'by' variable(s) of the interaction.
}

Parameter \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \mathtt{s}^2)}.
}

\section{Constraints}{


With some combinations of terms and priors, the values of
the intercept, main effects, and interactions are
are only weakly identified.
For instance, it may be possible to increase the value of the
intercept and reduce the value of the remaining terms in
the model with no effect on predicted rates and only a tiny
effect on prior probabilities. This weak identifiability is
typically harmless. However, in some applications, such as
when trying to obtain interpretable values
for main effects and interactions, it can be helpful to increase
identifiability through the use of constraints, specified through the
\code{con} argument.

Current options for \code{con} are:
\itemize{
\item \code{"none"} No constraints. The default.
\item \code{"by"} Only used in interaction terms that include 'along' and
'by' dimensions. Within each value of the 'along'
dimension, terms across each 'by' dimension are constrained
to sum to 0.
}
}

\examples{
RW2()
RW2(s = 0.5)
}
\seealso{
\itemize{
\item \code{\link[=RW]{RW()}} Random walk
\item \code{\link[=RW2_Seas]{RW2_Seas()}} Second order random walk with seasonal effect
\item \code{\link[=AR]{AR()}} Autoregressive with order k
\item \code{\link[=AR1]{AR1()}} Autoregressive with order 1
\item \code{\link[=Sp]{Sp()}} Smoothing via splines
\item \code{\link[=SVD]{SVD()}} Smoothing over age via singular value decomposition
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig2_math.html}{Mathematical Details}
vignette
}
}
