% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{logit}
\alias{logit}
\title{Logit likelihood function}
\usage{
logit(start, data, Log = TRUE)
}
\arguments{
\item{start}{vector of starting values}

\item{data}{dataframe. The first column should be the dependent variable.}

\item{Log}{a logical input (defaults to \code{True}) to take the log of the likelihood.}
}
\value{
like returns the likelihood function value.
}
\description{
\code{logit} is the logistic likelihood function given data.
}
\examples{
y = indicat(faithful$waiting,mean(faithful$waiting)) 
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
data = data.frame(y,x)
logit(rep(0,3),data)
}
