% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchIrace.R
\name{mlr_optimizers_irace}
\alias{mlr_optimizers_irace}
\alias{OptimizerBatchIrace}
\title{Iterated Racing}
\source{
Lopez-Ibanez M, Dubois-Lacoste J, Caceres LP, Birattari M, Stuetzle T (2016).
\dQuote{The irace package: Iterated racing for automatic algorithm configuration.}
\emph{Operations Research Perspectives}, \bold{3}, 43--58.
\doi{https://doi.org/10.1016/j.orp.2016.09.002}.
}
\description{
\code{OptimizerBatchIrace} class that implements iterated racing.
Calls \code{\link[irace:irace]{irace::irace()}} from package \CRANpkg{irace}.
}
\section{Parameters}{

\describe{
\item{\code{instances}}{\code{list()}\cr
A list of instances where the configurations executed on.}
\item{\code{targetRunnerParallel}}{\verb{function()}\cr
A function that executes the objective function with a specific parameter configuration and instance.
A default function is provided, see section "Target Runner and Instances".}
}

For the meaning of all other parameters, see \code{\link[irace:defaultScenario]{irace::defaultScenario()}}.
}

\section{Internal Termination Parameters}{

The algorithm can terminated with \link{TerminatorEvals}.
Other \link{Terminator}s do not work with \code{OptimizerBatchIrace}.
Additionally, the following internal termination parameters can be used:

\describe{
\item{\code{maxExperiments}}{\code{integer(1)}\cr
Maximum number of runs (invocations of targetRunner) that will be performed.
It determines the maximum budget of experiments for the tuning.
Default is 0.}
\item{\code{minExperiments}}{\code{integer(1)}\cr
Minimum number of runs (invocations of targetRunner) that will be performed.
It determines the minimum budget of experiments for the tuning.
The actual budget depends on the number of parameters and minSurvival.
Default is NA.}
\item{\code{maxTime}}{\code{integer(1)}\cr
Maximum total execution time for the executions of targetRunner.
targetRunner must return two values: cost and time.
This value and the one returned by targetRunner must use the same units (seconds, minutes, iterations, evaluations, ...).
Default is 0.}
\item{\code{budgetEstimation}}{\code{numeric(1)}\cr
Fraction (smaller than 1) of the budget used to estimate the mean computation time of a configuration.
Only used when maxTime > 0
Default is 0.05.}
\item{\code{minMeasurableTime}}{\code{numeric(1)}\cr
Minimum time unit that is still (significantly) measureable.
Default is 0.01.}
}
}

\section{Initial parameter values}{

\itemize{
\item \code{digits}:
\itemize{
\item Adjusted default: 15.
\item This represents double parameters with a higher precision and avoids rounding errors.
}
}
}

\section{Target Runner and Instances}{

The irace package uses a \code{targetRunner} script or R function to evaluate a configuration on a particular instance.
Usually it is not necessary to specify a \code{targetRunner} function when using \code{OptimizerBatchIrace}.
A default function is used that forwards several configurations and instances to the user defined objective function.
As usually, the user defined function has  a \code{xs}, \code{xss} or \code{xdt} parameter depending on the used \link{Objective} class.
For irace, the function needs an additional \code{instances} parameter.

\if{html}{\out{<div class="sourceCode">}}\preformatted{fun = function(xs, instances) \{
 # function to evaluate configuration in `xs` on instance `instances`
\}
}\if{html}{\out{</div>}}
}

\section{Archive}{

The \link{Archive} holds the following additional columns:
\itemize{
\item \code{"race"} (\code{integer(1)})\cr
Race iteration.
\item \code{"step"} (\code{integer(1)})\cr
Step number of race.
\item \code{"instance"} (\code{integer(1)})\cr
Identifies instances across races and steps.
\item \code{"configuration"} (\code{integer(1)})\cr
Identifies configurations across races and steps.
}
}

\section{Result}{

The optimization result (\code{instance$result}) is the best performing elite of the final race.
The reported performance is the average performance estimated on all used instances.
}

\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("irace")
opt("irace")
}\if{html}{\out{</div>}}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
\dontshow{if (requireNamespace("irace", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}
# runtime of the example is too long
\donttest{

library(data.table)

search_space = domain = ps(
  x1 = p_dbl(-5, 10),
  x2 = p_dbl(0, 15)
)

codomain = ps(y = p_dbl(tags = "minimize"))

# branin function with noise
# the noise generates different instances of the branin function
# the noise values are passed via the `instances` parameter
fun = function(xdt, instances) {
  ys = branin(xdt[["x1"]], xdt[["x2"]], noise = as.numeric(instances))
  data.table(y = ys)
}

# define objective with instances as a constant
objective = ObjectiveRFunDt$new(
 fun = fun,
 domain = domain,
 codomain = codomain,
 constants = ps(instances = p_uty()))

instance = OptimInstanceBatchSingleCrit$new(
  objective = objective,
  search_space = search_space,
  terminator = trm("evals", n_evals = 96))

# create instances of branin function
instances = rnorm(10, mean = 0, sd = 0.1)

# load optimizer irace and set branin instances
optimizer = opt("irace", instances = instances)

# modifies the instance by reference
optimizer$optimize(instance)

# best scoring configuration
instance$result

# all evaluations
as.data.table(instance$archive)
}
}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchIrace}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchIrace-new}{\code{OptimizerBatchIrace$new()}}
\item \href{#method-OptimizerBatchIrace-clone}{\code{OptimizerBatchIrace$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchIrace-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchIrace-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchIrace$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchIrace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchIrace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchIrace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
