% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackAsync.R
\name{callback_async}
\alias{callback_async}
\title{Create Asynchronous Optimization Callback}
\usage{
callback_async(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_worker_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_optimizer_after_eval = NULL,
  on_worker_end = NULL,
  on_result_begin = NULL,
  on_result_end = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization in the main process.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_worker_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization on the worker.
Called in the worker loop.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$.eval_point()}.
The functions must have two arguments named \code{callback} and \code{context}.
The argument of \code{instance$.eval_point(xs)} and \code{xs_trafoed} and \code{extra} are available in the \code{context}.
Or \code{xs} and \code{xs_trafoed} of \code{instance$.eval_queue()} are available in the \code{context}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$.eval_point()}.
The functions must have two arguments named \code{callback} and \code{context}.
The outcome \code{y} is available in the \code{context}.}

\item{on_worker_end}{(\verb{function()})\cr
Stage called at the end of the optimization on the worker.
Called in the worker loop.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_result_begin}{(\verb{function()})\cr
Stage called before result are written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$.assign_result(xdt, y, extra)} are available in the \code{context}.}

\item{on_result_end}{(\verb{function()})\cr
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The final result \code{instance$result} is available in the \code{context}.}

\item{on_result}{(\verb{function()})\cr
Deprecated.
Use \code{on_result_end} instead.
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization in the main process.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}
}
\value{
\link{CallbackAsync}
}
\description{
Function to create a \link{CallbackAsync}.

Optimization callbacks can be called from different stages of optimization process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Optimization
     - on_optimization_begin
    Start Worker
         - on_worker_begin
           Start Optimization on Worker
             - on_optimizer_before_eval
             - on_optimizer_after_eval
           End Optimization on Worker
         - on_worker_end
    End Worker
     - on_result_begin
     - on_result_end
     - on_optimization_end
End Optimization
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A optimization callback works with \link{ContextAsync}.
}
\details{
A callback can write data to its state (\verb{$state}), e.g. settings that affect the callback itself.
The \link{ContextAsync} allows to modify the instance, archive, optimizer and final result.
}
