% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal_lister.R
\name{principal_lister}
\alias{principal_lister}
\title{Function of principal scientifics references}
\usage{
principal_lister(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database}

\item{input_tam}{is the length of the dataframe to be generated with the main articles, authors and journals}
}
\value{
This function returns a list object with two dataframes. The first dataframe, with a length defined by the user, containing the list of articles ordered by the number of citations crossed with the lists of authors and journals ordered by the number of articles published. The second dataframe contains quantitative parameters about authors and journals that are necessary to create the quantitative validation criterion for the list obtained.
}
\description{
This function generates a list, with a size defined by the user, with the main scientific references and also generates quantitative parameters about authors and journals.
}
\examples{
#Call the principal_lister function

# Example 1
input_tam <- 80
file_db <- system.file("extdata","example_database.csv", package = "bibliorefer")
separator <- ","
input_date <- example_database(file_db, separator)
principal_refer <- principal_lister(input_date,input_tam)
principal_refer[[1]]

# Example 2
input_tam <- 40
file_db <- system.file("extdata","example_database.csv", package = "bibliorefer")
separator <- ","
input_date <- example_database(file_db, separator)
principal_refer <- principal_lister(input_date,input_tam)
principal_refer[[1]]

}
\references{
A bibliometric analysis of Journal of Higher Education Management (JHEM) from 2007 to 2016. Antia-Obong, S.E., Casselden, B., Pickard, A. Library Philosophy and Practice, 2019.
}
