% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_0.R
\docType{class}
\name{BIOMOD.models.options}
\alias{BIOMOD.models.options}
\alias{BIOMOD.models.options-class}
\alias{show,BIOMOD.models.options-method}
\alias{print,BIOMOD.models.options-method}
\title{\code{\link{bm_ModelingOptions}} output object class}
\usage{
\S4method{show}{BIOMOD.models.options}(object)

\S4method{print}{BIOMOD.models.options}(x, dataset = "_allData_allRun")
}
\arguments{
\item{object}{a \code{\link{BIOMOD.models.options}} object}

\item{x}{a \code{\link{BIOMOD.models.options}} object}

\item{dataset}{a \code{character} corresponding to the name of a dataset contained 
in the \code{arg.values} slot of the \code{\link{BIOMOD.options.dataset}} object 
for each model}
}
\description{
Class returned by \code{\link{bm_ModelingOptions}} and used by 
\code{\link{BIOMOD_Modeling}}
}
\section{Slots}{

\describe{
\item{\code{models}}{a \code{vector} containing model names for which options have 
been retrieved and defined, must be \code{algo.datatype.package.function}}

\item{\code{options}}{a \code{list} containing \code{\link{BIOMOD.options.dataset}} 
object for each model}
}}

\examples{

showClass("BIOMOD.models.options")


}
\seealso{
\code{\link{BIOMOD.options.default}}, 
\code{\link{BIOMOD.options.dataset}}, 
\code{\link{bm_ModelingOptions}}, \code{\link{bm_Tuning}}, 
\code{\link{BIOMOD_Modeling}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.rangesize.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Maya Guéguen
}
\concept{Toolbox objects}
