% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_6_plot.R
\name{theme_bruce}
\alias{theme_bruce}
\title{A nice \code{ggplot2} theme that enables Markdown/HTML rich text.}
\usage{
theme_bruce(
  markdown = FALSE,
  base.size = 12,
  line.width = 0.5,
  border = "black",
  bg = "white",
  panel.bg = "white",
  tag = "bold",
  plot.title = "bold",
  axis.title = "plain",
  title.pos = 0.5,
  subtitle.pos = 0.5,
  caption.pos = 1,
  font = NULL,
  grid.x = "",
  grid.y = "",
  line.x = TRUE,
  line.y = TRUE,
  tick.x = TRUE,
  tick.y = TRUE
)
}
\arguments{
\item{markdown}{Use \code{element_markdown()} instead of \code{element_text()}. Defaults to \code{FALSE}.
If set to \code{TRUE}, then you should also use \code{element_markdown()} in \code{theme()} (if any).}

\item{base.size}{Basic font size. Defaults to \code{12}.}

\item{line.width}{Line width. Defaults to \code{0.5}.}

\item{border}{\code{TRUE}, \code{FALSE}, or \code{"black"} (default).}

\item{bg}{Background color of whole plot. Defaults to \code{"white"}.
You can use any colors or choose from some pre-set color palettes:
\code{"stata"}, \code{"stata.grey"}, \code{"solar"}, \code{"wsj"}, \code{"light"}, \code{"dust"}.}

\item{panel.bg}{Background color of panel. Defaults to \code{"white"}.}

\item{tag}{Font face of tag. Choose from \code{"plain"}, \code{"italic"}, \code{"bold"}, \code{"bold.italic"}.}

\item{plot.title}{Font face of title. Choose from \code{"plain"}, \code{"italic"}, \code{"bold"}, \code{"bold.italic"}.}

\item{axis.title}{Font face of axis text. Choose from \code{"plain"}, \code{"italic"}, \code{"bold"}, \code{"bold.italic"}.}

\item{title.pos}{Title position (0~1).}

\item{subtitle.pos}{Subtitle position (0~1).}

\item{caption.pos}{Caption position (0~1).}

\item{font}{Text font. Only applicable to Windows system.}

\item{grid.x}{\code{FALSE}, \code{""} (default), or a color (e.g., \code{"grey90"}) to set the color of panel grid (x).}

\item{grid.y}{\code{FALSE}, \code{""} (default), or a color (e.g., \code{"grey90"}) to set the color of panel grid (y).}

\item{line.x}{Draw the x-axis line. Defaults to \code{TRUE}.}

\item{line.y}{Draw the y-axis line. Defaults to \code{TRUE}.}

\item{tick.x}{Draw the x-axis ticks. Defaults to \code{TRUE}.}

\item{tick.y}{Draw the y-axis ticks. Defaults to \code{TRUE}.}
}
\value{
A \code{theme} object that should be used for \code{ggplot2}.
}
\description{
A nice \code{ggplot2} theme for scientific publication. It also uses \code{\link[ggtext:element_markdown]{ggtext::element_markdown()}} to render Markdown/HTML formatted rich text. You can use a combination of Markdown and/or HTML syntax (e.g., \code{"*y* = *x*<sup>2</sup>"}) in plot text or title, and this function draws text elements with rich text format.

For more usage, see:
\itemize{
\item \code{\link[ggtext:geom_richtext]{ggtext::geom_richtext()}}
\item \code{\link[ggtext:geom_textbox]{ggtext::geom_textbox()}}
\item \code{\link[ggtext:element_markdown]{ggtext::element_markdown()}}
\item \code{\link[ggtext:element_textbox]{ggtext::element_textbox()}}
}
}
\examples{
\donttest{## Example 1 (bivariate correlation)
d = as.data.table(psych::bfi)
added(d, {
  E = .mean("E", 1:5, rev=c(1,2), range=1:6)
  O = .mean("O", 1:5, rev=c(2,5), range=1:6)
})
ggplot(data=d, aes(x=E, y=O)) +
  geom_point(alpha=0.1) +
  geom_smooth(method="loess") +
  labs(x="Extraversion<sub>Big 5</sub>",
       y="Openness<sub>Big 5</sub>") +
  theme_bruce(markdown=TRUE)

## Example 2 (2x2 ANOVA)
d = data.frame(X1 = factor(rep(1:3, each=2)),
               X2 = factor(rep(1:2, 3)),
               Y.mean = c(5, 3, 2, 7, 3, 6),
               Y.se = rep(c(0.1, 0.2, 0.1), each=2))
ggplot(data=d, aes(x=X1, y=Y.mean, fill=X2)) +
  geom_bar(position="dodge", stat="identity", width=0.6, show.legend=FALSE) +
  geom_errorbar(aes(x=X1, ymin=Y.mean-Y.se, ymax=Y.mean+Y.se),
                width=0.1, color="black", position=position_dodge(0.6)) +
  scale_y_continuous(expand=expansion(add=0),
                     limits=c(0,8), breaks=0:8) +
  scale_fill_brewer(palette="Set1") +
  labs(x="Independent Variable (*X*)",  # italic X
       y="Dependent Variable (*Y*)",  # italic Y
       title="Demo Plot<sup>bruceR</sup>") +
  theme_bruce(markdown=TRUE, border="")
}
}
