% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{contains_nonnumeric}
\alias{contains_nonnumeric}
\title{Check if a vector contains non-numeric character}
\usage{
contains_nonnumeric(x)
}
\arguments{
\item{x}{A vector to be tested for existence of non-numeric characters.}
}
\value{
Logical, whether or not x contains any non-numeric characters.
}
\description{
Returns a logical, whether or not a vector contains any non-numeric
characters. Typically used to test if row names hold non-index information.
}
\examples{
library(cheem)

contains_nonnumeric(mtcars$mpg)
contains_nonnumeric(rownames(mtcars)) ## Meaningful info to use in tooltip
contains_nonnumeric(rownames(cars)) ## Assume no meaningful info to use in tooltip
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()},
\code{\link{sug_basis}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
