% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{enable_repo}
\alias{enable_repo}
\title{Enable a repo on Circle CI}
\usage{
enable_repo(
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v1.1",
  quiet = FALSE
)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}

\item{quiet}{\verb{[logical]}\cr
If \code{TRUE}, console output is suppressed.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
"Follows" a repo on Circle CI so that builds can be triggered.
}
\examples{
\dontrun{
enable_repo()
}
}
