% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_timeseries.R
\name{get_timeseries}
\alias{get_timeseries}
\alias{get_timeseries.default}
\alias{get_timeseries.matrix}
\alias{get_timeseries.array}
\title{Time series climate data}
\usage{
get_timeseries(object, day.one, ...)

\method{get_timeseries}{default}(
  object,
  day.one,
  span = NULL,
  last.day = NULL,
  as.matrix = FALSE,
  data.from = "nasapower",
  ...
)

\method{get_timeseries}{matrix}(object, day.one, span = NULL, last.day = NULL, ...)

\method{get_timeseries}{array}(object, day.one, span = NULL, last.day = NULL, ...)
}
\arguments{
\item{object}{a \code{data.frame} (or any other object that can be coerced to 
data.frame) with geographical coordinates (lonlat), or an object of class 
\code{sf} with geometry 'POINT' or 'POLYGON', or a named \code{matrix} with 
climate data, or an array with two dimensions for max and min temperature.
See details.}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{...}{additional arguments passed to methods. See details.}

\item{span}{an integer or a vector with integers (optional if \var{last.day} is 
given) for the length of the time series to be captured}

\item{last.day}{optional to \var{span}, an object of class \code{Date} or
any other object that can be coerced to \code{Date} (e.g. integer, character 
YYYY-MM-DD)  for the last day of the time series}

\item{as.matrix}{logical, optional, to return a matrix or array instead of a data.frame}

\item{data.from}{character, for the source of climate data. See details.}
}
\value{
A list with class \code{clima_ls} with data.frame(s) with 
 the class \code{clima_df}
}
\description{
General functions and methods to concatenate climate data across a time series
}
\details{
The \code{default} method and the \code{sf} method assumes that the climate 
 data will be fetched from an remote (cloud) \var{data.from}.

The \code{matrix} method assumes that the climate data was previously handled 
 and will be inputted in the format of a named matrix. 
 See help("modis", "climatrends") for examples.

Available remote sources to pass \var{data.from}: "nasapower"

Additional arguments:

\code{pars}: character vector of solar, meteorological or climatology parameters 
to download. See help("parameters", "nasapower") when \var{data.from} = "nasapower".

\code{days.before}: an integer for the number of days before \var{day.one} to be 
 included in the timespan.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using local sources
# an array with temperature data
data("temp_dat", package = "climatrends")

set.seed(9271)
span <- as.integer(runif(10, 6, 15))

get_timeseries(temp_dat, "2013-10-28", span = span)

# matrix with precipitation data
data("rain_dat", package = "climatrends")

get_timeseries(rain_dat, "2013-10-28", span = span)

\donttest{
# data can be returned as matrix
library("sf")
# Fetch data from NASA POWER using 'sf' method
data("lonlatsf", package = "climatrends")

g <- get_timeseries(object = lonlatsf,
                    day.one = "2018-05-16",
                    last.day = "2018-05-30",
                    pars = c("PRECTOTCORR", "T2M"),
                    as.matrix = TRUE)
}
\dontshow{\}) # examplesIf}
}
\concept{GET functions}
