# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Dense covariance function (difference parameterization)
#'
#' @param theta vector of parameters
#' @param locs a matrix with locations
#' @param x_covariates design data.frame
#' @param smooth_limits smooth limits
#' @return dense covariance matrix
cov_rns <- function(theta, locs, x_covariates, smooth_limits) {
    .Call(`_cocons_cov_rns`, theta, locs, x_covariates, smooth_limits)
}

#' Dense covariance function
#'
#' @param theta vector of parameters
#' @param locs a matrix with locations
#' @param locs_pred a matrix with prediction locations
#' @param x_covariates design data.frame
#' @param x_covariates_pred design data.frame at prediction locations
#' @param smooth_limits smooth limits
#' @return dense covariance matrix
cov_rns_pred <- function(theta, locs, locs_pred, x_covariates, x_covariates_pred, smooth_limits) {
    .Call(`_cocons_cov_rns_pred`, theta, locs, locs_pred, x_covariates, x_covariates_pred, smooth_limits)
}

#' Dense covariance function (classic parameterization)
#'
#' @param theta vector of parameters
#' @param locs a matrix with locations
#' @param x_covariates design data.frame
#' @return dense covariance matrix with classic parameterization
cov_rns_classic <- function(theta, locs, x_covariates) {
    .Call(`_cocons_cov_rns_classic`, theta, locs, x_covariates)
}

#' Sparse covariance function
#'
#' @param theta vector of parameters
#' @param locs a matrix with locations
#' @param locs_pred a matrix with prediction locations
#' @param x_covariates design data.frame
#' @param x_covariates_pred design data.frame at prediction locations
#' @param colindices from spam object
#' @param rowpointers from spam object
#' @param smooth_limits smooth limits
#' @return sparse covariance matrix at locs 
cov_rns_taper_pred <- function(theta, locs, locs_pred, x_covariates, x_covariates_pred, colindices, rowpointers, smooth_limits) {
    .Call(`_cocons_cov_rns_taper_pred`, theta, locs, locs_pred, x_covariates, x_covariates_pred, colindices, rowpointers, smooth_limits)
}

#' Sparse covariance function
#'
#' @param theta vector of parameters
#' @param locs a matrix with locations
#' @param x_covariates design data.frame
#' @param colindices from spam object
#' @param rowpointers from spam object
#' @param smooth_limits smooth limits
#' @return sparse covariance matrix between locs and pred_locs
cov_rns_taper <- function(theta, locs, x_covariates, colindices, rowpointers, smooth_limits) {
    .Call(`_cocons_cov_rns_taper`, theta, locs, x_covariates, colindices, rowpointers, smooth_limits)
}

