% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{package}
\name{Datasets}
\alias{Datasets}
\alias{collett_data}
\title{Datasets}
\source{
\url{https://s3-eu-west-1.amazonaws.com/s3-euw1-ap-pe-ws4-cws-documents.ri-prod/9781032252858/Data\%20sets\%20from\%20Modelling\%20Survival\%20Data\%20in\%20Medical\%20Research\%2C\%204th\%20edition.zip}
}
\usage{
collett_data(name)
}
\arguments{
\item{name}{Character string with the original filename}
}
\value{
A data-frame
}
\description{
The datasets are based on the official .zip file. A table for the dataset names and file names sorted by file name is here:
\tabular{ll}{
\bold{Dataset name} \tab \bold{File name} \cr
-------------------- \tab ----------------- \cr
\link{illustration} \tab "A numerical illustration.dat" \cr
\link{leukaemia} \tab "Bone marrow transplantation in the treatment of leukaemia.dat" \cr
\link{bone_marrow} \tab "Bone marrow transplantation.dat" \cr
\link{ovarian} \tab "Chemotherapy in ovarian cancer patients.dat" \cr
\link{active_hepatitis} \tab "Chronic active hepatitis.dat" \cr
\link{granulomatous} \tab "Chronic granulomatous disease.dat" \cr
\link{tamoxifen} \tab "Clinical trial of tamoxifen in breast cancer patients.dat" \cr
\link{prostatic} \tab "Comparison of two treatments for prostatic cancer.dat" \cr
\link{kidneytx} \tab "Comparisons between kidney transplant centres.dat" \cr
\link{liverbase} \tab "Data from a cirrhosis study (baseline).dat" \cr
\link{liver_counting} \tab "Data from a cirrhosis study (in counting process format).dat" \cr
\link{lbrdata0} \tab "Data from a cirrhosis study (lbr data).dat" \cr
\link{HELP} \tab "Health evaluation and linkage to primary care.dat" \cr
\link{dialysis} \tab "Infection in patients on dialysis.dat" \cr
\link{bone_marrow_tx} \tab "Patient outcome following bone marrow transplantation.dat" \cr
\link{bcancer} \tab "Prognosis for women with breast cancer.dat" \cr
\link{pulmonary} \tab "Pulmonary metastasis.dat" \cr
\link{breast_rfs} \tab "Recurrence free survival in breast cancer patients.dat" \cr
\link{ulcer} \tab "Recurrence of an ulcer.dat" \cr
\link{bladder} \tab "Recurrence of bladder cancer.dat" \cr
\link{mammary} \tab "Recurrence of mammary tumours in female rats.dat" \cr
\link{valve} \tab "Survival following aortic valve replacement.dat" \cr
\link{tplant} \tab "Survival following kidney transplantation.dat" \cr
\link{ducks} \tab "Survival of black ducks.dat" \cr
\link{mice} \tab "Survival of laboratory mice.dat" \cr
\link{liver} \tab "Survival of liver transplant recipients.dat" \cr
\link{myeloma} \tab "Survival of multiple myeloma patients.dat" \cr
\link{lung} \tab "Survival of patients registered for a lung transplant.dat" \cr
\link{gcancer} \tab "Survival of patients with gastric cancer.dat" \cr
\link{melanoma} \tab "Survival times of patients with melanoma .dat" \cr
\link{livertx} \tab "Time to death while waiting for a liver transplant.dat" \cr
\link{IUD} \tab "Time to discontinuation of the use of an IUD.dat" \cr
\link{kidney} \tab "Treatment of hypernephroma.dat" \cr
}
And now sorted by the dataset names:
\tabular{ll}{
\bold{Dataset name} \tab \bold{File name} \cr
-------------------- \tab ----------------- \cr
\link{active_hepatitis} \tab "Chronic active hepatitis.dat" \cr
\link{bcancer} \tab "Prognosis for women with breast cancer.dat" \cr
\link{bladder} \tab "Recurrence of bladder cancer.dat" \cr
\link{bone_marrow} \tab "Bone marrow transplantation.dat" \cr
\link{bone_marrow_tx} \tab "Patient outcome following bone marrow transplantation.dat" \cr
\link{breast_rfs} \tab "Recurrence free survival in breast cancer patients.dat" \cr
\link{dialysis} \tab "Infection in patients on dialysis.dat" \cr
\link{ducks} \tab "Survival of black ducks.dat" \cr
\link{gcancer} \tab "Survival of patients with gastric cancer.dat" \cr
\link{granulomatous} \tab "Chronic granulomatous disease.dat" \cr
\link{HELP} \tab "Health evaluation and linkage to primary care.dat" \cr
\link{illustration} \tab "A numerical illustration.dat" \cr
\link{IUD} \tab "Time to discontinuation of the use of an IUD.dat" \cr
\link{kidney} \tab "Treatment of hypernephroma.dat" \cr
\link{kidneytx} \tab "Comparisons between kidney transplant centres.dat" \cr
\link{lbrdata0} \tab "Data from a cirrhosis study (lbr data).dat" \cr
\link{leukaemia} \tab "Bone marrow transplantation in the treatment of leukaemia.dat" \cr
\link{liver} \tab "Survival of liver transplant recipients.dat" \cr
\link{liver_counting} \tab "Data from a cirrhosis study (in counting process format).dat" \cr
\link{liverbase} \tab "Data from a cirrhosis study (baseline).dat" \cr
\link{livertx} \tab "Time to death while waiting for a liver transplant.dat" \cr
\link{lung} \tab "Survival of patients registered for a lung transplant.dat" \cr
\link{mammary} \tab "Recurrence of mammary tumours in female rats.dat" \cr
\link{melanoma} \tab "Survival times of patients with melanoma .dat" \cr
\link{mice} \tab "Survival of laboratory mice.dat" \cr
\link{myeloma} \tab "Survival of multiple myeloma patients.dat" \cr
\link{ovarian} \tab "Chemotherapy in ovarian cancer patients.dat" \cr
\link{prostatic} \tab "Comparison of two treatments for prostatic cancer.dat" \cr
\link{pulmonary} \tab "Pulmonary metastasis.dat" \cr
\link{tamoxifen} \tab "Clinical trial of tamoxifen in breast cancer patients.dat" \cr
\link{tplant} \tab "Survival following kidney transplantation.dat" \cr
\link{ulcer} \tab "Recurrence of an ulcer.dat" \cr
\link{valve} \tab "Survival following aortic valve replacement.dat" \cr
}

As an alternative to using the R datasets, the \code{collett_data}
function allows for reading from the original .dat files that
are stored in the package.
}
\examples{
head(collett_data("A numerical illustration.dat"))
## which is equivalent to: head(illustration)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mclements/collett}
  \item Report bugs at \url{https://github.com/mclements/collett/issues}
}

}
\author{
\strong{Maintainer}: Mark Clements \email{mark.clements@ki.se} (\href{https://orcid.org/0000-0003-4518-5670}{ORCID})

}
