% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{get_content_packages}
\alias{get_content_packages}
\title{Package dependencies for a content item}
\usage{
get_content_packages(content)
}
\arguments{
\item{content}{A content item}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{language} : Language ecosystem the package belongs to (\code{r} or \code{python})
\item \code{name}: The package name
\item \code{version}: The package version
\item \code{hash}: For R packages, the package \code{DESCRIPTION} hash
}
}
\description{
Get a data frame of package dependencies used by a content item.
}
\examples{
\dontrun{
client <- connect()
item <- content_item(client, "951bf3ad-82d0-4bca-bba8-9b27e35c49fa")
packages <- get_content_packages(item)
}

}
\seealso{
Other packages functions: 
\code{\link{get_packages}()}
}
\concept{packages functions}
