% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataGrouped-class}
\alias{DataGrouped-class}
\alias{.DataGrouped}
\alias{DataGrouped}
\alias{.DefaultDataGrouped}
\title{\code{DataGrouped}}
\usage{
DataGrouped(group = character(), ...)

.DefaultDataGrouped()
}
\arguments{
\item{group}{(\code{factor} or \code{character})\cr whether \code{mono} or \code{combo} was used.
If \code{character} then will be coerced to \code{factor} with the correct levels
internally.}

\item{...}{parameters passed to \code{\link[=Data]{Data()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{DataGrouped}} is a class for a two groups dose escalation data set,
comprised of a monotherapy (\code{mono}) and a combination therapy (\code{combo})
arm. It inherits from \code{\link{Data}} and it contains the additional group information.
}
\section{Slots}{

\describe{
\item{\code{group}}{(\code{factor})\cr whether \code{mono} or \code{combo} was used.}
}}

\note{
Typically, end users will not use the \code{.DefaultDataGrouped()} function.
}
\examples{
my_data <- DataGrouped(
  x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
  y = c(0, 0, 1, 1, 0, 0, 1, 0),
  doseGrid = c(0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2)),
  group = c("mono", "mono", "mono", "mono", "mono", "mono", "combo", "combo")
)

# Set up an empty data set.
empty_data <- DataGrouped(
  doseGrid = c(0.1, 0.5, 1, 1.5, 3, 6, seq(from = 10, to = 80, by = 2))
)
empty_data
}
