% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{dynamic_font_color_settings}
\alias{dynamic_font_color_settings}
\title{Create a list of dynamic font color settings for plots}
\usage{
dynamic_font_color_settings(
  threshold = NULL,
  by = "counts",
  all = NULL,
  counts = NULL,
  normalized = NULL,
  row_percentages = NULL,
  col_percentages = NULL,
  invert_arrows = NULL
)
}
\arguments{
\item{threshold}{The threshold at which the color changes.}

\item{by}{The value to check against \code{`threshold`}.
One of \{\code{`counts`}, \code{`normalized`}\}.}

\item{all}{Set same color settings for all fonts at once.
Takes a character vector with two hex code strings (low, high).
Example: `c('#000', '#fff')`.}

\item{counts, normalized, row_percentages, col_percentages}{Set color settings for the individual font.
 Takes a character vector with two hex code strings (low, high).
 Example: `c('#000', '#fff')`.

 Specifying colors for specific fonts overrides the settings specified in
 \code{`all`} (for those fonts only).}

\item{invert_arrows}{String specifying when to invert the color of the arrow icons based on the threshold.
One of \{\code{`below`}, \code{`at_and_above`}\} (or \code{NULL} for no dynamical arrow colors).}
}
\value{
List of settings.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates a list of dynamic font color settings for plotting with \code{cvms} plotting functions.

 Specify separate colors below and above a given value threshold.

 NOTE: This is experimental and will likely change.
}
\seealso{
Other plotting functions: 
\code{\link{font}()},
\code{\link{plot_confusion_matrix}()},
\code{\link{plot_metric_density}()},
\code{\link{plot_probabilities}()},
\code{\link{plot_probabilities_ecdf}()},
\code{\link{sum_tile_settings}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{plotting functions}
