% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{create_NWIS_bib}
\alias{create_NWIS_bib}
\title{Create NWIS data citation}
\usage{
create_NWIS_bib(x)
}
\arguments{
\item{x}{Any data returned from an NWIS function, must
include "queryTime" and "url" attributes, which should
come with the data by default.}
}
\value{
bibentry object to use for citing the data.
}
\description{
Uses attributes from the NWIS functions to create data citations.
}
\details{
See \code{?bibentry} for more information.
}
\examples{
\donttest{
nwisData <- readNWISdv("04085427", "00060", "2012-01-01", "2012-06-30")
nwis_citation <- create_NWIS_bib(nwisData)
nwis_citation

print(nwis_citation, style = "Bibtex")
print(nwis_citation, style = "citation")
}
}
