% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_evaluate_calls.R
\name{util_evaluate_calls}
\alias{util_evaluate_calls}
\title{Generate a full DQ report, v2}
\usage{
util_evaluate_calls(
  all_calls,
  study_data,
  meta_data,
  label_col,
  meta_data_segment,
  meta_data_dataframe,
  meta_data_cross_item,
  resp_vars,
  filter_result_slots,
  cores,
  debug_parallel,
  mode = c("default", "futures", "queue", "parallel"),
  mode_args,
  my_storr_object = NULL
)
}
\arguments{
\item{all_calls}{\link{list} a list of calls}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional: Data frame level
metadata}

\item{meta_data_cross_item}{\link{data.frame} -- optional: cross-item level
metadata}

\item{resp_vars}{\link{variable list} the name of the measurement variables
for the report.}

\item{filter_result_slots}{\link{character} regular expressions, only
if an indicator function's
result's name
matches one of these, it'll
be used for the report. If
of length zero, no filtering
is performed.}

\item{cores}{\link{integer} number of cpu cores to use or a named list with
arguments for \link[parallelMap:parallelStart]{parallelMap::parallelStart} or NULL,
if parallel has already been started by the caller.
Can also be a cluster.}

\item{debug_parallel}{\link{logical} print blocks currently evaluated in parallel}

\item{mode}{\link{character} work mode for parallel execution. default is
"default", the values mean:
- default: use \code{queue} except \code{cores} has been set explicitly
- futures: use the \code{future} package
- queue: use a queue as described in the examples
from the \code{callr} package by Csárdi and Chang and start
sub-processes as workers that evaluate the queue.
- parallel: use the cluster from \code{cores} to evaluate all
calls of indicator functions using the classic
R \code{parallel} back-ends}

\item{mode_args}{\link{list} of arguments for the selected \code{mode}. As of writing
this manual, only for the mode \code{queue} the argument
\code{step} is supported, which gives the number of
function calls that are run by one worker at a time.
the default is 15, which gives on most of the tested
systems a good balance between synchronization
overhead and idling workers.}
}
\value{
a \link{dataquieR_resultset2}. Can be printed creating a RMarkdown-report.
}
\description{
Generate a full DQ report, v2
}
\seealso{
Other reporting_functions: 
\code{\link{util_alias2caption}()},
\code{\link{util_copy_all_deps}()},
\code{\link{util_create_page_file}()},
\code{\link{util_eval_to_dataquieR_result}()},
\code{\link{util_float_index_menu}()},
\code{\link{util_generate_anchor_link}()},
\code{\link{util_generate_anchor_tag}()},
\code{\link{util_generate_calls}()},
\code{\link{util_generate_calls_for_function}()},
\code{\link{util_load_manual}()},
\code{\link{util_make_data_slot_from_table_slot}()},
\code{\link{util_order_by_order}()},
\code{\link{util_set_size}()}
}
\concept{process}
\concept{reporting_functions}
\keyword{internal}
