# difNLR - examples at help page

    Code
      (fit1 <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  82.0689      0.0000 ***
      Item2  28.3232      0.0000 ***
      Item3   0.6845      0.7102    
      Item4   3.3055      0.1915    
      Item5   1.1984      0.5492    
      Item6   0.1573      0.9244    
      Item7   8.3032      0.0157 *  
      Item8   2.8660      0.2386    
      Item9   0.4549      0.7966    
      Item10  1.3507      0.5090    
      Item11  1.2431      0.5371    
      Item12  1.0537      0.5905    
      Item13  4.4139      0.1100    
      Item14  1.4940      0.4738    
      Item15  1.3079      0.5200    
      Item16  0.1424      0.9313    
      Item17  3.1673      0.2052    
      Item18  2.0206      0.3641    
      Item19  6.2546      0.0438 *  
      Item20  3.4871      0.1749    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7
       Item19

---

    Code
      summary(fitted(fit1))
    Output
           Item1            Item2            Item3            Item4       
       Min.   :0.1340   Min.   :0.1040   Min.   :0.2988   Min.   :0.4093  
       1st Qu.:0.3568   1st Qu.:0.4272   1st Qu.:0.6607   1st Qu.:0.7422  
       Median :0.5093   Median :0.5844   Median :0.7504   Median :0.8122  
       Mean   :0.5251   Mean   :0.5702   Mean   :0.7157   Mean   :0.7820  
       3rd Qu.:0.7268   3rd Qu.:0.7315   3rd Qu.:0.8227   3rd Qu.:0.8666  
       Max.   :0.9705   Max.   :0.9679   Max.   :0.9447   Max.   :0.9566  
           Item5            Item6            Item7            Item8       
       Min.   :0.4258   Min.   :0.1755   Min.   :0.1924   Min.   :0.2732  
       1st Qu.:0.7634   1st Qu.:0.5495   1st Qu.:0.5468   1st Qu.:0.5343  
       Median :0.8560   Median :0.6819   Median :0.6648   Median :0.6410  
       Mean   :0.8122   Mean   :0.6386   Mean   :0.6500   Mean   :0.6166  
       3rd Qu.:0.9192   3rd Qu.:0.7920   3rd Qu.:0.7531   3rd Qu.:0.7416  
       Max.   :0.9886   Max.   :0.9564   Max.   :0.9299   Max.   :0.9293  
           Item9            Item10           Item11           Item12      
       Min.   :0.2212   Min.   :0.2253   Min.   :0.1829   Min.   :0.2533  
       1st Qu.:0.5057   1st Qu.:0.5002   1st Qu.:0.5979   1st Qu.:0.4533  
       Median :0.6025   Median :0.5979   Median :0.7208   Median :0.5597  
       Mean   :0.5786   Mean   :0.5750   Mean   :0.6741   Mean   :0.5474  
       3rd Qu.:0.6932   3rd Qu.:0.6904   3rd Qu.:0.8179   3rd Qu.:0.6731  
       Max.   :0.8841   Max.   :0.8860   Max.   :0.9596   Max.   :0.9125  
           Item13           Item14           Item15           Item16      
       Min.   :0.4102   Min.   :0.1199   Min.   :0.1741   Min.   :0.1039  
       1st Qu.:0.6842   1st Qu.:0.3349   1st Qu.:0.4474   1st Qu.:0.3140  
       Median :0.7715   Median :0.4531   Median :0.5432   Median :0.4549  
       Mean   :0.7421   Mean   :0.4432   Mean   :0.5224   Mean   :0.4461  
       3rd Qu.:0.8443   3rd Qu.:0.5834   3rd Qu.:0.6359   3rd Qu.:0.6140  
       Max.   :0.9610   Max.   :0.8798   Max.   :0.8470   Max.   :0.9246  
           Item17           Item18            Item19            Item20      
       Min.   :0.1824   Min.   :0.06246   Min.   :0.09561   Min.   :0.2103  
       1st Qu.:0.3717   1st Qu.:0.27960   1st Qu.:0.33303   1st Qu.:0.2986  
       Median :0.4599   Median :0.41775   Median :0.48166   Median :0.3893  
       Mean   :0.4519   Mean   :0.40978   Mean   :0.48171   Mean   :0.4117  
       3rd Qu.:0.5565   3rd Qu.:0.57444   3rd Qu.:0.63424   3rd Qu.:0.5271  
       Max.   :0.8139   Max.   :0.90358   Max.   :0.93207   Max.   :0.9096  

---

    Code
      fitted(fit1, item = 1)
    Output
              1         2         3         4         5         6         7         8 
      0.4364813 0.7866563 0.8870283 0.2254449 0.7950139 0.2979029 0.5093386 0.4258949 
              9        10        11        12        13        14        15        16 
      0.7950139 0.7866563 0.8463985 0.7267631 0.4364813 0.5025621 0.7326843 0.3567994 
             17        18        19        20        21        22        23        24 
      0.5825445 0.7267631 0.4364813 0.3120550 0.4258949 0.8368960 0.8870283 0.8463985 
             25        26        27        28        29        30        31        32 
      0.6607947 0.5025621 0.7866563 0.5025621 0.7267631 0.2639710 0.5025621 0.6585473 
             33        34        35        36        37        38        39        40 
      0.7950139 0.3120550 0.4364813 0.5093386 0.6607947 0.8463985 0.5025621 0.5847767 
             41        42        43        44        45        46        47        48 
      0.2639710 0.5025621 0.5025621 0.7950139 0.7950139 0.4364813 0.3120550 0.5025621 
             49        50        51        52        53        54        55        56 
      0.2254449 0.5093386 0.5093386 0.2639710 0.1726988 0.5093386 0.3120550 0.5825445 
             57        58        59        60        61        62        63        64 
      0.3120550 0.5093386 0.5093386 0.5093386 0.9091805 0.6607947 0.3120550 0.2254449 
             65        66        67        68        69        70        71        72 
      0.6585473 0.7326843 0.2254449 0.7326843 0.1431489 0.9412824 0.4258949 0.2254449 
             73        74        75        76        77        78        79        80 
      0.4364813 0.5825445 0.5025621 0.2254449 0.6585473 0.2500383 0.3120550 0.5025621 
             81        82        83        84        85        86        87        88 
      0.5093386 0.5825445 0.2254449 0.3567994 0.5025621 0.6585473 0.2979029 0.3567994 
             89        90        91        92        93        94        95        96 
      0.4364813 0.7326843 0.2979029 0.7267631 0.4364813 0.7267631 0.2639710 0.2254449 
             97        98        99       100       101       102       103       104 
      0.3698991 0.8463985 0.2639710 0.8774494 0.9582384 0.5093386 0.5093386 0.6607947 
            105       106       107       108       109       110       111       112 
      0.3698991 0.2126244 0.7950139 0.7950139 0.6607947 0.1726988 0.6585473 0.4364813 
            113       114       115       116       117       118       119       120 
      0.3698991 0.8463985 0.3120550 0.5825445 0.3120550 0.8870283 0.2254449 0.4364813 
            121       122       123       124       125       126       127       128 
      0.7866563 0.4364813 0.2639710 0.8463985 0.2639710 0.5025621 0.2639710 0.2500383 
            129       130       131       132       133       134       135       136 
      0.2639710 0.2979029 0.4364813 0.4258949 0.4258949 0.8463985 0.3698991 0.3698991 
            137       138       139       140       141       142       143       144 
      0.1842596 0.5847767 0.7326843 0.8463985 0.3698991 0.1954771 0.2979029 0.7950139 
            145       146       147       148       149       150       151       152 
      0.5025621 0.6607947 0.9181070 0.7326843 0.2254449 0.3120550 0.2639710 0.2254449 
            153       154       155       156       157       158       159       160 
      0.6607947 0.4364813 0.8463985 0.3567994 0.2254449 0.9181070 0.9412824 0.3698991 
            161       162       163       164       165       166       167       168 
      0.4258949 0.5093386 0.9181070 0.1726988 0.4258949 0.4364813 0.6607947 0.9181070 
            169       170       171       172       173       174       175       176 
      0.2639710 0.7950139 0.2979029 0.6607947 0.5847767 0.5825445 0.7326843 0.4258949 
            177       178       179       180       181       182       183       184 
      0.4364813 0.7866563 0.8870283 0.1954771 0.3698991 0.8870283 0.9181070 0.8368960 
            185       186       187       188       189       190       191       192 
      0.5847767 0.5025621 0.8870283 0.3567994 0.1556872 0.7326843 0.3120550 0.5025621 
            193       194       195       196       197       198       199       200 
      0.7326843 0.1726988 0.9181070 0.5825445 0.5825445 0.6607947 0.7950139 0.4364813 
            201       202       203       204       205       206       207       208 
      0.3120550 0.5825445 0.2500383 0.7950139 0.8870283 0.7326843 0.7326843 0.4364813 
            209       210       211       212       213       214       215       216 
      0.7950139 0.3698991 0.5847767 0.3698991 0.2500383 0.5093386 0.1954771 0.2979029 
            217       218       219       220       221       222       223       224 
      0.7326843 0.7950139 0.9412824 0.7326843 0.5847767 0.3698991 0.3698991 0.7326843 
            225       226       227       228       229       230       231       232 
      0.3698991 0.4258949 0.7326843 0.5025621 0.5825445 0.5093386 0.3567994 0.9181070 
            233       234       235       236       237       238       239       240 
      0.8870283 0.3567994 0.8463985 0.7326843 0.5825445 0.9412824 0.3120550 0.9181070 
            241       242       243       244       245       246       247       248 
      0.7326843 0.6585473 0.6607947 0.4364813 0.5025621 0.3120550 0.4364813 0.5825445 
            249       250       251       252       253       254       255       256 
      0.5847767 0.3120550 0.8463985 0.5025621 0.7950139 0.6607947 0.5847767 0.5847767 
            257       258       259       260       261       262       263       264 
      0.6607947 0.4364813 0.7267631 0.7950139 0.1431489 0.6585473 0.3567994 0.2639710 
            265       266       267       268       269       270       271       272 
      0.6607947 0.5825445 0.8463985 0.4364813 0.7866563 0.1726988 0.4364813 0.6607947 
            273       274       275       276       277       278       279       280 
      0.7950139 0.3567994 0.9181070 0.3120550 0.5093386 0.1954771 0.3567994 0.5093386 
            281       282       283       284       285       286       287       288 
      0.2639710 0.7326843 0.5825445 0.4258949 0.5847767 0.7866563 0.5025621 0.7950139 
            289       290       291       292       293       294       295       296 
      0.9412824 0.4258949 0.4258949 0.2639710 0.3120550 0.5825445 0.4364813 0.8463985 
            297       298       299       300       301       302       303       304 
      0.5847767 0.5025621 0.5847767 0.8463985 0.5847767 0.3698991 0.3567994 0.2500383 
            305       306       307       308       309       310       311       312 
      0.6607947 0.9181070 0.7950139 0.9181070 0.4258949 0.3698991 0.6607947 0.2639710 
            313       314       315       316       317       318       319       320 
      0.4364813 0.5093386 0.8774494 0.7950139 0.5093386 0.6585473 0.5825445 0.3120550 
            321       322       323       324       325       326       327       328 
      0.2639710 0.5093386 0.7326843 0.1339969 0.6585473 0.7326843 0.3567994 0.7950139 
            329       330       331       332       333       334       335       336 
      0.7326843 0.1726988 0.3120550 0.3698991 0.4364813 0.2639710 0.8870283 0.5025621 
            337       338       339       340       341       342       343       344 
      0.5825445 0.4364813 0.6607947 0.3698991 0.6607947 0.5847767 0.7950139 0.7326843 
            345       346       347       348       349       350       351       352 
      0.5025621 0.5025621 0.4364813 0.4258949 0.8463985 0.2639710 0.1954771 0.8463985 
            353       354       355       356       357       358       359       360 
      0.5825445 0.6607947 0.2979029 0.8463985 0.5093386 0.2639710 0.2979029 0.4258949 
            361       362       363       364       365       366       367       368 
      0.7866563 0.2639710 0.5093386 0.2979029 0.8870283 0.4364813 0.3567994 0.3120550 
            369       370       371       372       373       374       375       376 
      0.2639710 0.5847767 0.3567994 0.5093386 0.2254449 0.4258949 0.5825445 0.3120550 
            377       378       379       380       381       382       383       384 
      0.1726988 0.7326843 0.5025621 0.7950139 0.8463985 0.5093386 0.4258949 0.5825445 
            385       386       387       388       389       390       391       392 
      0.6607947 0.9412824 0.5025621 0.9704721 0.3567994 0.1556872 0.3120550 0.3698991 
            393       394       395       396       397       398       399       400 
      0.7267631 0.5093386 0.5025621 0.3698991 0.4258949 0.8368960 0.8368960 0.8463985 
            401       402       403       404       405       406       407       408 
      0.2500383 0.3120550 0.4364813 0.8463985 0.9181070 0.3698991 0.5093386 0.5847767 
            409       410       411       412       413       414       415       416 
      0.4364813 0.8368960 0.6585473 0.4364813 0.7950139 0.4258949 0.5825445 0.1954771 
            417       418       419       420       421       422       423       424 
      0.5093386 0.2979029 0.4258949 0.1556872 0.3120550 0.6585473 0.4364813 0.4364813 
            425       426       427       428       429       430       431       432 
      0.5093386 0.3567994 0.6585473 0.6585473 0.5093386 0.5025621 0.3698991 0.4364813 
            433       434       435       436       437       438       439       440 
      0.5025621 0.8463985 0.3120550 0.7866563 0.7950139 0.2639710 0.2500383 0.5093386 
            441       442       443       444       445       446       447       448 
      0.5847767 0.5093386 0.7326843 0.2254449 0.3120550 0.7950139 0.6585473 0.6585473 
            449       450       451       452       453       454       455       456 
      0.1954771 0.3120550 0.5847767 0.1726988 0.8368960 0.5093386 0.5025621 0.7267631 
            457       458       459       460       461       462       463       464 
      0.5093386 0.5847767 0.3120550 0.7326843 0.5093386 0.5847767 0.7267631 0.7950139 
            465       466       467       468       469       470       471       472 
      0.2126244 0.2639710 0.5093386 0.7326843 0.5847767 0.6585473 0.5825445 0.6607947 
            473       474       475       476       477       478       479       480 
      0.3120550 0.5025621 0.7950139 0.7326843 0.3567994 0.5093386 0.5093386 0.7326843 
            481       482       483       484       485       486       487       488 
      0.8463985 0.5847767 0.7950139 0.7326843 0.5025621 0.3120550 0.7950139 0.6607947 
            489       490       491       492       493       494       495       496 
      0.4364813 0.6585473 0.7326843 0.2254449 0.2254449 0.3120550 0.5025621 0.1954771 
            497       498       499       500       501       502       503       504 
      0.2979029 0.5847767 0.5025621 0.7866563 0.8463985 0.2500383 0.3698991 0.3120550 
            505       506       507       508       509       510       511       512 
      0.5025621 0.4258949 0.3120550 0.4364813 0.3120550 0.3120550 0.3120550 0.1842596 
            513       514       515       516       517       518       519       520 
      0.2126244 0.6607947 0.7267631 0.2979029 0.3698991 0.4258949 0.2639710 0.5093386 
            521       522       523       524       525       526       527       528 
      0.5825445 0.5093386 0.9091805 0.7866563 0.5093386 0.6585473 0.8870283 0.5847767 
            529       530       531       532       533       534       535       536 
      0.2639710 0.8463985 0.8463985 0.5847767 0.3698991 0.4258949 0.3120550 0.6607947 
            537       538       539       540       541       542       543       544 
      0.6607947 0.7326843 0.5025621 0.5093386 0.2639710 0.3698991 0.6585473 0.3567994 
            545       546       547       548       549       550       551       552 
      0.5025621 0.7326843 0.5093386 0.4364813 0.3698991 0.2254449 0.4364813 0.2254449 
            553       554       555       556       557       558       559       560 
      0.7326843 0.4364813 0.3567994 0.4364813 0.6585473 0.2639710 0.6607947 0.5093386 
            561       562       563       564       565       566       567       568 
      0.8463985 0.2500383 0.5025621 0.7950139 0.4364813 0.5847767 0.2639710 0.7326843 
            569       570       571       572       573       574       575       576 
      0.9181070 0.4258949 0.5025621 0.7267631 0.3698991 0.4364813 0.5025621 0.5093386 
            577       578       579       580       581       582       583       584 
      0.3698991 0.7326843 0.1726988 0.3698991 0.4258949 0.1954771 0.5025621 0.5025621 
            585       586       587       588       589       590       591       592 
      0.5093386 0.2639710 0.4364813 0.1556872 0.7950139 0.4364813 0.8870283 0.2126244 
            593       594       595       596       597       598       599       600 
      0.3567994 0.5825445 0.5025621 0.5025621 0.4364813 0.2254449 0.5847767 0.6607947 
            601       602       603       604       605       606       607       608 
      0.2639710 0.2500383 0.3698991 0.2639710 0.3120550 0.7326843 0.8463985 0.7326843 
            609       610       611       612       613       614       615       616 
      0.7866563 0.5847767 0.6607947 0.5847767 0.5825445 0.7866563 0.4364813 0.1556872 
            617       618       619       620       621       622       623       624 
      0.5025621 0.1556872 0.7326843 0.2979029 0.4364813 0.1954771 0.4364813 0.4364813 
            625       626       627       628       629       630       631       632 
      0.3698991 0.1954771 0.7950139 0.4258949 0.8870283 0.7326843 0.2254449 0.6607947 
            633       634       635       636       637       638       639       640 
      0.5825445 0.7950139 0.7326843 0.8463985 0.6607947 0.7326843 0.5825445 0.8870283 
            641       642       643       644       645       646       647       648 
      0.4258949 0.5825445 0.5825445 0.5847767 0.2254449 0.3567994 0.3120550 0.3567994 
            649       650       651       652       653       654       655       656 
      0.4258949 0.5025621 0.8774494 0.4258949 0.7326843 0.7326843 0.6607947 0.4364813 
            657       658       659       660       661       662       663       664 
      0.7950139 0.7326843 0.1954771 0.7326843 0.3120550 0.7950139 0.2639710 0.3120550 
            665       666       667       668       669       670       671       672 
      0.3120550 0.9704721 0.5825445 0.6607947 0.2979029 0.2254449 0.3698991 0.5847767 
            673       674       675       676       677       678       679       680 
      0.4364813 0.3120550 0.7326843 0.5847767 0.1954771 0.4364813 0.3120550 0.4364813 
            681       682       683       684       685       686       687       688 
      0.1726988 0.4258949 0.3120550 0.1556872 0.6607947 0.8870283 0.4364813 0.8368960 
            689       690       691       692       693       694       695       696 
      0.3120550 0.3698991 0.8463985 0.5093386 0.5025621 0.5093386 0.2500383 0.7950139 
            697       698       699       700       701       702       703       704 
      0.7950139 0.5025621 0.2639710 0.7950139 0.2500383 0.2639710 0.9181070 0.2639710 
            705       706       707       708       709       710       711       712 
      0.3698991 0.2979029 0.7950139 0.4258949 0.4258949 0.3120550 0.1556872 0.8870283 
            713       714       715       716       717       718       719       720 
      0.7950139 0.5825445 0.5093386 0.5093386 0.5825445 0.1954771 0.3120550 0.5025621 
            721       722       723       724       725       726       727       728 
      0.5093386 0.4258949 0.5025621 0.5825445 0.8463985 0.7267631 0.1954771 0.3698991 
            729       730       731       732       733       734       735       736 
      0.5093386 0.6607947 0.3698991 0.7326843 0.5825445 0.3698991 0.6585473 0.3698991 
            737       738       739       740       741       742       743       744 
      0.7326843 0.2254449 0.3567994 0.8368960 0.5093386 0.5847767 0.8368960 0.7326843 
            745       746       747       748       749       750       751       752 
      0.3120550 0.5093386 0.2500383 0.8870283 0.7267631 0.2979029 0.7267631 0.5847767 
            753       754       755       756       757       758       759       760 
      0.5847767 0.6607947 0.5025621 0.7326843 0.4258949 0.3698991 0.6607947 0.9412824 
            761       762       763       764       765       766       767       768 
      0.2254449 0.3698991 0.6585473 0.1726988 0.2639710 0.3120550 0.5025621 0.5825445 
            769       770       771       772       773       774       775       776 
      0.5025621 0.3567994 0.3567994 0.8870283 0.7326843 0.5093386 0.3120550 0.3567994 
            777       778       779       780       781       782       783       784 
      0.6585473 0.7326843 0.3698991 0.8463985 0.6607947 0.3567994 0.7950139 0.3698991 
            785       786       787       788       789       790       791       792 
      0.4258949 0.3120550 0.2639710 0.5025621 0.5025621 0.5847767 0.2979029 0.8463985 
            793       794       795       796       797       798       799       800 
      0.5025621 0.7326843 0.1954771 0.5025621 0.4364813 0.5825445 0.3567994 0.2639710 
            801       802       803       804       805       806       807       808 
      0.5825445 0.5825445 0.7950139 0.8368960 0.7267631 0.7326843 0.3120550 0.4258949 
            809       810       811       812       813       814       815       816 
      0.2639710 0.8368960 0.8463985 0.5093386 0.7267631 0.7950139 0.2639710 0.4258949 
            817       818       819       820       821       822       823       824 
      0.2254449 0.5093386 0.4364813 0.1954771 0.7950139 0.7326843 0.7950139 0.8870283 
            825       826       827       828       829       830       831       832 
      0.8870283 0.3698991 0.4258949 0.1954771 0.5025621 0.4364813 0.2254449 0.2500383 
            833       834       835       836       837       838       839       840 
      0.5093386 0.5093386 0.3120550 0.2254449 0.4364813 0.3567994 0.8463985 0.5847767 
            841       842       843       844       845       846       847       848 
      0.6607947 0.4258949 0.7326843 0.2979029 0.5847767 0.3698991 0.2639710 0.2639710 
            849       850       851       852       853       854       855       856 
      0.7326843 0.1726988 0.5025621 0.4258949 0.5825445 0.2500383 0.5825445 0.3698991 
            857       858       859       860       861       862       863       864 
      0.5093386 0.5825445 0.5093386 0.7326843 0.5093386 0.7326843 0.6585473 0.7866563 
            865       866       867       868       869       870       871       872 
      0.4364813 0.5847767 0.8368960 0.5093386 0.5825445 0.2639710 0.5825445 0.8870283 
            873       874       875       876       877       878       879       880 
      0.6607947 0.3698991 0.9181070 0.7326843 0.5825445 0.3567994 0.4364813 0.6585473 
            881       882       883       884       885       886       887       888 
      0.3698991 0.1954771 0.5025621 0.8870283 0.5825445 0.4364813 0.6607947 0.5825445 
            889       890       891       892       893       894       895       896 
      0.3698991 0.7950139 0.4258949 0.1954771 0.4258949 0.6585473 0.5847767 0.4364813 
            897       898       899       900       901       902       903       904 
      0.3120550 0.8368960 0.6585473 0.6607947 0.5825445 0.3120550 0.7866563 0.3120550 
            905       906       907       908       909       910       911       912 
      0.7326843 0.2639710 0.7326843 0.5847767 0.3120550 0.7950139 0.6607947 0.3698991 
            913       914       915       916       917       918       919       920 
      0.5847767 0.5825445 0.3698991 0.7950139 0.3698991 0.4364813 0.5847767 0.8870283 
            921       922       923       924       925       926       927       928 
      0.5847767 0.3567994 0.4258949 0.5025621 0.6607947 0.1954771 0.5825445 0.5847767 
            929       930       931       932       933       934       935       936 
      0.5025621 0.5847767 0.7326843 0.7866563 0.5825445 0.4258949 0.5825445 0.3698991 
            937       938       939       940       941       942       943       944 
      0.5847767 0.7267631 0.1954771 0.7326843 0.5093386 0.4258949 0.3698991 0.8870283 
            945       946       947       948       949       950       951       952 
      0.3120550 0.5847767 0.1954771 0.2500383 0.5825445 0.5025621 0.5847767 0.5093386 
            953       954       955       956       957       958       959       960 
      0.3698991 0.8870283 0.6607947 0.1954771 0.5025621 0.5093386 0.2254449 0.8463985 
            961       962       963       964       965       966       967       968 
      0.7866563 0.2639710 0.1954771 0.6607947 0.2254449 0.2254449 0.4364813 0.6585473 
            969       970       971       972       973       974       975       976 
      0.4364813 0.2639710 0.3698991 0.1726988 0.5825445 0.7267631 0.3698991 0.6607947 
            977       978       979       980       981       982       983       984 
      0.7267631 0.7267631 0.6607947 0.7326843 0.6585473 0.9181070 0.5825445 0.7950139 
            985       986       987       988       989       990       991       992 
      0.2254449 0.6607947 0.5825445 0.2639710 0.5093386 0.5847767 0.1339969 0.5847767 
            993       994       995       996       997       998       999      1000 
      0.5093386 0.3698991 0.7326843 0.3567994 0.9181070 0.3698991 0.8870283 0.6607947 
           1001      1002      1003      1004      1005      1006      1007      1008 
      0.5825445 0.3567994 0.2254449 0.4258949 0.7326843 0.2979029 0.9582384 0.6607947 
           1009      1010      1011      1012      1013      1014      1015      1016 
      0.5847767 0.5025621 0.2254449 0.6607947 0.1632496 0.4364813 0.5825445 0.2639710 
           1017      1018      1019      1020      1021      1022      1023      1024 
      0.1726988 0.7326843 0.3567994 0.5825445 0.7326843 0.4258949 0.9181070 0.4258949 
           1025      1026      1027      1028      1029      1030      1031      1032 
      0.6585473 0.4364813 0.6607947 0.2254449 0.3120550 0.6607947 0.4258949 0.5847767 
           1033      1034      1035      1036      1037      1038      1039      1040 
      0.5093386 0.1954771 0.7267631 0.5825445 0.1556872 0.4258949 0.7326843 0.1842596 
           1041      1042      1043      1044      1045      1046      1047      1048 
      0.6607947 0.3698991 0.4258949 0.6585473 0.6585473 0.6607947 0.3120550 0.3567994 
           1049      1050      1051      1052      1053      1054      1055      1056 
      0.3698991 0.7950139 0.2639710 0.3120550 0.6607947 0.4258949 0.5093386 0.4364813 
           1057      1058      1059      1060      1061      1062      1063      1064 
      0.2500383 0.4364813 0.3698991 0.3698991 0.2979029 0.3567994 0.5847767 0.5025621 
           1065      1066      1067      1068      1069      1070      1071      1072 
      0.7326843 0.7326843 0.7950139 0.8463985 0.3567994 0.6607947 0.4364813 0.4258949 
           1073      1074      1075      1076      1077      1078      1079      1080 
      0.4364813 0.1556872 0.7950139 0.7950139 0.1431489 0.2254449 0.5025621 0.2639710 
           1081      1082      1083      1084      1085      1086      1087      1088 
      0.4258949 0.2254449 0.9412824 0.1726988 0.5025621 0.2639710 0.2500383 0.5025621 
           1089      1090      1091      1092      1093      1094      1095      1096 
      0.2126244 0.4258949 0.5847767 0.7950139 0.8870283 0.7950139 0.6607947 0.5093386 
           1097      1098      1099      1100      1101      1102      1103      1104 
      0.5847767 0.1954771 0.3120550 0.3120550 0.9412824 0.2500383 0.7326843 0.2639710 
           1105      1106      1107      1108      1109      1110      1111      1112 
      0.7267631 0.5847767 0.3120550 0.4258949 0.5093386 0.4258949 0.5847767 0.4364813 
           1113      1114      1115      1116      1117      1118      1119      1120 
      0.3698991 0.2500383 0.7326843 0.6585473 0.5025621 0.6607947 0.5093386 0.7950139 
           1121      1122      1123      1124      1125      1126      1127      1128 
      0.8870283 0.7326843 0.5025621 0.6607947 0.5825445 0.5825445 0.3567994 0.3698991 
           1129      1130      1131      1132      1133      1134      1135      1136 
      0.4258949 0.6607947 0.1726988 0.3698991 0.8368960 0.4258949 0.8870283 0.4258949 
           1137      1138      1139      1140      1141      1142      1143      1144 
      0.2979029 0.5025621 0.2500383 0.5825445 0.3698991 0.1726988 0.3698991 0.3698991 
           1145      1146      1147      1148      1149      1150      1151      1152 
      0.5847767 0.5847767 0.7950139 0.5093386 0.3698991 0.4364813 0.6607947 0.2500383 
           1153      1154      1155      1156      1157      1158      1159      1160 
      0.2500383 0.2254449 0.7950139 0.9181070 0.8870283 0.4364813 0.9181070 0.7326843 
           1161      1162      1163      1164      1165      1166      1167      1168 
      0.2126244 0.2254449 0.5025621 0.7267631 0.7326843 0.2126244 0.5025621 0.2254449 
           1169      1170      1171      1172      1173      1174      1175      1176 
      0.5025621 0.7326843 0.4258949 0.4258949 0.2979029 0.9091805 0.9412824 0.7267631 
           1177      1178      1179      1180      1181      1182      1183      1184 
      0.7950139 0.5093386 0.1556872 0.5825445 0.7950139 0.5025621 0.5025621 0.6607947 
           1185      1186      1187      1188      1189      1190      1191      1192 
      0.4364813 0.5825445 0.3120550 0.5847767 0.5093386 0.4258949 0.6607947 0.8774494 
           1193      1194      1195      1196      1197      1198      1199      1200 
      0.7866563 0.5093386 0.7950139 0.3120550 0.7950139 0.4364813 0.2500383 0.7866563 
           1201      1202      1203      1204      1205      1206      1207      1208 
      0.6585473 0.5847767 0.3567994 0.6607947 0.4258949 0.8870283 0.9181070 0.2639710 
           1209      1210      1211      1212      1213      1214      1215      1216 
      0.9181070 0.3120550 0.3120550 0.6607947 0.3698991 0.9412824 0.3698991 0.4364813 
           1217      1218      1219      1220      1221      1222      1223      1224 
      0.6585473 0.6585473 0.8368960 0.1726988 0.5093386 0.7950139 0.4364813 0.5825445 
           1225      1226      1227      1228      1229      1230      1231      1232 
      0.3120550 0.7950139 0.3698991 0.7267631 0.7326843 0.4364813 0.5093386 0.7950139 
           1233      1234      1235      1236      1237      1238      1239      1240 
      0.5093386 0.7326843 0.9181070 0.3567994 0.7950139 0.4258949 0.7326843 0.3120550 
           1241      1242      1243      1244      1245      1246      1247      1248 
      0.5825445 0.6607947 0.5825445 0.7326843 0.7267631 0.5025621 0.7267631 0.5825445 
           1249      1250      1251      1252      1253      1254      1255      1256 
      0.9412824 0.3120550 0.3120550 0.3120550 0.4364813 0.5093386 0.3698991 0.2254449 
           1257      1258      1259      1260      1261      1262      1263      1264 
      0.5093386 0.7326843 0.5025621 0.5825445 0.5093386 0.1954771 0.3120550 0.6607947 
           1265      1266      1267      1268      1269      1270      1271      1272 
      0.5825445 0.1726988 0.5025621 0.6607947 0.5025621 0.2979029 0.2979029 0.5093386 
           1273      1274      1275      1276      1277      1278      1279      1280 
      0.7267631 0.3567994 0.7866563 0.7326843 0.3120550 0.8463985 0.4364813 0.6585473 
           1281      1282      1283      1284      1285      1286      1287      1288 
      0.3120550 0.9181070 0.1726988 0.5847767 0.5847767 0.2500383 0.5025621 0.9412824 
           1289      1290      1291      1292      1293      1294      1295      1296 
      0.1726988 0.5093386 0.8463985 0.1726988 0.5847767 0.6585473 0.6607947 0.4364813 
           1297      1298      1299      1300      1301      1302      1303      1304 
      0.6585473 0.8463985 0.3698991 0.5847767 0.7950139 0.1726988 0.7950139 0.3120550 
           1305      1306      1307      1308      1309      1310      1311      1312 
      0.7866563 0.6607947 0.2639710 0.5825445 0.5025621 0.8463985 0.8463985 0.4258949 
           1313      1314      1315      1316      1317      1318      1319      1320 
      0.3698991 0.2254449 0.5093386 0.7326843 0.7950139 0.8870283 0.7267631 0.6607947 
           1321      1322      1323      1324      1325      1326      1327      1328 
      0.5847767 0.3698991 0.5025621 0.7950139 0.6585473 0.2639710 0.3120550 0.5093386 
           1329      1330      1331      1332      1333      1334      1335      1336 
      0.8463985 0.2979029 0.6585473 0.5025621 0.7326843 0.3698991 0.5025621 0.7950139 
           1337      1338      1339      1340      1341      1342      1343      1344 
      0.2639710 0.5825445 0.7950139 0.2639710 0.3120550 0.9181070 0.5825445 0.2979029 
           1345      1346      1347      1348      1349      1350      1351      1352 
      0.5825445 0.4364813 0.5025621 0.2254449 0.3120550 0.5093386 0.3698991 0.5025621 
           1353      1354      1355      1356      1357      1358      1359      1360 
      0.8870283 0.7866563 0.3567994 0.5847767 0.5093386 0.5825445 0.7866563 0.8463985 
           1361      1362      1363      1364      1365      1366      1367      1368 
      0.2639710 0.6607947 0.5825445 0.2254449 0.5093386 0.6607947 0.9181070 0.3698991 
           1369      1370      1371      1372      1373      1374      1375      1376 
      0.6607947 0.9181070 0.6585473 0.6607947 0.9091805 0.3120550 0.4364813 0.5093386 
           1377      1378      1379      1380      1381      1382      1383      1384 
      0.7950139 0.4364813 0.5825445 0.4258949 0.2254449 0.5025621 0.5825445 0.1954771 
           1385      1386      1387      1388      1389      1390      1391      1392 
      0.7950139 0.3120550 0.3698991 0.1954771 0.1556872 0.7950139 0.5093386 0.5093386 
           1393      1394      1395      1396      1397      1398      1399      1400 
      0.7326843 0.7866563 0.7866563 0.7326843 0.4258949 0.5847767 0.4364813 0.2126244 
           1401      1402      1403      1404      1405      1406      1407      1408 
      0.7950139 0.9704721 0.4258949 0.7950139 0.3698991 0.3698991 0.6607947 0.5093386 
           1409      1410      1411      1412      1413      1414      1415      1416 
      0.8774494 0.7950139 0.2500383 0.5025621 0.2639710 0.3567994 0.4258949 0.9181070 
           1417      1418      1419      1420      1421      1422      1423      1424 
      0.6585473 0.7326843 0.2126244 0.5847767 0.3120550 0.5093386 0.4364813 0.8463985 
           1425      1426      1427      1428      1429      1430      1431      1432 
      0.6607947 0.7326843 0.6607947 0.2979029 0.4258949 0.1954771 0.7267631 0.3120550 
           1433      1434      1435      1436      1437      1438      1439      1440 
      0.5825445 0.5025621 0.4258949 0.1954771 0.7326843 0.9582384 0.7326843 0.5025621 
           1441      1442      1443      1444      1445      1446      1447      1448 
      0.1954771 0.7326843 0.5847767 0.5825445 0.8463985 0.2639710 0.7866563 0.3567994 
           1449      1450      1451      1452      1453      1454      1455      1456 
      0.6607947 0.7267631 0.8870283 0.4364813 0.3698991 0.4258949 0.5847767 0.6585473 
           1457      1458      1459      1460      1461      1462      1463      1464 
      0.7326843 0.3120550 0.5093386 0.2500383 0.5025621 0.5847767 0.3120550 0.2639710 
           1465      1466      1467      1468      1469      1470      1471      1472 
      0.7950139 0.5093386 0.5093386 0.5093386 0.6607947 0.1954771 0.5025621 0.8368960 
           1473      1474      1475      1476      1477      1478      1479      1480 
      0.2126244 0.7950139 0.3698991 0.2979029 0.7326843 0.1556872 0.8463985 0.7326843 
           1481      1482      1483      1484      1485      1486      1487      1488 
      0.3698991 0.8463985 0.3698991 0.9582384 0.4364813 0.5093386 0.2979029 0.7267631 
           1489      1490      1491      1492      1493      1494      1495      1496 
      0.4364813 0.6607947 0.6607947 0.3120550 0.5093386 0.7326843 0.5825445 0.3698991 
           1497      1498      1499      1500      1501      1502      1503      1504 
      0.4364813 0.7950139 0.6607947 0.5825445 0.7326843 0.5093386 0.9181070 0.1954771 
           1505      1506      1507      1508      1509      1510      1511      1512 
      0.7950139 0.6607947 0.2254449 0.5093386 0.1954771 0.5093386 0.2639710 0.4364813 
           1513      1514      1515      1516      1517      1518      1519      1520 
      0.3698991 0.2639710 0.5825445 0.4258949 0.5825445 0.5025621 0.1726988 0.7326843 
           1521      1522      1523      1524      1525      1526      1527      1528 
      0.4364813 0.6585473 0.5025621 0.7950139 0.5093386 0.6607947 0.2500383 0.6607947 
           1529      1530      1531      1532      1533      1534      1535      1536 
      0.5825445 0.6607947 0.4258949 0.7866563 0.7326843 0.4364813 0.3120550 0.9412824 
           1537      1538      1539      1540      1541      1542      1543      1544 
      0.2639710 0.5025621 0.6607947 0.5825445 0.8463985 0.6607947 0.2500383 0.3698991 
           1545      1546      1547      1548      1549      1550      1551      1552 
      0.8463985 0.8463985 0.3120550 0.6607947 0.6607947 0.1726988 0.2639710 0.2254449 
           1553      1554      1555      1556      1557      1558      1559      1560 
      0.2979029 0.3698991 0.4364813 0.3120550 0.5847767 0.2254449 0.6585473 0.3567994 
           1561      1562      1563      1564      1565      1566      1567      1568 
      0.1842596 0.5847767 0.9412824 0.5847767 0.6585473 0.6607947 0.5025621 0.9412824 
           1569      1570      1571      1572      1573      1574      1575      1576 
      0.1726988 0.4364813 0.7950139 0.6585473 0.7326843 0.4364813 0.3698991 0.5847767 
           1577      1578      1579      1580      1581      1582      1583      1584 
      0.3120550 0.5847767 0.5847767 0.8463985 0.2500383 0.3698991 0.8368960 0.1726988 
           1585      1586      1587      1588      1589      1590      1591      1592 
      0.8870283 0.7267631 0.5847767 0.2979029 0.1954771 0.7326843 0.7326843 0.3567994 
           1593      1594      1595      1596      1597      1598      1599      1600 
      0.5847767 0.2639710 0.5847767 0.5093386 0.7950139 0.2639710 0.7950139 0.5093386 
           1601      1602      1603      1604      1605      1606      1607      1608 
      0.5847767 0.9704721 0.1632496 0.3698991 0.6607947 0.7326843 0.3698991 0.3698991 
           1609      1610      1611      1612      1613      1614      1615      1616 
      0.2979029 0.5093386 0.5825445 0.3698991 0.7326843 0.2500383 0.8870283 0.5825445 
           1617      1618      1619      1620      1621      1622      1623      1624 
      0.5093386 0.2639710 0.4364813 0.1954771 0.5847767 0.7950139 0.5825445 0.5093386 
           1625      1626      1627      1628      1629      1630      1631      1632 
      0.3567994 0.2126244 0.6607947 0.7326843 0.8870283 0.7326843 0.5825445 0.4258949 
           1633      1634      1635      1636      1637      1638      1639      1640 
      0.5093386 0.6607947 0.2639710 0.7326843 0.7326843 0.7326843 0.3120550 0.5093386 
           1641      1642      1643      1644      1645      1646      1647      1648 
      0.8870283 0.6607947 0.4258949 0.6607947 0.5093386 0.7950139 0.2979029 0.7326843 
           1649      1650      1651      1652      1653      1654      1655      1656 
      0.5025621 0.5025621 0.3120550 0.7950139 0.3120550 0.5093386 0.4364813 0.5825445 
           1657      1658      1659      1660      1661      1662      1663      1664 
      0.2639710 0.4364813 0.1954771 0.7950139 0.6585473 0.7950139 0.9412824 0.5093386 
           1665      1666      1667      1668      1669      1670      1671      1672 
      0.2979029 0.5093386 0.5847767 0.8463985 0.1431489 0.6607947 0.3120550 0.3120550 
           1673      1674      1675      1676      1677      1678      1679      1680 
      0.5025621 0.2126244 0.4258949 0.5025621 0.7326843 0.5093386 0.5093386 0.7326843 
           1681      1682      1683      1684      1685      1686      1687      1688 
      0.4258949 0.2979029 0.5825445 0.7326843 0.5025621 0.4258949 0.2639710 0.2639710 
           1689      1690      1691      1692      1693      1694      1695      1696 
      0.2254449 0.7267631 0.3698991 0.5825445 0.5025621 0.2500383 0.6585473 0.3120550 
           1697      1698      1699      1700      1701      1702      1703      1704 
      0.3698991 0.6585473 0.4364813 0.4364813 0.1556872 0.1431489 0.5825445 0.5025621 
           1705      1706      1707      1708      1709      1710      1711      1712 
      0.3698991 0.2639710 0.7267631 0.6607947 0.9181070 0.5825445 0.1954771 0.3567994 
           1713      1714      1715      1716      1717      1718      1719      1720 
      0.2639710 0.5825445 0.3120550 0.4364813 0.9412824 0.5025621 0.2254449 0.2639710 
           1721      1722      1723      1724      1725      1726      1727      1728 
      0.6607947 0.2254449 0.7326843 0.3698991 0.5093386 0.6585473 0.5847767 0.2254449 
           1729      1730      1731      1732      1733      1734      1735      1736 
      0.5847767 0.1954771 0.3698991 0.4364813 0.8463985 0.5825445 0.6607947 0.5093386 
           1737      1738      1739      1740      1741      1742      1743      1744 
      0.1726988 0.6585473 0.2639710 0.5093386 0.5847767 0.2979029 0.4364813 0.9704721 
           1745      1746      1747      1748      1749      1750      1751      1752 
      0.5093386 0.3698991 0.2639710 0.3120550 0.8463985 0.1726988 0.4258949 0.7326843 
           1753      1754      1755      1756      1757      1758      1759      1760 
      0.2639710 0.9582384 0.3120550 0.6585473 0.5025621 0.2639710 0.3120550 0.7267631 
           1761      1762      1763      1764      1765      1766      1767      1768 
      0.8463985 0.2500383 0.3120550 0.5025621 0.5847767 0.8774494 0.9582384 0.6607947 
           1769      1770      1771      1772      1773      1774      1775      1776 
      0.5093386 0.8463985 0.3567994 0.2979029 0.7950139 0.5847767 0.1842596 0.8870283 
           1777      1778      1779      1780      1781      1782      1783      1784 
      0.6607947 0.4364813 0.2254449 0.3698991 0.7866563 0.2979029 0.2639710 0.5093386 
           1785      1786      1787      1788      1789      1790      1791      1792 
      0.2126244 0.1726988 0.3698991 0.6585473 0.7950139 0.7950139 0.4258949 0.5847767 
           1793      1794      1795      1796      1797      1798      1799      1800 
      0.7950139 0.5847767 0.9412824 0.6585473 0.3698991 0.7950139 0.5847767 0.5825445 
           1801      1802      1803      1804      1805      1806      1807      1808 
      0.3120550 0.5847767 0.7866563 0.3120550 0.5825445 0.5825445 0.3567994 0.5025621 
           1809      1810      1811      1812      1813      1814      1815      1816 
      0.4364813 0.5825445 0.4258949 0.8870283 0.3120550 0.5093386 0.2126244 0.3698991 
           1817      1818      1819      1820      1821      1822      1823      1824 
      0.8463985 0.2254449 0.6607947 0.2254449 0.3698991 0.9181070 0.4364813 0.3120550 
           1825      1826      1827      1828      1829      1830      1831      1832 
      0.2254449 0.2639710 0.7326843 0.7866563 0.1726988 0.1726988 0.5825445 0.5093386 
           1833      1834      1835      1836      1837      1838      1839      1840 
      0.6607947 0.3698991 0.2254449 0.2979029 0.5093386 0.3567994 0.4364813 0.5093386 
           1841      1842      1843      1844      1845      1846      1847      1848 
      0.5025621 0.7326843 0.7866563 0.3698991 0.5025621 0.7866563 0.6607947 0.1726988 
           1849      1850      1851      1852      1853      1854      1855      1856 
      0.6607947 0.1954771 0.5025621 0.2639710 0.2639710 0.6607947 0.5847767 0.8463985 
           1857      1858      1859      1860      1861      1862      1863      1864 
      0.2254449 0.3120550 0.5825445 0.4364813 0.4364813 0.3567994 0.2126244 0.2254449 
           1865      1866      1867      1868      1869      1870      1871      1872 
      0.3120550 0.7950139 0.7950139 0.4364813 0.2639710 0.5847767 0.6585473 0.5825445 
           1873      1874      1875      1876      1877      1878      1879      1880 
      0.8463985 0.6607947 0.6585473 0.3698991 0.3567994 0.6585473 0.6607947 0.7950139 
           1881      1882      1883      1884      1885      1886      1887      1888 
      0.8870283 0.5825445 0.3698991 0.2979029 0.7267631 0.6585473 0.7326843 0.4364813 
           1889      1890      1891      1892      1893      1894      1895      1896 
      0.6585473 0.4258949 0.1726988 0.5025621 0.1954771 0.5093386 0.4258949 0.5025621 
           1897      1898      1899      1900      1901      1902      1903      1904 
      0.5825445 0.5825445 0.8463985 0.5825445 0.4364813 0.5847767 0.6607947 0.3120550 
           1905      1906      1907      1908      1909      1910      1911      1912 
      0.7326843 0.7267631 0.2979029 0.7326843 0.7326843 0.3120550 0.7326843 0.6607947 
           1913      1914      1915      1916      1917      1918      1919      1920 
      0.3120550 0.8463985 0.3698991 0.5025621 0.7267631 0.7950139 0.3120550 0.7326843 
           1921      1922      1923      1924      1925      1926      1927      1928 
      0.3698991 0.3698991 0.1954771 0.1726988 0.9181070 0.2639710 0.5825445 0.3567994 
           1929      1930      1931      1932      1933      1934      1935      1936 
      0.6585473 0.4258949 0.2500383 0.5093386 0.6607947 0.2639710 0.5025621 0.5093386 
           1937      1938      1939      1940      1941      1942      1943      1944 
      0.8463985 0.2639710 0.2500383 0.5825445 0.4364813 0.5093386 0.6607947 0.2254449 
           1945      1946      1947      1948      1949      1950      1951      1952 
      0.4364813 0.8870283 0.5847767 0.7326843 0.7326843 0.3120550 0.6585473 0.9091805 
           1953      1954      1955      1956      1957      1958      1959      1960 
      0.2979029 0.7267631 0.5025621 0.4258949 0.6607947 0.3120550 0.7326843 0.7326843 
           1961      1962      1963      1964      1965      1966      1967      1968 
      0.3567994 0.8463985 0.5093386 0.5847767 0.5825445 0.3567994 0.6585473 0.7267631 
           1969      1970      1971      1972      1973      1974      1975      1976 
      0.4364813 0.8463985 0.5847767 0.5825445 0.5825445 0.1954771 0.5825445 0.7326843 
           1977      1978      1979      1980      1981      1982      1983      1984 
      0.5025621 0.4258949 0.3120550 0.1556872 0.3567994 0.6607947 0.5093386 0.3567994 
           1985      1986      1987      1988      1989      1990      1991      1992 
      0.2639710 0.3567994 0.4364813 0.7326843 0.2979029 0.8368960 0.3120550 0.6607947 
           1993      1994      1995      1996      1997      1998      1999      2000 
      0.2979029 0.7326843 0.8368960 0.5093386 0.4364813 0.7326843 0.7326843 0.7267631 

---

    Code
      summary(residuals(fit1))
    Output
           Item1                Item2                Item3          
       Min.   :-0.9412824   Min.   :-0.9314870   Min.   :-0.932174  
       1st Qu.:-0.3698991   1st Qu.:-0.4272403   1st Qu.:-0.503827  
       Median : 0.0818930   Median : 0.1573856   Median : 0.177257  
       Mean   :-0.0001467   Mean   :-0.0006539   Mean   :-0.002202  
       3rd Qu.: 0.4152233   3rd Qu.: 0.3637518   3rd Qu.: 0.292406  
       Max.   : 0.8443128   Max.   : 0.8829579   Max.   : 0.653850  
           Item4               Item5               Item6           
       Min.   :-0.936174   Min.   :-0.968908   Min.   :-0.9010826  
       1st Qu.: 0.077120   1st Qu.: 0.043100   1st Qu.:-0.4807352  
       Median : 0.158674   Median : 0.108763   Median : 0.1642555  
       Mean   : 0.000033   Mean   : 0.002275   Mean   : 0.0004391  
       3rd Qu.: 0.220781   3rd Qu.: 0.186779   3rd Qu.: 0.3180502  
       Max.   : 0.590711   Max.   : 0.574219   Max.   : 0.8244711  
           Item7                Item8                Item9           
       Min.   :-0.8851430   Min.   :-0.9101997   Min.   :-0.8614888  
       1st Qu.:-0.4890386   1st Qu.:-0.4831021   1st Qu.:-0.5056860  
       Median : 0.2111020   Median : 0.2142025   Median : 0.2282535  
       Mean   : 0.0005126   Mean   : 0.0009005   Mean   : 0.0003707  
       3rd Qu.: 0.3426624   3rd Qu.: 0.3589697   3rd Qu.: 0.3974888  
       Max.   : 0.7690036   Max.   : 0.7267992   Max.   : 0.7788047  
           Item10               Item11               Item12          
       Min.   :-0.8362669   Min.   :-0.9316052   Min.   :-0.8873538  
       1st Qu.:-0.5002406   1st Qu.:-0.4619166   1st Qu.:-0.4532789  
       Median : 0.2289536   Median : 0.1821138   Median : 0.1806710  
       Mean   : 0.0004637   Mean   : 0.0003882   Mean   : 0.0006462  
       3rd Qu.: 0.4020989   3rd Qu.: 0.3379863   3rd Qu.: 0.4403448  
       Max.   : 0.7747230   Max.   : 0.8171048   Max.   : 0.7330316  
           Item13               Item14              Item15          
       Min.   :-0.9364053   Min.   :-0.846923   Min.   :-0.8203574  
       1st Qu.:-0.4702768   1st Qu.:-0.391395   1st Qu.:-0.4952739  
       Median : 0.1899360   Median :-0.206135   Median : 0.2097287  
       Mean   :-0.0001134   Mean   : 0.000785   Mean   : 0.0006185  
       3rd Qu.: 0.2708100   3rd Qu.: 0.482109   3rd Qu.: 0.4567820  
       Max.   : 0.5898026   Max.   : 0.865499   Max.   : 0.7635355  
           Item16              Item17               Item18          
       Min.   :-0.896687   Min.   :-0.7793370   Min.   :-0.8303705  
       1st Qu.:-0.380265   1st Qu.:-0.4142573   1st Qu.:-0.3447702  
       Median :-0.176930   Median :-0.2407092   Median :-0.1413968  
       Mean   : 0.001382   Mean   : 0.0005929   Mean   : 0.0007223  
       3rd Qu.: 0.465682   3rd Qu.: 0.4923666   3rd Qu.: 0.4255570  
       Max.   : 0.870413   Max.   : 0.8175671   Max.   : 0.9089239  
           Item19               Item20          
       Min.   :-0.9068390   Min.   :-0.8715910  
       1st Qu.:-0.4038863   1st Qu.:-0.3379118  
       Median :-0.1494888   Median :-0.2490140  
       Mean   : 0.0007949   Mean   : 0.0007879  
       3rd Qu.: 0.4376773   3rd Qu.: 0.4729031  
       Max.   : 0.8915756   Max.   : 0.7866203  

---

    Code
      residuals(fit1, item = 1)
    Output
                1           2           3           4           5           6 
      -0.43648127  0.21334366  0.11297173 -0.22544489  0.20498605 -0.29790295 
                7           8           9          10          11          12 
       0.49066136  0.57410507  0.20498605  0.21334366  0.15360152  0.27323691 
               13          14          15          16          17          18 
      -0.43648127 -0.50256206 -0.73268430 -0.35679939  0.41745549  0.27323691 
               19          20          21          22          23          24 
      -0.43648127 -0.31205497  0.57410507  0.16310397  0.11297173  0.15360152 
               25          26          27          28          29          30 
       0.33920533  0.49743794  0.21334366 -0.50256206  0.27323691 -0.26397099 
               31          32          33          34          35          36 
      -0.50256206 -0.65854732 -0.79501395 -0.31205497  0.56351873 -0.50933864 
               37          38          39          40          41          42 
      -0.66079467  0.15360152  0.49743794 -0.58477674 -0.26397099  0.49743794 
               43          44          45          46          47          48 
      -0.50256206  0.20498605  0.20498605 -0.43648127 -0.31205497  0.49743794 
               49          50          51          52          53          54 
       0.77455511 -0.50933864  0.49066136 -0.26397099  0.82730124 -0.50933864 
               55          56          57          58          59          60 
       0.68794503  0.41745549 -0.31205497  0.49066136 -0.50933864  0.49066136 
               61          62          63          64          65          66 
       0.09081953 -0.66079467  0.68794503 -0.22544489  0.34145268 -0.73268430 
               67          68          69          70          71          72 
      -0.22544489  0.26731570 -0.14314887  0.05871759 -0.42589493 -0.22544489 
               73          74          75          76          77          78 
       0.56351873  0.41745549 -0.50256206  0.77455511  0.34145268 -0.25003829 
               79          80          81          82          83          84 
      -0.31205497  0.49743794  0.49066136 -0.58254451 -0.22544489 -0.35679939 
               85          86          87          88          89          90 
      -0.50256206 -0.65854732  0.70209705 -0.35679939 -0.43648127 -0.73268430 
               91          92          93          94          95          96 
      -0.29790295  0.27323691 -0.43648127  0.27323691  0.73602901 -0.22544489 
               97          98          99         100         101         102 
       0.63010089  0.15360152 -0.26397099  0.12255063  0.04176155  0.49066136 
              103         104         105         106         107         108 
       0.49066136  0.33920533 -0.36989911 -0.21262439  0.20498605 -0.79501395 
              109         110         111         112         113         114 
       0.33920533 -0.17269876  0.34145268 -0.43648127  0.63010089  0.15360152 
              115         116         117         118         119         120 
      -0.31205497 -0.58254451  0.68794503  0.11297173 -0.22544489  0.56351873 
              121         122         123         124         125         126 
       0.21334366 -0.43648127 -0.26397099  0.15360152 -0.26397099  0.49743794 
              127         128         129         130         131         132 
       0.73602901 -0.25003829 -0.26397099 -0.29790295  0.56351873 -0.42589493 
              133         134         135         136         137         138 
      -0.42589493  0.15360152 -0.36989911 -0.36989911 -0.18425962  0.41522326 
              139         140         141         142         143         144 
       0.26731570  0.15360152 -0.36989911  0.80452289 -0.29790295  0.20498605 
              145         146         147         148         149         150 
       0.49743794 -0.66079467  0.08189303  0.26731570 -0.22544489  0.68794503 
              151         152         153         154         155         156 
      -0.26397099 -0.22544489  0.33920533 -0.43648127  0.15360152 -0.35679939 
              157         158         159         160         161         162 
      -0.22544489  0.08189303  0.05871759  0.63010089  0.57410507  0.49066136 
              163         164         165         166         167         168 
      -0.91810697 -0.17269876  0.57410507 -0.43648127  0.33920533 -0.91810697 
              169         170         171         172         173         174 
      -0.26397099  0.20498605 -0.29790295  0.33920533 -0.58477674  0.41745549 
              175         176         177         178         179         180 
      -0.73268430  0.57410507 -0.43648127  0.21334366  0.11297173 -0.19547711 
              181         182         183         184         185         186 
       0.63010089  0.11297173  0.08189303  0.16310397 -0.58477674 -0.50256206 
              187         188         189         190         191         192 
       0.11297173 -0.35679939 -0.15568724  0.26731570 -0.31205497  0.49743794 
              193         194         195         196         197         198 
       0.26731570 -0.17269876  0.08189303  0.41745549 -0.58254451 -0.66079467 
              199         200         201         202         203         204 
       0.20498605  0.56351873 -0.31205497  0.41745549 -0.25003829  0.20498605 
              205         206         207         208         209         210 
       0.11297173 -0.73268430  0.26731570 -0.43648127  0.20498605 -0.36989911 
              211         212         213         214         215         216 
      -0.58477674  0.63010089  0.74996171 -0.50933864 -0.19547711 -0.29790295 
              217         218         219         220         221         222 
       0.26731570  0.20498605  0.05871759  0.26731570  0.41522326 -0.36989911 
              223         224         225         226         227         228 
      -0.36989911 -0.73268430 -0.36989911  0.57410507  0.26731570  0.49743794 
              229         230         231         232         233         234 
       0.41745549 -0.50933864  0.64320061  0.08189303  0.11297173  0.64320061 
              235         236         237         238         239         240 
       0.15360152 -0.73268430  0.41745549 -0.94128241 -0.31205497  0.08189303 
              241         242         243         244         245         246 
       0.26731570 -0.65854732  0.33920533  0.56351873  0.49743794 -0.31205497 
              247         248         249         250         251         252 
      -0.43648127 -0.58254451  0.41522326 -0.31205497  0.15360152  0.49743794 
              253         254         255         256         257         258 
       0.20498605 -0.66079467 -0.58477674 -0.58477674  0.33920533  0.56351873 
              259         260         261         262         263         264 
       0.27323691  0.20498605 -0.14314887  0.34145268 -0.35679939 -0.26397099 
              265         266         267         268         269         270 
       0.33920533 -0.58254451  0.15360152 -0.43648127  0.21334366 -0.17269876 
              271         272         273         274         275         276 
      -0.43648127 -0.66079467  0.20498605 -0.35679939  0.08189303 -0.31205497 
              277         278         279         280         281         282 
      -0.50933864 -0.19547711  0.64320061 -0.50933864 -0.26397099  0.26731570 
              283         284         285         286         287         288 
       0.41745549 -0.42589493 -0.58477674 -0.78665634  0.49743794 -0.79501395 
              289         290         291         292         293         294 
       0.05871759 -0.42589493 -0.42589493 -0.26397099  0.68794503 -0.58254451 
              295         296         297         298         299         300 
       0.56351873  0.15360152  0.41522326 -0.50256206  0.41522326  0.15360152 
              301         302         303         304         305         306 
       0.41522326 -0.36989911 -0.35679939 -0.25003829 -0.66079467  0.08189303 
              307         308         309         310         311         312 
       0.20498605  0.08189303  0.57410507 -0.36989911 -0.66079467 -0.26397099 
              313         314         315         316         317         318 
      -0.43648127 -0.50933864  0.12255063  0.20498605 -0.50933864 -0.65854732 
              319         320         321         322         323         324 
       0.41745549 -0.31205497  0.73602901  0.49066136  0.26731570 -0.13399692 
              325         326         327         328         329         330 
       0.34145268  0.26731570 -0.35679939  0.20498605  0.26731570 -0.17269876 
              331         332         333         334         335         336 
      -0.31205497 -0.36989911 -0.43648127  0.73602901  0.11297173  0.49743794 
              337         338         339         340         341         342 
      -0.58254451  0.56351873  0.33920533 -0.36989911 -0.66079467  0.41522326 
              343         344         345         346         347         348 
       0.20498605 -0.73268430  0.49743794  0.49743794  0.56351873  0.57410507 
              349         350         351         352         353         354 
       0.15360152 -0.26397099 -0.19547711  0.15360152 -0.58254451  0.33920533 
              355         356         357         358         359         360 
      -0.29790295  0.15360152 -0.50933864 -0.26397099 -0.29790295  0.57410507 
              361         362         363         364         365         366 
       0.21334366  0.73602901 -0.50933864 -0.29790295  0.11297173 -0.43648127 
              367         368         369         370         371         372 
      -0.35679939 -0.31205497 -0.26397099 -0.58477674 -0.35679939 -0.50933864 
              373         374         375         376         377         378 
       0.77455511 -0.42589493  0.41745549  0.68794503 -0.17269876 -0.73268430 
              379         380         381         382         383         384 
       0.49743794  0.20498605  0.15360152 -0.50933864  0.57410507 -0.58254451 
              385         386         387         388         389         390 
      -0.66079467  0.05871759 -0.50256206  0.02952791 -0.35679939 -0.15568724 
              391         392         393         394         395         396 
      -0.31205497 -0.36989911  0.27323691 -0.50933864 -0.50256206  0.63010089 
              397         398         399         400         401         402 
      -0.42589493  0.16310397 -0.83689603  0.15360152 -0.25003829 -0.31205497 
              403         404         405         406         407         408 
      -0.43648127 -0.84639848  0.08189303 -0.36989911  0.49066136  0.41522326 
              409         410         411         412         413         414 
       0.56351873  0.16310397  0.34145268  0.56351873  0.20498605 -0.42589493 
              415         416         417         418         419         420 
      -0.58254451 -0.19547711  0.49066136 -0.29790295  0.57410507  0.84431276 
              421         422         423         424         425         426 
      -0.31205497  0.34145268 -0.43648127 -0.43648127  0.49066136 -0.35679939 
              427         428         429         430         431         432 
      -0.65854732  0.34145268 -0.50933864  0.49743794 -0.36989911  0.56351873 
              433         434         435         436         437         438 
       0.49743794  0.15360152 -0.31205497  0.21334366  0.20498605  0.73602901 
              439         440         441         442         443         444 
       0.74996171 -0.50933864  0.41522326  0.49066136  0.26731570 -0.22544489 
              445         446         447         448         449         450 
      -0.31205497  0.20498605 -0.65854732 -0.65854732 -0.19547711 -0.31205497 
              451         452         453         454         455         456 
       0.41522326 -0.17269876  0.16310397  0.49066136  0.49743794  0.27323691 
              457         458         459         460         461         462 
       0.49066136  0.41522326  0.68794503  0.26731570  0.49066136  0.41522326 
              463         464         465         466         467         468 
      -0.72676309 -0.79501395  0.78737561  0.73602901 -0.50933864  0.26731570 
              469         470         471         472         473         474 
      -0.58477674  0.34145268 -0.58254451  0.33920533 -0.31205497 -0.50256206 
              475         476         477         478         479         480 
       0.20498605  0.26731570 -0.35679939 -0.50933864 -0.50933864  0.26731570 
              481         482         483         484         485         486 
       0.15360152 -0.58477674  0.20498605  0.26731570  0.49743794 -0.31205497 
              487         488         489         490         491         492 
       0.20498605 -0.66079467 -0.43648127  0.34145268 -0.73268430 -0.22544489 
              493         494         495         496         497         498 
       0.77455511 -0.31205497 -0.50256206  0.80452289  0.70209705  0.41522326 
              499         500         501         502         503         504 
      -0.50256206  0.21334366 -0.84639848 -0.25003829 -0.36989911  0.68794503 
              505         506         507         508         509         510 
      -0.50256206  0.57410507  0.68794503 -0.43648127  0.68794503  0.68794503 
              511         512         513         514         515         516 
      -0.31205497 -0.18425962 -0.21262439  0.33920533 -0.72676309 -0.29790295 
              517         518         519         520         521         522 
      -0.36989911  0.57410507 -0.26397099  0.49066136  0.41745549  0.49066136 
              523         524         525         526         527         528 
       0.09081953 -0.78665634  0.49066136  0.34145268  0.11297173 -0.58477674 
              529         530         531         532         533         534 
      -0.26397099 -0.84639848  0.15360152 -0.58477674 -0.36989911  0.57410507 
              535         536         537         538         539         540 
       0.68794503  0.33920533  0.33920533  0.26731570  0.49743794  0.49066136 
              541         542         543         544         545         546 
      -0.26397099 -0.36989911  0.34145268 -0.35679939  0.49743794  0.26731570 
              547         548         549         550         551         552 
      -0.50933864 -0.43648127 -0.36989911  0.77455511 -0.43648127 -0.22544489 
              553         554         555         556         557         558 
       0.26731570  0.56351873  0.64320061 -0.43648127  0.34145268 -0.26397099 
              559         560         561         562         563         564 
       0.33920533  0.49066136  0.15360152 -0.25003829  0.49743794  0.20498605 
              565         566         567         568         569         570 
       0.56351873  0.41522326 -0.26397099 -0.73268430  0.08189303  0.57410507 
              571         572         573         574         575         576 
      -0.50256206 -0.72676309 -0.36989911  0.56351873  0.49743794 -0.50933864 
              577         578         579         580         581         582 
      -0.36989911  0.26731570  0.82730124 -0.36989911  0.57410507 -0.19547711 
              583         584         585         586         587         588 
       0.49743794 -0.50256206  0.49066136 -0.26397099 -0.43648127 -0.15568724 
              589         590         591         592         593         594 
      -0.79501395  0.56351873  0.11297173 -0.21262439  0.64320061  0.41745549 
              595         596         597         598         599         600 
      -0.50256206  0.49743794  0.56351873 -0.22544489  0.41522326 -0.66079467 
              601         602         603         604         605         606 
       0.73602901 -0.25003829  0.63010089  0.73602901 -0.31205497  0.26731570 
              607         608         609         610         611         612 
      -0.84639848 -0.73268430  0.21334366  0.41522326  0.33920533 -0.58477674 
              613         614         615         616         617         618 
      -0.58254451  0.21334366  0.56351873 -0.15568724 -0.50256206 -0.15568724 
              619         620         621         622         623         624 
      -0.73268430 -0.29790295 -0.43648127  0.80452289 -0.43648127 -0.43648127 
              625         626         627         628         629         630 
      -0.36989911 -0.19547711 -0.79501395  0.57410507  0.11297173  0.26731570 
              631         632         633         634         635         636 
      -0.22544489 -0.66079467  0.41745549  0.20498605  0.26731570  0.15360152 
              637         638         639         640         641         642 
       0.33920533  0.26731570  0.41745549  0.11297173 -0.42589493 -0.58254451 
              643         644         645         646         647         648 
       0.41745549 -0.58477674  0.77455511 -0.35679939  0.68794503  0.64320061 
              649         650         651         652         653         654 
      -0.42589493  0.49743794 -0.87744937 -0.42589493  0.26731570  0.26731570 
              655         656         657         658         659         660 
      -0.66079467 -0.43648127 -0.79501395  0.26731570 -0.19547711  0.26731570 
              661         662         663         664         665         666 
      -0.31205497  0.20498605 -0.26397099 -0.31205497  0.68794503  0.02952791 
              667         668         669         670         671         672 
      -0.58254451  0.33920533  0.70209705 -0.22544489 -0.36989911  0.41522326 
              673         674         675         676         677         678 
      -0.43648127 -0.31205497  0.26731570 -0.58477674 -0.19547711 -0.43648127 
              679         680         681         682         683         684 
      -0.31205497  0.56351873 -0.17269876 -0.42589493 -0.31205497 -0.15568724 
              685         686         687         688         689         690 
       0.33920533 -0.88702827 -0.43648127  0.16310397 -0.31205497  0.63010089 
              691         692         693         694         695         696 
       0.15360152 -0.50933864  0.49743794 -0.50933864 -0.25003829  0.20498605 
              697         698         699         700         701         702 
       0.20498605  0.49743794  0.73602901  0.20498605  0.74996171  0.73602901 
              703         704         705         706         707         708 
       0.08189303 -0.26397099  0.63010089  0.70209705 -0.79501395 -0.42589493 
              709         710         711         712         713         714 
       0.57410507  0.68794503  0.84431276  0.11297173  0.20498605  0.41745549 
              715         716         717         718         719         720 
      -0.50933864 -0.50933864  0.41745549 -0.19547711 -0.31205497 -0.50256206 
              721         722         723         724         725         726 
       0.49066136  0.57410507 -0.50256206 -0.58254451 -0.84639848 -0.72676309 
              727         728         729         730         731         732 
      -0.19547711 -0.36989911 -0.50933864  0.33920533 -0.36989911 -0.73268430 
              733         734         735         736         737         738 
      -0.58254451  0.63010089 -0.65854732  0.63010089  0.26731570 -0.22544489 
              739         740         741         742         743         744 
      -0.35679939  0.16310397 -0.50933864 -0.58477674  0.16310397  0.26731570 
              745         746         747         748         749         750 
      -0.31205497  0.49066136 -0.25003829 -0.88702827  0.27323691 -0.29790295 
              751         752         753         754         755         756 
       0.27323691 -0.58477674 -0.58477674  0.33920533 -0.50256206  0.26731570 
              757         758         759         760         761         762 
      -0.42589493  0.63010089 -0.66079467  0.05871759 -0.22544489  0.63010089 
              763         764         765         766         767         768 
       0.34145268 -0.17269876  0.73602901 -0.31205497 -0.50256206 -0.58254451 
              769         770         771         772         773         774 
      -0.50256206 -0.35679939 -0.35679939  0.11297173  0.26731570 -0.50933864 
              775         776         777         778         779         780 
      -0.31205497 -0.35679939  0.34145268  0.26731570 -0.36989911  0.15360152 
              781         782         783         784         785         786 
       0.33920533  0.64320061  0.20498605 -0.36989911 -0.42589493  0.68794503 
              787         788         789         790         791         792 
      -0.26397099  0.49743794  0.49743794  0.41522326  0.70209705  0.15360152 
              793         794         795         796         797         798 
      -0.50256206  0.26731570 -0.19547711  0.49743794  0.56351873 -0.58254451 
              799         800         801         802         803         804 
      -0.35679939 -0.26397099  0.41745549 -0.58254451  0.20498605  0.16310397 
              805         806         807         808         809         810 
       0.27323691 -0.73268430 -0.31205497 -0.42589493 -0.26397099  0.16310397 
              811         812         813         814         815         816 
       0.15360152 -0.50933864 -0.72676309  0.20498605 -0.26397099 -0.42589493 
              817         818         819         820         821         822 
      -0.22544489 -0.50933864 -0.43648127 -0.19547711 -0.79501395  0.26731570 
              823         824         825         826         827         828 
       0.20498605  0.11297173  0.11297173  0.63010089  0.57410507 -0.19547711 
              829         830         831         832         833         834 
      -0.50256206 -0.43648127 -0.22544489 -0.25003829 -0.50933864  0.49066136 
              835         836         837         838         839         840 
      -0.31205497 -0.22544489  0.56351873 -0.35679939 -0.84639848  0.41522326 
              841         842         843         844         845         846 
       0.33920533  0.57410507 -0.73268430 -0.29790295 -0.58477674 -0.36989911 
              847         848         849         850         851         852 
      -0.26397099 -0.26397099  0.26731570 -0.17269876 -0.50256206  0.57410507 
              853         854         855         856         857         858 
      -0.58254451 -0.25003829  0.41745549 -0.36989911 -0.50933864  0.41745549 
              859         860         861         862         863         864 
       0.49066136 -0.73268430  0.49066136  0.26731570 -0.65854732  0.21334366 
              865         866         867         868         869         870 
       0.56351873 -0.58477674  0.16310397  0.49066136  0.41745549 -0.26397099 
              871         872         873         874         875         876 
       0.41745549  0.11297173  0.33920533  0.63010089  0.08189303  0.26731570 
              877         878         879         880         881         882 
       0.41745549  0.64320061  0.56351873  0.34145268 -0.36989911 -0.19547711 
              883         884         885         886         887         888 
       0.49743794  0.11297173  0.41745549  0.56351873  0.33920533  0.41745549 
              889         890         891         892         893         894 
      -0.36989911  0.20498605  0.57410507 -0.19547711  0.57410507  0.34145268 
              895         896         897         898         899         900 
       0.41522326  0.56351873 -0.31205497  0.16310397 -0.65854732  0.33920533 
              901         902         903         904         905         906 
      -0.58254451 -0.31205497  0.21334366  0.68794503  0.26731570 -0.26397099 
              907         908         909         910         911         912 
       0.26731570  0.41522326  0.68794503  0.20498605  0.33920533 -0.36989911 
              913         914         915         916         917         918 
      -0.58477674  0.41745549 -0.36989911  0.20498605  0.63010089  0.56351873 
              919         920         921         922         923         924 
       0.41522326  0.11297173 -0.58477674  0.64320061 -0.42589493 -0.50256206 
              925         926         927         928         929         930 
       0.33920533 -0.19547711  0.41745549  0.41522326  0.49743794 -0.58477674 
              931         932         933         934         935         936 
       0.26731570  0.21334366  0.41745549 -0.42589493 -0.58254451 -0.36989911 
              937         938         939         940         941         942 
      -0.58477674 -0.72676309 -0.19547711 -0.73268430 -0.50933864 -0.42589493 
              943         944         945         946         947         948 
      -0.36989911  0.11297173 -0.31205497 -0.58477674 -0.19547711 -0.25003829 
              949         950         951         952         953         954 
       0.41745549  0.49743794  0.41522326  0.49066136 -0.36989911  0.11297173 
              955         956         957         958         959         960 
       0.33920533  0.80452289 -0.50256206 -0.50933864  0.77455511  0.15360152 
              961         962         963         964         965         966 
       0.21334366 -0.26397099  0.80452289 -0.66079467 -0.22544489 -0.22544489 
              967         968         969         970         971         972 
      -0.43648127  0.34145268  0.56351873  0.73602901  0.63010089 -0.17269876 
              973         974         975         976         977         978 
      -0.58254451 -0.72676309 -0.36989911  0.33920533 -0.72676309  0.27323691 
              979         980         981         982         983         984 
       0.33920533 -0.73268430  0.34145268  0.08189303 -0.58254451 -0.79501395 
              985         986         987         988         989         990 
       0.77455511 -0.66079467 -0.58254451 -0.26397099  0.49066136  0.41522326 
              991         992         993         994         995         996 
      -0.13399692  0.41522326  0.49066136 -0.36989911  0.26731570 -0.35679939 
              997         998         999        1000        1001        1002 
      -0.91810697 -0.36989911  0.11297173  0.33920533  0.41745549  0.64320061 
             1003        1004        1005        1006        1007        1008 
      -0.22544489  0.57410507  0.26731570 -0.29790295  0.04176155 -0.66079467 
             1009        1010        1011        1012        1013        1014 
       0.41522326  0.49743794 -0.22544489 -0.66079467 -0.16324961  0.56351873 
             1015        1016        1017        1018        1019        1020 
       0.41745549  0.73602901  0.82730124  0.26731570 -0.35679939  0.41745549 
             1021        1022        1023        1024        1025        1026 
       0.26731570 -0.42589493  0.08189303  0.57410507  0.34145268  0.56351873 
             1027        1028        1029        1030        1031        1032 
       0.33920533  0.77455511 -0.31205497  0.33920533 -0.42589493  0.41522326 
             1033        1034        1035        1036        1037        1038 
       0.49066136 -0.19547711  0.27323691 -0.58254451 -0.15568724 -0.42589493 
             1039        1040        1041        1042        1043        1044 
      -0.73268430 -0.18425962  0.33920533  0.63010089 -0.42589493 -0.65854732 
             1045        1046        1047        1048        1049        1050 
       0.34145268 -0.66079467 -0.31205497  0.64320061 -0.36989911  0.20498605 
             1051        1052        1053        1054        1055        1056 
      -0.26397099  0.68794503 -0.66079467 -0.42589493  0.49066136 -0.43648127 
             1057        1058        1059        1060        1061        1062 
       0.74996171  0.56351873 -0.36989911  0.63010089 -0.29790295  0.64320061 
             1063        1064        1065        1066        1067        1068 
       0.41522326  0.49743794  0.26731570  0.26731570  0.20498605  0.15360152 
             1069        1070        1071        1072        1073        1074 
      -0.35679939 -0.66079467 -0.43648127 -0.42589493 -0.43648127 -0.15568724 
             1075        1076        1077        1078        1079        1080 
       0.20498605  0.20498605 -0.14314887  0.77455511 -0.50256206 -0.26397099 
             1081        1082        1083        1084        1085        1086 
       0.57410507  0.77455511  0.05871759 -0.17269876  0.49743794  0.73602901 
             1087        1088        1089        1090        1091        1092 
      -0.25003829  0.49743794 -0.21262439  0.57410507  0.41522326  0.20498605 
             1093        1094        1095        1096        1097        1098 
      -0.88702827  0.20498605 -0.66079467 -0.50933864 -0.58477674  0.80452289 
             1099        1100        1101        1102        1103        1104 
       0.68794503  0.68794503  0.05871759 -0.25003829  0.26731570  0.73602901 
             1105        1106        1107        1108        1109        1110 
      -0.72676309 -0.58477674 -0.31205497  0.57410507  0.49066136  0.57410507 
             1111        1112        1113        1114        1115        1116 
       0.41522326 -0.43648127 -0.36989911 -0.25003829 -0.73268430  0.34145268 
             1117        1118        1119        1120        1121        1122 
       0.49743794  0.33920533  0.49066136  0.20498605  0.11297173  0.26731570 
             1123        1124        1125        1126        1127        1128 
       0.49743794  0.33920533  0.41745549  0.41745549 -0.35679939  0.63010089 
             1129        1130        1131        1132        1133        1134 
       0.57410507  0.33920533 -0.17269876 -0.36989911  0.16310397 -0.42589493 
             1135        1136        1137        1138        1139        1140 
       0.11297173  0.57410507 -0.29790295 -0.50256206  0.74996171  0.41745549 
             1141        1142        1143        1144        1145        1146 
      -0.36989911 -0.17269876 -0.36989911  0.63010089  0.41522326 -0.58477674 
             1147        1148        1149        1150        1151        1152 
       0.20498605 -0.50933864 -0.36989911 -0.43648127  0.33920533 -0.25003829 
             1153        1154        1155        1156        1157        1158 
      -0.25003829 -0.22544489 -0.79501395  0.08189303  0.11297173 -0.43648127 
             1159        1160        1161        1162        1163        1164 
       0.08189303 -0.73268430 -0.21262439 -0.22544489  0.49743794  0.27323691 
             1165        1166        1167        1168        1169        1170 
       0.26731570 -0.21262439 -0.50256206  0.77455511  0.49743794 -0.73268430 
             1171        1172        1173        1174        1175        1176 
       0.57410507 -0.42589493  0.70209705  0.09081953  0.05871759 -0.72676309 
             1177        1178        1179        1180        1181        1182 
      -0.79501395  0.49066136 -0.15568724  0.41745549  0.20498605 -0.50256206 
             1183        1184        1185        1186        1187        1188 
       0.49743794 -0.66079467 -0.43648127 -0.58254451 -0.31205497  0.41522326 
             1189        1190        1191        1192        1193        1194 
      -0.50933864  0.57410507  0.33920533  0.12255063 -0.78665634  0.49066136 
             1195        1196        1197        1198        1199        1200 
       0.20498605  0.68794503 -0.79501395  0.56351873  0.74996171  0.21334366 
             1201        1202        1203        1204        1205        1206 
       0.34145268  0.41522326 -0.35679939  0.33920533 -0.42589493  0.11297173 
             1207        1208        1209        1210        1211        1212 
       0.08189303 -0.26397099  0.08189303  0.68794503  0.68794503 -0.66079467 
             1213        1214        1215        1216        1217        1218 
      -0.36989911  0.05871759  0.63010089  0.56351873 -0.65854732 -0.65854732 
             1219        1220        1221        1222        1223        1224 
      -0.83689603 -0.17269876 -0.50933864  0.20498605  0.56351873 -0.58254451 
             1225        1226        1227        1228        1229        1230 
      -0.31205497  0.20498605  0.63010089 -0.72676309  0.26731570  0.56351873 
             1231        1232        1233        1234        1235        1236 
       0.49066136 -0.79501395 -0.50933864 -0.73268430  0.08189303 -0.35679939 
             1237        1238        1239        1240        1241        1242 
       0.20498605 -0.42589493 -0.73268430 -0.31205497  0.41745549  0.33920533 
             1243        1244        1245        1246        1247        1248 
       0.41745549  0.26731570 -0.72676309 -0.50256206  0.27323691 -0.58254451 
             1249        1250        1251        1252        1253        1254 
       0.05871759 -0.31205497  0.68794503 -0.31205497  0.56351873 -0.50933864 
             1255        1256        1257        1258        1259        1260 
       0.63010089 -0.22544489 -0.50933864 -0.73268430  0.49743794 -0.58254451 
             1261        1262        1263        1264        1265        1266 
       0.49066136 -0.19547711 -0.31205497  0.33920533 -0.58254451 -0.17269876 
             1267        1268        1269        1270        1271        1272 
      -0.50256206  0.33920533  0.49743794 -0.29790295  0.70209705 -0.50933864 
             1273        1274        1275        1276        1277        1278 
       0.27323691 -0.35679939  0.21334366  0.26731570  0.68794503  0.15360152 
             1279        1280        1281        1282        1283        1284 
      -0.43648127 -0.65854732 -0.31205497  0.08189303 -0.17269876  0.41522326 
             1285        1286        1287        1288        1289        1290 
       0.41522326 -0.25003829  0.49743794  0.05871759 -0.17269876 -0.50933864 
             1291        1292        1293        1294        1295        1296 
      -0.84639848 -0.17269876  0.41522326  0.34145268 -0.66079467 -0.43648127 
             1297        1298        1299        1300        1301        1302 
       0.34145268  0.15360152  0.63010089 -0.58477674  0.20498605 -0.17269876 
             1303        1304        1305        1306        1307        1308 
       0.20498605 -0.31205497  0.21334366 -0.66079467 -0.26397099 -0.58254451 
             1309        1310        1311        1312        1313        1314 
      -0.50256206  0.15360152  0.15360152  0.57410507 -0.36989911  0.77455511 
             1315        1316        1317        1318        1319        1320 
      -0.50933864 -0.73268430  0.20498605  0.11297173  0.27323691  0.33920533 
             1321        1322        1323        1324        1325        1326 
       0.41522326  0.63010089 -0.50256206  0.20498605 -0.65854732 -0.26397099 
             1327        1328        1329        1330        1331        1332 
       0.68794503  0.49066136  0.15360152  0.70209705  0.34145268 -0.50256206 
             1333        1334        1335        1336        1337        1338 
      -0.73268430  0.63010089 -0.50256206  0.20498605  0.73602901  0.41745549 
             1339        1340        1341        1342        1343        1344 
       0.20498605  0.73602901  0.68794503  0.08189303  0.41745549 -0.29790295 
             1345        1346        1347        1348        1349        1350 
       0.41745549 -0.43648127 -0.50256206  0.77455511 -0.31205497  0.49066136 
             1351        1352        1353        1354        1355        1356 
       0.63010089 -0.50256206  0.11297173  0.21334366 -0.35679939  0.41522326 
             1357        1358        1359        1360        1361        1362 
      -0.50933864  0.41745549  0.21334366  0.15360152 -0.26397099  0.33920533 
             1363        1364        1365        1366        1367        1368 
       0.41745549  0.77455511  0.49066136  0.33920533  0.08189303  0.63010089 
             1369        1370        1371        1372        1373        1374 
       0.33920533  0.08189303  0.34145268  0.33920533  0.09081953 -0.31205497 
             1375        1376        1377        1378        1379        1380 
       0.56351873  0.49066136  0.20498605 -0.43648127 -0.58254451 -0.42589493 
             1381        1382        1383        1384        1385        1386 
      -0.22544489 -0.50256206 -0.58254451 -0.19547711  0.20498605 -0.31205497 
             1387        1388        1389        1390        1391        1392 
      -0.36989911 -0.19547711 -0.15568724  0.20498605  0.49066136 -0.50933864 
             1393        1394        1395        1396        1397        1398 
       0.26731570  0.21334366  0.21334366  0.26731570 -0.42589493  0.41522326 
             1399        1400        1401        1402        1403        1404 
      -0.43648127 -0.21262439  0.20498605  0.02952791 -0.42589493  0.20498605 
             1405        1406        1407        1408        1409        1410 
      -0.36989911  0.63010089 -0.66079467 -0.50933864  0.12255063  0.20498605 
             1411        1412        1413        1414        1415        1416 
      -0.25003829  0.49743794 -0.26397099 -0.35679939 -0.42589493 -0.91810697 
             1417        1418        1419        1420        1421        1422 
       0.34145268 -0.73268430 -0.21262439 -0.58477674 -0.31205497  0.49066136 
             1423        1424        1425        1426        1427        1428 
       0.56351873  0.15360152  0.33920533  0.26731570  0.33920533 -0.29790295 
             1429        1430        1431        1432        1433        1434 
      -0.42589493 -0.19547711 -0.72676309 -0.31205497  0.41745549  0.49743794 
             1435        1436        1437        1438        1439        1440 
      -0.42589493  0.80452289 -0.73268430  0.04176155  0.26731570  0.49743794 
             1441        1442        1443        1444        1445        1446 
       0.80452289 -0.73268430 -0.58477674  0.41745549  0.15360152 -0.26397099 
             1447        1448        1449        1450        1451        1452 
       0.21334366  0.64320061  0.33920533  0.27323691 -0.88702827 -0.43648127 
             1453        1454        1455        1456        1457        1458 
      -0.36989911  0.57410507  0.41522326  0.34145268 -0.73268430 -0.31205497 
             1459        1460        1461        1462        1463        1464 
       0.49066136 -0.25003829  0.49743794 -0.58477674  0.68794503  0.73602901 
             1465        1466        1467        1468        1469        1470 
       0.20498605  0.49066136  0.49066136 -0.50933864 -0.66079467  0.80452289 
             1471        1472        1473        1474        1475        1476 
      -0.50256206  0.16310397 -0.21262439  0.20498605 -0.36989911 -0.29790295 
             1477        1478        1479        1480        1481        1482 
      -0.73268430 -0.15568724  0.15360152  0.26731570  0.63010089 -0.84639848 
             1483        1484        1485        1486        1487        1488 
       0.63010089  0.04176155  0.56351873 -0.50933864 -0.29790295  0.27323691 
             1489        1490        1491        1492        1493        1494 
       0.56351873 -0.66079467  0.33920533 -0.31205497 -0.50933864  0.26731570 
             1495        1496        1497        1498        1499        1500 
      -0.58254451 -0.36989911 -0.43648127  0.20498605  0.33920533 -0.58254451 
             1501        1502        1503        1504        1505        1506 
       0.26731570 -0.50933864  0.08189303  0.80452289  0.20498605 -0.66079467 
             1507        1508        1509        1510        1511        1512 
      -0.22544489 -0.50933864 -0.19547711 -0.50933864 -0.26397099 -0.43648127 
             1513        1514        1515        1516        1517        1518 
       0.63010089 -0.26397099  0.41745549  0.57410507 -0.58254451  0.49743794 
             1519        1520        1521        1522        1523        1524 
      -0.17269876  0.26731570 -0.43648127  0.34145268  0.49743794  0.20498605 
             1525        1526        1527        1528        1529        1530 
      -0.50933864  0.33920533 -0.25003829  0.33920533 -0.58254451  0.33920533 
             1531        1532        1533        1534        1535        1536 
       0.57410507  0.21334366  0.26731570 -0.43648127 -0.31205497  0.05871759 
             1537        1538        1539        1540        1541        1542 
      -0.26397099  0.49743794  0.33920533  0.41745549  0.15360152 -0.66079467 
             1543        1544        1545        1546        1547        1548 
      -0.25003829 -0.36989911  0.15360152  0.15360152 -0.31205497  0.33920533 
             1549        1550        1551        1552        1553        1554 
      -0.66079467 -0.17269876  0.73602901 -0.22544489 -0.29790295  0.63010089 
             1555        1556        1557        1558        1559        1560 
      -0.43648127 -0.31205497  0.41522326  0.77455511  0.34145268  0.64320061 
             1561        1562        1563        1564        1565        1566 
      -0.18425962  0.41522326 -0.94128241  0.41522326  0.34145268  0.33920533 
             1567        1568        1569        1570        1571        1572 
       0.49743794 -0.94128241  0.82730124 -0.43648127  0.20498605  0.34145268 
             1573        1574        1575        1576        1577        1578 
       0.26731570 -0.43648127 -0.36989911  0.41522326 -0.31205497 -0.58477674 
             1579        1580        1581        1582        1583        1584 
       0.41522326 -0.84639848 -0.25003829 -0.36989911  0.16310397  0.82730124 
             1585        1586        1587        1588        1589        1590 
       0.11297173  0.27323691 -0.58477674 -0.29790295 -0.19547711  0.26731570 
             1591        1592        1593        1594        1595        1596 
       0.26731570 -0.35679939  0.41522326 -0.26397099 -0.58477674 -0.50933864 
             1597        1598        1599        1600        1601        1602 
      -0.79501395 -0.26397099  0.20498605 -0.50933864  0.41522326  0.02952791 
             1603        1604        1605        1606        1607        1608 
      -0.16324961 -0.36989911  0.33920533  0.26731570  0.63010089 -0.36989911 
             1609        1610        1611        1612        1613        1614 
      -0.29790295  0.49066136  0.41745549 -0.36989911  0.26731570  0.74996171 
             1615        1616        1617        1618        1619        1620 
       0.11297173 -0.58254451  0.49066136 -0.26397099 -0.43648127 -0.19547711 
             1621        1622        1623        1624        1625        1626 
      -0.58477674  0.20498605  0.41745549  0.49066136 -0.35679939  0.78737561 
             1627        1628        1629        1630        1631        1632 
       0.33920533  0.26731570  0.11297173 -0.73268430  0.41745549 -0.42589493 
             1633        1634        1635        1636        1637        1638 
       0.49066136 -0.66079467 -0.26397099 -0.73268430  0.26731570 -0.73268430 
             1639        1640        1641        1642        1643        1644 
      -0.31205497  0.49066136  0.11297173 -0.66079467  0.57410507  0.33920533 
             1645        1646        1647        1648        1649        1650 
      -0.50933864  0.20498605  0.70209705 -0.73268430 -0.50256206  0.49743794 
             1651        1652        1653        1654        1655        1656 
       0.68794503  0.20498605 -0.31205497 -0.50933864  0.56351873  0.41745549 
             1657        1658        1659        1660        1661        1662 
      -0.26397099  0.56351873 -0.19547711 -0.79501395 -0.65854732  0.20498605 
             1663        1664        1665        1666        1667        1668 
       0.05871759 -0.50933864  0.70209705  0.49066136  0.41522326  0.15360152 
             1669        1670        1671        1672        1673        1674 
      -0.14314887  0.33920533 -0.31205497  0.68794503 -0.50256206  0.78737561 
             1675        1676        1677        1678        1679        1680 
      -0.42589493 -0.50256206 -0.73268430 -0.50933864  0.49066136  0.26731570 
             1681        1682        1683        1684        1685        1686 
      -0.42589493 -0.29790295 -0.58254451  0.26731570  0.49743794 -0.42589493 
             1687        1688        1689        1690        1691        1692 
       0.73602901 -0.26397099  0.77455511  0.27323691 -0.36989911  0.41745549 
             1693        1694        1695        1696        1697        1698 
       0.49743794 -0.25003829  0.34145268 -0.31205497  0.63010089  0.34145268 
             1699        1700        1701        1702        1703        1704 
      -0.43648127  0.56351873 -0.15568724 -0.14314887  0.41745549 -0.50256206 
             1705        1706        1707        1708        1709        1710 
      -0.36989911 -0.26397099  0.27323691  0.33920533 -0.91810697 -0.58254451 
             1711        1712        1713        1714        1715        1716 
      -0.19547711  0.64320061 -0.26397099 -0.58254451 -0.31205497 -0.43648127 
             1717        1718        1719        1720        1721        1722 
       0.05871759 -0.50256206 -0.22544489 -0.26397099  0.33920533 -0.22544489 
             1723        1724        1725        1726        1727        1728 
      -0.73268430 -0.36989911  0.49066136  0.34145268  0.41522326 -0.22544489 
             1729        1730        1731        1732        1733        1734 
       0.41522326 -0.19547711 -0.36989911  0.56351873  0.15360152  0.41745549 
             1735        1736        1737        1738        1739        1740 
       0.33920533 -0.50933864 -0.17269876 -0.65854732 -0.26397099  0.49066136 
             1741        1742        1743        1744        1745        1746 
      -0.58477674 -0.29790295 -0.43648127  0.02952791  0.49066136 -0.36989911 
             1747        1748        1749        1750        1751        1752 
      -0.26397099 -0.31205497  0.15360152 -0.17269876 -0.42589493  0.26731570 
             1753        1754        1755        1756        1757        1758 
      -0.26397099  0.04176155  0.68794503  0.34145268 -0.50256206 -0.26397099 
             1759        1760        1761        1762        1763        1764 
      -0.31205497  0.27323691  0.15360152 -0.25003829 -0.31205497  0.49743794 
             1765        1766        1767        1768        1769        1770 
       0.41522326  0.12255063  0.04176155  0.33920533 -0.50933864  0.15360152 
             1771        1772        1773        1774        1775        1776 
      -0.35679939 -0.29790295  0.20498605  0.41522326 -0.18425962  0.11297173 
             1777        1778        1779        1780        1781        1782 
      -0.66079467  0.56351873 -0.22544489  0.63010089  0.21334366 -0.29790295 
             1783        1784        1785        1786        1787        1788 
       0.73602901  0.49066136 -0.21262439 -0.17269876 -0.36989911  0.34145268 
             1789        1790        1791        1792        1793        1794 
       0.20498605  0.20498605 -0.42589493  0.41522326 -0.79501395  0.41522326 
             1795        1796        1797        1798        1799        1800 
       0.05871759  0.34145268  0.63010089  0.20498605  0.41522326  0.41745549 
             1801        1802        1803        1804        1805        1806 
      -0.31205497 -0.58477674  0.21334366 -0.31205497 -0.58254451 -0.58254451 
             1807        1808        1809        1810        1811        1812 
       0.64320061  0.49743794 -0.43648127 -0.58254451 -0.42589493  0.11297173 
             1813        1814        1815        1816        1817        1818 
      -0.31205497  0.49066136 -0.21262439 -0.36989911  0.15360152 -0.22544489 
             1819        1820        1821        1822        1823        1824 
       0.33920533  0.77455511  0.63010089  0.08189303  0.56351873  0.68794503 
             1825        1826        1827        1828        1829        1830 
      -0.22544489 -0.26397099  0.26731570 -0.78665634  0.82730124 -0.17269876 
             1831        1832        1833        1834        1835        1836 
      -0.58254451  0.49066136  0.33920533 -0.36989911 -0.22544489 -0.29790295 
             1837        1838        1839        1840        1841        1842 
       0.49066136 -0.35679939 -0.43648127 -0.50933864 -0.50256206  0.26731570 
             1843        1844        1845        1846        1847        1848 
       0.21334366 -0.36989911  0.49743794  0.21334366  0.33920533 -0.17269876 
             1849        1850        1851        1852        1853        1854 
      -0.66079467 -0.19547711 -0.50256206 -0.26397099 -0.26397099  0.33920533 
             1855        1856        1857        1858        1859        1860 
      -0.58477674  0.15360152 -0.22544489 -0.31205497 -0.58254451  0.56351873 
             1861        1862        1863        1864        1865        1866 
      -0.43648127 -0.35679939 -0.21262439 -0.22544489  0.68794503  0.20498605 
             1867        1868        1869        1870        1871        1872 
       0.20498605  0.56351873 -0.26397099 -0.58477674 -0.65854732 -0.58254451 
             1873        1874        1875        1876        1877        1878 
       0.15360152 -0.66079467  0.34145268  0.63010089  0.64320061  0.34145268 
             1879        1880        1881        1882        1883        1884 
       0.33920533  0.20498605  0.11297173 -0.58254451 -0.36989911 -0.29790295 
             1885        1886        1887        1888        1889        1890 
       0.27323691 -0.65854732  0.26731570  0.56351873 -0.65854732  0.57410507 
             1891        1892        1893        1894        1895        1896 
      -0.17269876  0.49743794 -0.19547711  0.49066136  0.57410507 -0.50256206 
             1897        1898        1899        1900        1901        1902 
       0.41745549 -0.58254451  0.15360152 -0.58254451 -0.43648127 -0.58477674 
             1903        1904        1905        1906        1907        1908 
       0.33920533 -0.31205497  0.26731570 -0.72676309 -0.29790295  0.26731570 
             1909        1910        1911        1912        1913        1914 
       0.26731570 -0.31205497  0.26731570  0.33920533 -0.31205497  0.15360152 
             1915        1916        1917        1918        1919        1920 
       0.63010089 -0.50256206  0.27323691  0.20498605 -0.31205497  0.26731570 
             1921        1922        1923        1924        1925        1926 
      -0.36989911  0.63010089 -0.19547711 -0.17269876  0.08189303 -0.26397099 
             1927        1928        1929        1930        1931        1932 
       0.41745549  0.64320061  0.34145268  0.57410507 -0.25003829  0.49066136 
             1933        1934        1935        1936        1937        1938 
       0.33920533 -0.26397099 -0.50256206 -0.50933864  0.15360152  0.73602901 
             1939        1940        1941        1942        1943        1944 
      -0.25003829  0.41745549  0.56351873  0.49066136  0.33920533 -0.22544489 
             1945        1946        1947        1948        1949        1950 
      -0.43648127  0.11297173 -0.58477674  0.26731570  0.26731570 -0.31205497 
             1951        1952        1953        1954        1955        1956 
       0.34145268  0.09081953  0.70209705  0.27323691 -0.50256206 -0.42589493 
             1957        1958        1959        1960        1961        1962 
       0.33920533  0.68794503  0.26731570  0.26731570 -0.35679939  0.15360152 
             1963        1964        1965        1966        1967        1968 
      -0.50933864  0.41522326 -0.58254451  0.64320061  0.34145268  0.27323691 
             1969        1970        1971        1972        1973        1974 
      -0.43648127  0.15360152  0.41522326 -0.58254451  0.41745549 -0.19547711 
             1975        1976        1977        1978        1979        1980 
      -0.58254451  0.26731570 -0.50256206 -0.42589493 -0.31205497 -0.15568724 
             1981        1982        1983        1984        1985        1986 
      -0.35679939  0.33920533 -0.50933864  0.64320061 -0.26397099  0.64320061 
             1987        1988        1989        1990        1991        1992 
       0.56351873  0.26731570  0.70209705  0.16310397  0.68794503  0.33920533 
             1993        1994        1995        1996        1997        1998 
      -0.29790295  0.26731570  0.16310397 -0.50933864 -0.43648127  0.26731570 
             1999        2000 
       0.26731570  0.27323691 

---

    Code
      summary(predict(fit1))
    Output
            item           match         group          prob        
       Item1  : 2000   Min.   :-2.7699   0:20000   Min.   :0.06246  
       Item2  : 2000   1st Qu.:-0.5161   1:20000   1st Qu.:0.43153  
       Item3  : 2000   Median : 0.1278             Median :0.59037  
       Item4  : 2000   Mean   : 0.0000             Mean   :0.57972  
       Item5  : 2000   3rd Qu.: 0.7718             3rd Qu.:0.74058  
       Item6  : 2000   Max.   : 2.7036             Max.   :0.98863  
       (Other):28000                                                

---

    Code
      predict(fit1, item = 1)
    Output
            item      match group      prob
      1    Item1  0.1278239     1 0.4364813
      2    Item1  1.7376967     1 0.7866563
      3    Item1  1.4157221     0 0.8870283
      4    Item1 -1.1600743     1 0.2254449
      5    Item1  0.7717730     0 0.7950139
      6    Item1 -1.4820489     0 0.2979029
      7    Item1  0.4497985     1 0.5093386
      8    Item1 -0.8380998     0 0.4258949
      9    Item1  0.7717730     0 0.7950139
      10   Item1  1.7376967     1 0.7866563
      11   Item1  1.0937476     0 0.8463985
      12   Item1  1.4157221     1 0.7267631
      13   Item1  0.1278239     1 0.4364813
      14   Item1 -0.5161252     0 0.5025621
      15   Item1  0.4497985     0 0.7326843
      16   Item1 -1.1600743     0 0.3567994
      17   Item1 -0.1941507     0 0.5825445
      18   Item1  1.4157221     1 0.7267631
      19   Item1  0.1278239     1 0.4364813
      20   Item1 -0.5161252     1 0.3120550
      21   Item1 -0.8380998     0 0.4258949
      22   Item1  2.0596712     1 0.8368960
      23   Item1  1.4157221     0 0.8870283
      24   Item1  1.0937476     0 0.8463985
      25   Item1  0.1278239     0 0.6607947
      26   Item1 -0.5161252     0 0.5025621
      27   Item1  1.7376967     1 0.7866563
      28   Item1 -0.5161252     0 0.5025621
      29   Item1  1.4157221     1 0.7267631
      30   Item1 -0.8380998     1 0.2639710
      31   Item1 -0.5161252     0 0.5025621
      32   Item1  1.0937476     1 0.6585473
      33   Item1  0.7717730     0 0.7950139
      34   Item1 -0.5161252     1 0.3120550
      35   Item1  0.1278239     1 0.4364813
      36   Item1  0.4497985     1 0.5093386
      37   Item1  0.1278239     0 0.6607947
      38   Item1  1.0937476     0 0.8463985
      39   Item1 -0.5161252     0 0.5025621
      40   Item1  0.7717730     1 0.5847767
      41   Item1 -0.8380998     1 0.2639710
      42   Item1 -0.5161252     0 0.5025621
      43   Item1 -0.5161252     0 0.5025621
      44   Item1  0.7717730     0 0.7950139
      45   Item1  0.7717730     0 0.7950139
      46   Item1  0.1278239     1 0.4364813
      47   Item1 -0.5161252     1 0.3120550
      48   Item1 -0.5161252     0 0.5025621
      49   Item1 -1.1600743     1 0.2254449
      50   Item1  0.4497985     1 0.5093386
      51   Item1  0.4497985     1 0.5093386
      52   Item1 -0.8380998     1 0.2639710
      53   Item1 -1.8040234     1 0.1726988
      54   Item1  0.4497985     1 0.5093386
      55   Item1 -0.5161252     1 0.3120550
      56   Item1 -0.1941507     0 0.5825445
      57   Item1 -0.5161252     1 0.3120550
      58   Item1  0.4497985     1 0.5093386
      59   Item1  0.4497985     1 0.5093386
      60   Item1  0.4497985     1 0.5093386
      61   Item1  2.7036203     1 0.9091805
      62   Item1  0.1278239     0 0.6607947
      63   Item1 -0.5161252     1 0.3120550
      64   Item1 -1.1600743     1 0.2254449
      65   Item1  1.0937476     1 0.6585473
      66   Item1  0.4497985     0 0.7326843
      67   Item1 -1.1600743     1 0.2254449
      68   Item1  0.4497985     0 0.7326843
      69   Item1 -2.4479725     1 0.1431489
      70   Item1  2.0596712     0 0.9412824
      71   Item1 -0.8380998     0 0.4258949
      72   Item1 -1.1600743     1 0.2254449
      73   Item1  0.1278239     1 0.4364813
      74   Item1 -0.1941507     0 0.5825445
      75   Item1 -0.5161252     0 0.5025621
      76   Item1 -1.1600743     1 0.2254449
      77   Item1  1.0937476     1 0.6585473
      78   Item1 -1.8040234     0 0.2500383
      79   Item1 -0.5161252     1 0.3120550
      80   Item1 -0.5161252     0 0.5025621
      81   Item1  0.4497985     1 0.5093386
      82   Item1 -0.1941507     0 0.5825445
      83   Item1 -1.1600743     1 0.2254449
      84   Item1 -1.1600743     0 0.3567994
      85   Item1 -0.5161252     0 0.5025621
      86   Item1  1.0937476     1 0.6585473
      87   Item1 -1.4820489     0 0.2979029
      88   Item1 -1.1600743     0 0.3567994
      89   Item1  0.1278239     1 0.4364813
      90   Item1  0.4497985     0 0.7326843
      91   Item1 -1.4820489     0 0.2979029
      92   Item1  1.4157221     1 0.7267631
      93   Item1  0.1278239     1 0.4364813
      94   Item1  1.4157221     1 0.7267631
      95   Item1 -0.8380998     1 0.2639710
      96   Item1 -1.1600743     1 0.2254449
      97   Item1 -0.1941507     1 0.3698991
      98   Item1  1.0937476     0 0.8463985
      99   Item1 -0.8380998     1 0.2639710
      100  Item1  2.3816458     1 0.8774494
      101  Item1  2.3816458     0 0.9582384
      102  Item1  0.4497985     1 0.5093386
      103  Item1  0.4497985     1 0.5093386
      104  Item1  0.1278239     0 0.6607947
      105  Item1 -0.1941507     1 0.3698991
      106  Item1 -2.1259980     0 0.2126244
      107  Item1  0.7717730     0 0.7950139
      108  Item1  0.7717730     0 0.7950139
      109  Item1  0.1278239     0 0.6607947
      110  Item1 -1.8040234     1 0.1726988
      111  Item1  1.0937476     1 0.6585473
      112  Item1  0.1278239     1 0.4364813
      113  Item1 -0.1941507     1 0.3698991
      114  Item1  1.0937476     0 0.8463985
      115  Item1 -0.5161252     1 0.3120550
      116  Item1 -0.1941507     0 0.5825445
      117  Item1 -0.5161252     1 0.3120550
      118  Item1  1.4157221     0 0.8870283
      119  Item1 -1.1600743     1 0.2254449
      120  Item1  0.1278239     1 0.4364813
      121  Item1  1.7376967     1 0.7866563
      122  Item1  0.1278239     1 0.4364813
      123  Item1 -0.8380998     1 0.2639710
      124  Item1  1.0937476     0 0.8463985
      125  Item1 -0.8380998     1 0.2639710
      126  Item1 -0.5161252     0 0.5025621
      127  Item1 -0.8380998     1 0.2639710
      128  Item1 -1.8040234     0 0.2500383
      129  Item1 -0.8380998     1 0.2639710
      130  Item1 -1.4820489     0 0.2979029
      131  Item1  0.1278239     1 0.4364813
      132  Item1 -0.8380998     0 0.4258949
      133  Item1 -0.8380998     0 0.4258949
      134  Item1  1.0937476     0 0.8463985
      135  Item1 -0.1941507     1 0.3698991
      136  Item1 -0.1941507     1 0.3698991
      137  Item1 -2.4479725     0 0.1842596
      138  Item1  0.7717730     1 0.5847767
      139  Item1  0.4497985     0 0.7326843
      140  Item1  1.0937476     0 0.8463985
      141  Item1 -0.1941507     1 0.3698991
      142  Item1 -1.4820489     1 0.1954771
      143  Item1 -1.4820489     0 0.2979029
      144  Item1  0.7717730     0 0.7950139
      145  Item1 -0.5161252     0 0.5025621
      146  Item1  0.1278239     0 0.6607947
      147  Item1  1.7376967     0 0.9181070
      148  Item1  0.4497985     0 0.7326843
      149  Item1 -1.1600743     1 0.2254449
      150  Item1 -0.5161252     1 0.3120550
      151  Item1 -0.8380998     1 0.2639710
      152  Item1 -1.1600743     1 0.2254449
      153  Item1  0.1278239     0 0.6607947
      154  Item1  0.1278239     1 0.4364813
      155  Item1  1.0937476     0 0.8463985
      156  Item1 -1.1600743     0 0.3567994
      157  Item1 -1.1600743     1 0.2254449
      158  Item1  1.7376967     0 0.9181070
      159  Item1  2.0596712     0 0.9412824
      160  Item1 -0.1941507     1 0.3698991
      161  Item1 -0.8380998     0 0.4258949
      162  Item1  0.4497985     1 0.5093386
      163  Item1  1.7376967     0 0.9181070
      164  Item1 -1.8040234     1 0.1726988
      165  Item1 -0.8380998     0 0.4258949
      166  Item1  0.1278239     1 0.4364813
      167  Item1  0.1278239     0 0.6607947
      168  Item1  1.7376967     0 0.9181070
      169  Item1 -0.8380998     1 0.2639710
      170  Item1  0.7717730     0 0.7950139
      171  Item1 -1.4820489     0 0.2979029
      172  Item1  0.1278239     0 0.6607947
      173  Item1  0.7717730     1 0.5847767
      174  Item1 -0.1941507     0 0.5825445
      175  Item1  0.4497985     0 0.7326843
      176  Item1 -0.8380998     0 0.4258949
      177  Item1  0.1278239     1 0.4364813
      178  Item1  1.7376967     1 0.7866563
      179  Item1  1.4157221     0 0.8870283
      180  Item1 -1.4820489     1 0.1954771
      181  Item1 -0.1941507     1 0.3698991
      182  Item1  1.4157221     0 0.8870283
      183  Item1  1.7376967     0 0.9181070
      184  Item1  2.0596712     1 0.8368960
      185  Item1  0.7717730     1 0.5847767
      186  Item1 -0.5161252     0 0.5025621
      187  Item1  1.4157221     0 0.8870283
      188  Item1 -1.1600743     0 0.3567994
      189  Item1 -2.1259980     1 0.1556872
      190  Item1  0.4497985     0 0.7326843
      191  Item1 -0.5161252     1 0.3120550
      192  Item1 -0.5161252     0 0.5025621
      193  Item1  0.4497985     0 0.7326843
      194  Item1 -1.8040234     1 0.1726988
      195  Item1  1.7376967     0 0.9181070
      196  Item1 -0.1941507     0 0.5825445
      197  Item1 -0.1941507     0 0.5825445
      198  Item1  0.1278239     0 0.6607947
      199  Item1  0.7717730     0 0.7950139
      200  Item1  0.1278239     1 0.4364813
      201  Item1 -0.5161252     1 0.3120550
      202  Item1 -0.1941507     0 0.5825445
      203  Item1 -1.8040234     0 0.2500383
      204  Item1  0.7717730     0 0.7950139
      205  Item1  1.4157221     0 0.8870283
      206  Item1  0.4497985     0 0.7326843
      207  Item1  0.4497985     0 0.7326843
      208  Item1  0.1278239     1 0.4364813
      209  Item1  0.7717730     0 0.7950139
      210  Item1 -0.1941507     1 0.3698991
      211  Item1  0.7717730     1 0.5847767
      212  Item1 -0.1941507     1 0.3698991
      213  Item1 -1.8040234     0 0.2500383
      214  Item1  0.4497985     1 0.5093386
      215  Item1 -1.4820489     1 0.1954771
      216  Item1 -1.4820489     0 0.2979029
      217  Item1  0.4497985     0 0.7326843
      218  Item1  0.7717730     0 0.7950139
      219  Item1  2.0596712     0 0.9412824
      220  Item1  0.4497985     0 0.7326843
      221  Item1  0.7717730     1 0.5847767
      222  Item1 -0.1941507     1 0.3698991
      223  Item1 -0.1941507     1 0.3698991
      224  Item1  0.4497985     0 0.7326843
      225  Item1 -0.1941507     1 0.3698991
      226  Item1 -0.8380998     0 0.4258949
      227  Item1  0.4497985     0 0.7326843
      228  Item1 -0.5161252     0 0.5025621
      229  Item1 -0.1941507     0 0.5825445
      230  Item1  0.4497985     1 0.5093386
      231  Item1 -1.1600743     0 0.3567994
      232  Item1  1.7376967     0 0.9181070
      233  Item1  1.4157221     0 0.8870283
      234  Item1 -1.1600743     0 0.3567994
      235  Item1  1.0937476     0 0.8463985
      236  Item1  0.4497985     0 0.7326843
      237  Item1 -0.1941507     0 0.5825445
      238  Item1  2.0596712     0 0.9412824
      239  Item1 -0.5161252     1 0.3120550
      240  Item1  1.7376967     0 0.9181070
      241  Item1  0.4497985     0 0.7326843
      242  Item1  1.0937476     1 0.6585473
      243  Item1  0.1278239     0 0.6607947
      244  Item1  0.1278239     1 0.4364813
      245  Item1 -0.5161252     0 0.5025621
      246  Item1 -0.5161252     1 0.3120550
      247  Item1  0.1278239     1 0.4364813
      248  Item1 -0.1941507     0 0.5825445
      249  Item1  0.7717730     1 0.5847767
      250  Item1 -0.5161252     1 0.3120550
      251  Item1  1.0937476     0 0.8463985
      252  Item1 -0.5161252     0 0.5025621
      253  Item1  0.7717730     0 0.7950139
      254  Item1  0.1278239     0 0.6607947
      255  Item1  0.7717730     1 0.5847767
      256  Item1  0.7717730     1 0.5847767
      257  Item1  0.1278239     0 0.6607947
      258  Item1  0.1278239     1 0.4364813
      259  Item1  1.4157221     1 0.7267631
      260  Item1  0.7717730     0 0.7950139
      261  Item1 -2.4479725     1 0.1431489
      262  Item1  1.0937476     1 0.6585473
      263  Item1 -1.1600743     0 0.3567994
      264  Item1 -0.8380998     1 0.2639710
      265  Item1  0.1278239     0 0.6607947
      266  Item1 -0.1941507     0 0.5825445
      267  Item1  1.0937476     0 0.8463985
      268  Item1  0.1278239     1 0.4364813
      269  Item1  1.7376967     1 0.7866563
      270  Item1 -1.8040234     1 0.1726988
      271  Item1  0.1278239     1 0.4364813
      272  Item1  0.1278239     0 0.6607947
      273  Item1  0.7717730     0 0.7950139
      274  Item1 -1.1600743     0 0.3567994
      275  Item1  1.7376967     0 0.9181070
      276  Item1 -0.5161252     1 0.3120550
      277  Item1  0.4497985     1 0.5093386
      278  Item1 -1.4820489     1 0.1954771
      279  Item1 -1.1600743     0 0.3567994
      280  Item1  0.4497985     1 0.5093386
      281  Item1 -0.8380998     1 0.2639710
      282  Item1  0.4497985     0 0.7326843
      283  Item1 -0.1941507     0 0.5825445
      284  Item1 -0.8380998     0 0.4258949
      285  Item1  0.7717730     1 0.5847767
      286  Item1  1.7376967     1 0.7866563
      287  Item1 -0.5161252     0 0.5025621
      288  Item1  0.7717730     0 0.7950139
      289  Item1  2.0596712     0 0.9412824
      290  Item1 -0.8380998     0 0.4258949
      291  Item1 -0.8380998     0 0.4258949
      292  Item1 -0.8380998     1 0.2639710
      293  Item1 -0.5161252     1 0.3120550
      294  Item1 -0.1941507     0 0.5825445
      295  Item1  0.1278239     1 0.4364813
      296  Item1  1.0937476     0 0.8463985
      297  Item1  0.7717730     1 0.5847767
      298  Item1 -0.5161252     0 0.5025621
      299  Item1  0.7717730     1 0.5847767
      300  Item1  1.0937476     0 0.8463985
      301  Item1  0.7717730     1 0.5847767
      302  Item1 -0.1941507     1 0.3698991
      303  Item1 -1.1600743     0 0.3567994
      304  Item1 -1.8040234     0 0.2500383
      305  Item1  0.1278239     0 0.6607947
      306  Item1  1.7376967     0 0.9181070
      307  Item1  0.7717730     0 0.7950139
      308  Item1  1.7376967     0 0.9181070
      309  Item1 -0.8380998     0 0.4258949
      310  Item1 -0.1941507     1 0.3698991
      311  Item1  0.1278239     0 0.6607947
      312  Item1 -0.8380998     1 0.2639710
      313  Item1  0.1278239     1 0.4364813
      314  Item1  0.4497985     1 0.5093386
      315  Item1  2.3816458     1 0.8774494
      316  Item1  0.7717730     0 0.7950139
      317  Item1  0.4497985     1 0.5093386
      318  Item1  1.0937476     1 0.6585473
      319  Item1 -0.1941507     0 0.5825445
      320  Item1 -0.5161252     1 0.3120550
      321  Item1 -0.8380998     1 0.2639710
      322  Item1  0.4497985     1 0.5093386
      323  Item1  0.4497985     0 0.7326843
      324  Item1 -2.7699471     1 0.1339969
      325  Item1  1.0937476     1 0.6585473
      326  Item1  0.4497985     0 0.7326843
      327  Item1 -1.1600743     0 0.3567994
      328  Item1  0.7717730     0 0.7950139
      329  Item1  0.4497985     0 0.7326843
      330  Item1 -1.8040234     1 0.1726988
      331  Item1 -0.5161252     1 0.3120550
      332  Item1 -0.1941507     1 0.3698991
      333  Item1  0.1278239     1 0.4364813
      334  Item1 -0.8380998     1 0.2639710
      335  Item1  1.4157221     0 0.8870283
      336  Item1 -0.5161252     0 0.5025621
      337  Item1 -0.1941507     0 0.5825445
      338  Item1  0.1278239     1 0.4364813
      339  Item1  0.1278239     0 0.6607947
      340  Item1 -0.1941507     1 0.3698991
      341  Item1  0.1278239     0 0.6607947
      342  Item1  0.7717730     1 0.5847767
      343  Item1  0.7717730     0 0.7950139
      344  Item1  0.4497985     0 0.7326843
      345  Item1 -0.5161252     0 0.5025621
      346  Item1 -0.5161252     0 0.5025621
      347  Item1  0.1278239     1 0.4364813
      348  Item1 -0.8380998     0 0.4258949
      349  Item1  1.0937476     0 0.8463985
      350  Item1 -0.8380998     1 0.2639710
      351  Item1 -1.4820489     1 0.1954771
      352  Item1  1.0937476     0 0.8463985
      353  Item1 -0.1941507     0 0.5825445
      354  Item1  0.1278239     0 0.6607947
      355  Item1 -1.4820489     0 0.2979029
      356  Item1  1.0937476     0 0.8463985
      357  Item1  0.4497985     1 0.5093386
      358  Item1 -0.8380998     1 0.2639710
      359  Item1 -1.4820489     0 0.2979029
      360  Item1 -0.8380998     0 0.4258949
      361  Item1  1.7376967     1 0.7866563
      362  Item1 -0.8380998     1 0.2639710
      363  Item1  0.4497985     1 0.5093386
      364  Item1 -1.4820489     0 0.2979029
      365  Item1  1.4157221     0 0.8870283
      366  Item1  0.1278239     1 0.4364813
      367  Item1 -1.1600743     0 0.3567994
      368  Item1 -0.5161252     1 0.3120550
      369  Item1 -0.8380998     1 0.2639710
      370  Item1  0.7717730     1 0.5847767
      371  Item1 -1.1600743     0 0.3567994
      372  Item1  0.4497985     1 0.5093386
      373  Item1 -1.1600743     1 0.2254449
      374  Item1 -0.8380998     0 0.4258949
      375  Item1 -0.1941507     0 0.5825445
      376  Item1 -0.5161252     1 0.3120550
      377  Item1 -1.8040234     1 0.1726988
      378  Item1  0.4497985     0 0.7326843
      379  Item1 -0.5161252     0 0.5025621
      380  Item1  0.7717730     0 0.7950139
      381  Item1  1.0937476     0 0.8463985
      382  Item1  0.4497985     1 0.5093386
      383  Item1 -0.8380998     0 0.4258949
      384  Item1 -0.1941507     0 0.5825445
      385  Item1  0.1278239     0 0.6607947
      386  Item1  2.0596712     0 0.9412824
      387  Item1 -0.5161252     0 0.5025621
      388  Item1  2.7036203     0 0.9704721
      389  Item1 -1.1600743     0 0.3567994
      390  Item1 -2.1259980     1 0.1556872
      391  Item1 -0.5161252     1 0.3120550
      392  Item1 -0.1941507     1 0.3698991
      393  Item1  1.4157221     1 0.7267631
      394  Item1  0.4497985     1 0.5093386
      395  Item1 -0.5161252     0 0.5025621
      396  Item1 -0.1941507     1 0.3698991
      397  Item1 -0.8380998     0 0.4258949
      398  Item1  2.0596712     1 0.8368960
      399  Item1  2.0596712     1 0.8368960
      400  Item1  1.0937476     0 0.8463985
      401  Item1 -1.8040234     0 0.2500383
      402  Item1 -0.5161252     1 0.3120550
      403  Item1  0.1278239     1 0.4364813
      404  Item1  1.0937476     0 0.8463985
      405  Item1  1.7376967     0 0.9181070
      406  Item1 -0.1941507     1 0.3698991
      407  Item1  0.4497985     1 0.5093386
      408  Item1  0.7717730     1 0.5847767
      409  Item1  0.1278239     1 0.4364813
      410  Item1  2.0596712     1 0.8368960
      411  Item1  1.0937476     1 0.6585473
      412  Item1  0.1278239     1 0.4364813
      413  Item1  0.7717730     0 0.7950139
      414  Item1 -0.8380998     0 0.4258949
      415  Item1 -0.1941507     0 0.5825445
      416  Item1 -1.4820489     1 0.1954771
      417  Item1  0.4497985     1 0.5093386
      418  Item1 -1.4820489     0 0.2979029
      419  Item1 -0.8380998     0 0.4258949
      420  Item1 -2.1259980     1 0.1556872
      421  Item1 -0.5161252     1 0.3120550
      422  Item1  1.0937476     1 0.6585473
      423  Item1  0.1278239     1 0.4364813
      424  Item1  0.1278239     1 0.4364813
      425  Item1  0.4497985     1 0.5093386
      426  Item1 -1.1600743     0 0.3567994
      427  Item1  1.0937476     1 0.6585473
      428  Item1  1.0937476     1 0.6585473
      429  Item1  0.4497985     1 0.5093386
      430  Item1 -0.5161252     0 0.5025621
      431  Item1 -0.1941507     1 0.3698991
      432  Item1  0.1278239     1 0.4364813
      433  Item1 -0.5161252     0 0.5025621
      434  Item1  1.0937476     0 0.8463985
      435  Item1 -0.5161252     1 0.3120550
      436  Item1  1.7376967     1 0.7866563
      437  Item1  0.7717730     0 0.7950139
      438  Item1 -0.8380998     1 0.2639710
      439  Item1 -1.8040234     0 0.2500383
      440  Item1  0.4497985     1 0.5093386
      441  Item1  0.7717730     1 0.5847767
      442  Item1  0.4497985     1 0.5093386
      443  Item1  0.4497985     0 0.7326843
      444  Item1 -1.1600743     1 0.2254449
      445  Item1 -0.5161252     1 0.3120550
      446  Item1  0.7717730     0 0.7950139
      447  Item1  1.0937476     1 0.6585473
      448  Item1  1.0937476     1 0.6585473
      449  Item1 -1.4820489     1 0.1954771
      450  Item1 -0.5161252     1 0.3120550
      451  Item1  0.7717730     1 0.5847767
      452  Item1 -1.8040234     1 0.1726988
      453  Item1  2.0596712     1 0.8368960
      454  Item1  0.4497985     1 0.5093386
      455  Item1 -0.5161252     0 0.5025621
      456  Item1  1.4157221     1 0.7267631
      457  Item1  0.4497985     1 0.5093386
      458  Item1  0.7717730     1 0.5847767
      459  Item1 -0.5161252     1 0.3120550
      460  Item1  0.4497985     0 0.7326843
      461  Item1  0.4497985     1 0.5093386
      462  Item1  0.7717730     1 0.5847767
      463  Item1  1.4157221     1 0.7267631
      464  Item1  0.7717730     0 0.7950139
      465  Item1 -2.1259980     0 0.2126244
      466  Item1 -0.8380998     1 0.2639710
      467  Item1  0.4497985     1 0.5093386
      468  Item1  0.4497985     0 0.7326843
      469  Item1  0.7717730     1 0.5847767
      470  Item1  1.0937476     1 0.6585473
      471  Item1 -0.1941507     0 0.5825445
      472  Item1  0.1278239     0 0.6607947
      473  Item1 -0.5161252     1 0.3120550
      474  Item1 -0.5161252     0 0.5025621
      475  Item1  0.7717730     0 0.7950139
      476  Item1  0.4497985     0 0.7326843
      477  Item1 -1.1600743     0 0.3567994
      478  Item1  0.4497985     1 0.5093386
      479  Item1  0.4497985     1 0.5093386
      480  Item1  0.4497985     0 0.7326843
      481  Item1  1.0937476     0 0.8463985
      482  Item1  0.7717730     1 0.5847767
      483  Item1  0.7717730     0 0.7950139
      484  Item1  0.4497985     0 0.7326843
      485  Item1 -0.5161252     0 0.5025621
      486  Item1 -0.5161252     1 0.3120550
      487  Item1  0.7717730     0 0.7950139
      488  Item1  0.1278239     0 0.6607947
      489  Item1  0.1278239     1 0.4364813
      490  Item1  1.0937476     1 0.6585473
      491  Item1  0.4497985     0 0.7326843
      492  Item1 -1.1600743     1 0.2254449
      493  Item1 -1.1600743     1 0.2254449
      494  Item1 -0.5161252     1 0.3120550
      495  Item1 -0.5161252     0 0.5025621
      496  Item1 -1.4820489     1 0.1954771
      497  Item1 -1.4820489     0 0.2979029
      498  Item1  0.7717730     1 0.5847767
      499  Item1 -0.5161252     0 0.5025621
      500  Item1  1.7376967     1 0.7866563
      501  Item1  1.0937476     0 0.8463985
      502  Item1 -1.8040234     0 0.2500383
      503  Item1 -0.1941507     1 0.3698991
      504  Item1 -0.5161252     1 0.3120550
      505  Item1 -0.5161252     0 0.5025621
      506  Item1 -0.8380998     0 0.4258949
      507  Item1 -0.5161252     1 0.3120550
      508  Item1  0.1278239     1 0.4364813
      509  Item1 -0.5161252     1 0.3120550
      510  Item1 -0.5161252     1 0.3120550
      511  Item1 -0.5161252     1 0.3120550
      512  Item1 -2.4479725     0 0.1842596
      513  Item1 -2.1259980     0 0.2126244
      514  Item1  0.1278239     0 0.6607947
      515  Item1  1.4157221     1 0.7267631
      516  Item1 -1.4820489     0 0.2979029
      517  Item1 -0.1941507     1 0.3698991
      518  Item1 -0.8380998     0 0.4258949
      519  Item1 -0.8380998     1 0.2639710
      520  Item1  0.4497985     1 0.5093386
      521  Item1 -0.1941507     0 0.5825445
      522  Item1  0.4497985     1 0.5093386
      523  Item1  2.7036203     1 0.9091805
      524  Item1  1.7376967     1 0.7866563
      525  Item1  0.4497985     1 0.5093386
      526  Item1  1.0937476     1 0.6585473
      527  Item1  1.4157221     0 0.8870283
      528  Item1  0.7717730     1 0.5847767
      529  Item1 -0.8380998     1 0.2639710
      530  Item1  1.0937476     0 0.8463985
      531  Item1  1.0937476     0 0.8463985
      532  Item1  0.7717730     1 0.5847767
      533  Item1 -0.1941507     1 0.3698991
      534  Item1 -0.8380998     0 0.4258949
      535  Item1 -0.5161252     1 0.3120550
      536  Item1  0.1278239     0 0.6607947
      537  Item1  0.1278239     0 0.6607947
      538  Item1  0.4497985     0 0.7326843
      539  Item1 -0.5161252     0 0.5025621
      540  Item1  0.4497985     1 0.5093386
      541  Item1 -0.8380998     1 0.2639710
      542  Item1 -0.1941507     1 0.3698991
      543  Item1  1.0937476     1 0.6585473
      544  Item1 -1.1600743     0 0.3567994
      545  Item1 -0.5161252     0 0.5025621
      546  Item1  0.4497985     0 0.7326843
      547  Item1  0.4497985     1 0.5093386
      548  Item1  0.1278239     1 0.4364813
      549  Item1 -0.1941507     1 0.3698991
      550  Item1 -1.1600743     1 0.2254449
      551  Item1  0.1278239     1 0.4364813
      552  Item1 -1.1600743     1 0.2254449
      553  Item1  0.4497985     0 0.7326843
      554  Item1  0.1278239     1 0.4364813
      555  Item1 -1.1600743     0 0.3567994
      556  Item1  0.1278239     1 0.4364813
      557  Item1  1.0937476     1 0.6585473
      558  Item1 -0.8380998     1 0.2639710
      559  Item1  0.1278239     0 0.6607947
      560  Item1  0.4497985     1 0.5093386
      561  Item1  1.0937476     0 0.8463985
      562  Item1 -1.8040234     0 0.2500383
      563  Item1 -0.5161252     0 0.5025621
      564  Item1  0.7717730     0 0.7950139
      565  Item1  0.1278239     1 0.4364813
      566  Item1  0.7717730     1 0.5847767
      567  Item1 -0.8380998     1 0.2639710
      568  Item1  0.4497985     0 0.7326843
      569  Item1  1.7376967     0 0.9181070
      570  Item1 -0.8380998     0 0.4258949
      571  Item1 -0.5161252     0 0.5025621
      572  Item1  1.4157221     1 0.7267631
      573  Item1 -0.1941507     1 0.3698991
      574  Item1  0.1278239     1 0.4364813
      575  Item1 -0.5161252     0 0.5025621
      576  Item1  0.4497985     1 0.5093386
      577  Item1 -0.1941507     1 0.3698991
      578  Item1  0.4497985     0 0.7326843
      579  Item1 -1.8040234     1 0.1726988
      580  Item1 -0.1941507     1 0.3698991
      581  Item1 -0.8380998     0 0.4258949
      582  Item1 -1.4820489     1 0.1954771
      583  Item1 -0.5161252     0 0.5025621
      584  Item1 -0.5161252     0 0.5025621
      585  Item1  0.4497985     1 0.5093386
      586  Item1 -0.8380998     1 0.2639710
      587  Item1  0.1278239     1 0.4364813
      588  Item1 -2.1259980     1 0.1556872
      589  Item1  0.7717730     0 0.7950139
      590  Item1  0.1278239     1 0.4364813
      591  Item1  1.4157221     0 0.8870283
      592  Item1 -2.1259980     0 0.2126244
      593  Item1 -1.1600743     0 0.3567994
      594  Item1 -0.1941507     0 0.5825445
      595  Item1 -0.5161252     0 0.5025621
      596  Item1 -0.5161252     0 0.5025621
      597  Item1  0.1278239     1 0.4364813
      598  Item1 -1.1600743     1 0.2254449
      599  Item1  0.7717730     1 0.5847767
      600  Item1  0.1278239     0 0.6607947
      601  Item1 -0.8380998     1 0.2639710
      602  Item1 -1.8040234     0 0.2500383
      603  Item1 -0.1941507     1 0.3698991
      604  Item1 -0.8380998     1 0.2639710
      605  Item1 -0.5161252     1 0.3120550
      606  Item1  0.4497985     0 0.7326843
      607  Item1  1.0937476     0 0.8463985
      608  Item1  0.4497985     0 0.7326843
      609  Item1  1.7376967     1 0.7866563
      610  Item1  0.7717730     1 0.5847767
      611  Item1  0.1278239     0 0.6607947
      612  Item1  0.7717730     1 0.5847767
      613  Item1 -0.1941507     0 0.5825445
      614  Item1  1.7376967     1 0.7866563
      615  Item1  0.1278239     1 0.4364813
      616  Item1 -2.1259980     1 0.1556872
      617  Item1 -0.5161252     0 0.5025621
      618  Item1 -2.1259980     1 0.1556872
      619  Item1  0.4497985     0 0.7326843
      620  Item1 -1.4820489     0 0.2979029
      621  Item1  0.1278239     1 0.4364813
      622  Item1 -1.4820489     1 0.1954771
      623  Item1  0.1278239     1 0.4364813
      624  Item1  0.1278239     1 0.4364813
      625  Item1 -0.1941507     1 0.3698991
      626  Item1 -1.4820489     1 0.1954771
      627  Item1  0.7717730     0 0.7950139
      628  Item1 -0.8380998     0 0.4258949
      629  Item1  1.4157221     0 0.8870283
      630  Item1  0.4497985     0 0.7326843
      631  Item1 -1.1600743     1 0.2254449
      632  Item1  0.1278239     0 0.6607947
      633  Item1 -0.1941507     0 0.5825445
      634  Item1  0.7717730     0 0.7950139
      635  Item1  0.4497985     0 0.7326843
      636  Item1  1.0937476     0 0.8463985
      637  Item1  0.1278239     0 0.6607947
      638  Item1  0.4497985     0 0.7326843
      639  Item1 -0.1941507     0 0.5825445
      640  Item1  1.4157221     0 0.8870283
      641  Item1 -0.8380998     0 0.4258949
      642  Item1 -0.1941507     0 0.5825445
      643  Item1 -0.1941507     0 0.5825445
      644  Item1  0.7717730     1 0.5847767
      645  Item1 -1.1600743     1 0.2254449
      646  Item1 -1.1600743     0 0.3567994
      647  Item1 -0.5161252     1 0.3120550
      648  Item1 -1.1600743     0 0.3567994
      649  Item1 -0.8380998     0 0.4258949
      650  Item1 -0.5161252     0 0.5025621
      651  Item1  2.3816458     1 0.8774494
      652  Item1 -0.8380998     0 0.4258949
      653  Item1  0.4497985     0 0.7326843
      654  Item1  0.4497985     0 0.7326843
      655  Item1  0.1278239     0 0.6607947
      656  Item1  0.1278239     1 0.4364813
      657  Item1  0.7717730     0 0.7950139
      658  Item1  0.4497985     0 0.7326843
      659  Item1 -1.4820489     1 0.1954771
      660  Item1  0.4497985     0 0.7326843
      661  Item1 -0.5161252     1 0.3120550
      662  Item1  0.7717730     0 0.7950139
      663  Item1 -0.8380998     1 0.2639710
      664  Item1 -0.5161252     1 0.3120550
      665  Item1 -0.5161252     1 0.3120550
      666  Item1  2.7036203     0 0.9704721
      667  Item1 -0.1941507     0 0.5825445
      668  Item1  0.1278239     0 0.6607947
      669  Item1 -1.4820489     0 0.2979029
      670  Item1 -1.1600743     1 0.2254449
      671  Item1 -0.1941507     1 0.3698991
      672  Item1  0.7717730     1 0.5847767
      673  Item1  0.1278239     1 0.4364813
      674  Item1 -0.5161252     1 0.3120550
      675  Item1  0.4497985     0 0.7326843
      676  Item1  0.7717730     1 0.5847767
      677  Item1 -1.4820489     1 0.1954771
      678  Item1  0.1278239     1 0.4364813
      679  Item1 -0.5161252     1 0.3120550
      680  Item1  0.1278239     1 0.4364813
      681  Item1 -1.8040234     1 0.1726988
      682  Item1 -0.8380998     0 0.4258949
      683  Item1 -0.5161252     1 0.3120550
      684  Item1 -2.1259980     1 0.1556872
      685  Item1  0.1278239     0 0.6607947
      686  Item1  1.4157221     0 0.8870283
      687  Item1  0.1278239     1 0.4364813
      688  Item1  2.0596712     1 0.8368960
      689  Item1 -0.5161252     1 0.3120550
      690  Item1 -0.1941507     1 0.3698991
      691  Item1  1.0937476     0 0.8463985
      692  Item1  0.4497985     1 0.5093386
      693  Item1 -0.5161252     0 0.5025621
      694  Item1  0.4497985     1 0.5093386
      695  Item1 -1.8040234     0 0.2500383
      696  Item1  0.7717730     0 0.7950139
      697  Item1  0.7717730     0 0.7950139
      698  Item1 -0.5161252     0 0.5025621
      699  Item1 -0.8380998     1 0.2639710
      700  Item1  0.7717730     0 0.7950139
      701  Item1 -1.8040234     0 0.2500383
      702  Item1 -0.8380998     1 0.2639710
      703  Item1  1.7376967     0 0.9181070
      704  Item1 -0.8380998     1 0.2639710
      705  Item1 -0.1941507     1 0.3698991
      706  Item1 -1.4820489     0 0.2979029
      707  Item1  0.7717730     0 0.7950139
      708  Item1 -0.8380998     0 0.4258949
      709  Item1 -0.8380998     0 0.4258949
      710  Item1 -0.5161252     1 0.3120550
      711  Item1 -2.1259980     1 0.1556872
      712  Item1  1.4157221     0 0.8870283
      713  Item1  0.7717730     0 0.7950139
      714  Item1 -0.1941507     0 0.5825445
      715  Item1  0.4497985     1 0.5093386
      716  Item1  0.4497985     1 0.5093386
      717  Item1 -0.1941507     0 0.5825445
      718  Item1 -1.4820489     1 0.1954771
      719  Item1 -0.5161252     1 0.3120550
      720  Item1 -0.5161252     0 0.5025621
      721  Item1  0.4497985     1 0.5093386
      722  Item1 -0.8380998     0 0.4258949
      723  Item1 -0.5161252     0 0.5025621
      724  Item1 -0.1941507     0 0.5825445
      725  Item1  1.0937476     0 0.8463985
      726  Item1  1.4157221     1 0.7267631
      727  Item1 -1.4820489     1 0.1954771
      728  Item1 -0.1941507     1 0.3698991
      729  Item1  0.4497985     1 0.5093386
      730  Item1  0.1278239     0 0.6607947
      731  Item1 -0.1941507     1 0.3698991
      732  Item1  0.4497985     0 0.7326843
      733  Item1 -0.1941507     0 0.5825445
      734  Item1 -0.1941507     1 0.3698991
      735  Item1  1.0937476     1 0.6585473
      736  Item1 -0.1941507     1 0.3698991
      737  Item1  0.4497985     0 0.7326843
      738  Item1 -1.1600743     1 0.2254449
      739  Item1 -1.1600743     0 0.3567994
      740  Item1  2.0596712     1 0.8368960
      741  Item1  0.4497985     1 0.5093386
      742  Item1  0.7717730     1 0.5847767
      743  Item1  2.0596712     1 0.8368960
      744  Item1  0.4497985     0 0.7326843
      745  Item1 -0.5161252     1 0.3120550
      746  Item1  0.4497985     1 0.5093386
      747  Item1 -1.8040234     0 0.2500383
      748  Item1  1.4157221     0 0.8870283
      749  Item1  1.4157221     1 0.7267631
      750  Item1 -1.4820489     0 0.2979029
      751  Item1  1.4157221     1 0.7267631
      752  Item1  0.7717730     1 0.5847767
      753  Item1  0.7717730     1 0.5847767
      754  Item1  0.1278239     0 0.6607947
      755  Item1 -0.5161252     0 0.5025621
      756  Item1  0.4497985     0 0.7326843
      757  Item1 -0.8380998     0 0.4258949
      758  Item1 -0.1941507     1 0.3698991
      759  Item1  0.1278239     0 0.6607947
      760  Item1  2.0596712     0 0.9412824
      761  Item1 -1.1600743     1 0.2254449
      762  Item1 -0.1941507     1 0.3698991
      763  Item1  1.0937476     1 0.6585473
      764  Item1 -1.8040234     1 0.1726988
      765  Item1 -0.8380998     1 0.2639710
      766  Item1 -0.5161252     1 0.3120550
      767  Item1 -0.5161252     0 0.5025621
      768  Item1 -0.1941507     0 0.5825445
      769  Item1 -0.5161252     0 0.5025621
      770  Item1 -1.1600743     0 0.3567994
      771  Item1 -1.1600743     0 0.3567994
      772  Item1  1.4157221     0 0.8870283
      773  Item1  0.4497985     0 0.7326843
      774  Item1  0.4497985     1 0.5093386
      775  Item1 -0.5161252     1 0.3120550
      776  Item1 -1.1600743     0 0.3567994
      777  Item1  1.0937476     1 0.6585473
      778  Item1  0.4497985     0 0.7326843
      779  Item1 -0.1941507     1 0.3698991
      780  Item1  1.0937476     0 0.8463985
      781  Item1  0.1278239     0 0.6607947
      782  Item1 -1.1600743     0 0.3567994
      783  Item1  0.7717730     0 0.7950139
      784  Item1 -0.1941507     1 0.3698991
      785  Item1 -0.8380998     0 0.4258949
      786  Item1 -0.5161252     1 0.3120550
      787  Item1 -0.8380998     1 0.2639710
      788  Item1 -0.5161252     0 0.5025621
      789  Item1 -0.5161252     0 0.5025621
      790  Item1  0.7717730     1 0.5847767
      791  Item1 -1.4820489     0 0.2979029
      792  Item1  1.0937476     0 0.8463985
      793  Item1 -0.5161252     0 0.5025621
      794  Item1  0.4497985     0 0.7326843
      795  Item1 -1.4820489     1 0.1954771
      796  Item1 -0.5161252     0 0.5025621
      797  Item1  0.1278239     1 0.4364813
      798  Item1 -0.1941507     0 0.5825445
      799  Item1 -1.1600743     0 0.3567994
      800  Item1 -0.8380998     1 0.2639710
      801  Item1 -0.1941507     0 0.5825445
      802  Item1 -0.1941507     0 0.5825445
      803  Item1  0.7717730     0 0.7950139
      804  Item1  2.0596712     1 0.8368960
      805  Item1  1.4157221     1 0.7267631
      806  Item1  0.4497985     0 0.7326843
      807  Item1 -0.5161252     1 0.3120550
      808  Item1 -0.8380998     0 0.4258949
      809  Item1 -0.8380998     1 0.2639710
      810  Item1  2.0596712     1 0.8368960
      811  Item1  1.0937476     0 0.8463985
      812  Item1  0.4497985     1 0.5093386
      813  Item1  1.4157221     1 0.7267631
      814  Item1  0.7717730     0 0.7950139
      815  Item1 -0.8380998     1 0.2639710
      816  Item1 -0.8380998     0 0.4258949
      817  Item1 -1.1600743     1 0.2254449
      818  Item1  0.4497985     1 0.5093386
      819  Item1  0.1278239     1 0.4364813
      820  Item1 -1.4820489     1 0.1954771
      821  Item1  0.7717730     0 0.7950139
      822  Item1  0.4497985     0 0.7326843
      823  Item1  0.7717730     0 0.7950139
      824  Item1  1.4157221     0 0.8870283
      825  Item1  1.4157221     0 0.8870283
      826  Item1 -0.1941507     1 0.3698991
      827  Item1 -0.8380998     0 0.4258949
      828  Item1 -1.4820489     1 0.1954771
      829  Item1 -0.5161252     0 0.5025621
      830  Item1  0.1278239     1 0.4364813
      831  Item1 -1.1600743     1 0.2254449
      832  Item1 -1.8040234     0 0.2500383
      833  Item1  0.4497985     1 0.5093386
      834  Item1  0.4497985     1 0.5093386
      835  Item1 -0.5161252     1 0.3120550
      836  Item1 -1.1600743     1 0.2254449
      837  Item1  0.1278239     1 0.4364813
      838  Item1 -1.1600743     0 0.3567994
      839  Item1  1.0937476     0 0.8463985
      840  Item1  0.7717730     1 0.5847767
      841  Item1  0.1278239     0 0.6607947
      842  Item1 -0.8380998     0 0.4258949
      843  Item1  0.4497985     0 0.7326843
      844  Item1 -1.4820489     0 0.2979029
      845  Item1  0.7717730     1 0.5847767
      846  Item1 -0.1941507     1 0.3698991
      847  Item1 -0.8380998     1 0.2639710
      848  Item1 -0.8380998     1 0.2639710
      849  Item1  0.4497985     0 0.7326843
      850  Item1 -1.8040234     1 0.1726988
      851  Item1 -0.5161252     0 0.5025621
      852  Item1 -0.8380998     0 0.4258949
      853  Item1 -0.1941507     0 0.5825445
      854  Item1 -1.8040234     0 0.2500383
      855  Item1 -0.1941507     0 0.5825445
      856  Item1 -0.1941507     1 0.3698991
      857  Item1  0.4497985     1 0.5093386
      858  Item1 -0.1941507     0 0.5825445
      859  Item1  0.4497985     1 0.5093386
      860  Item1  0.4497985     0 0.7326843
      861  Item1  0.4497985     1 0.5093386
      862  Item1  0.4497985     0 0.7326843
      863  Item1  1.0937476     1 0.6585473
      864  Item1  1.7376967     1 0.7866563
      865  Item1  0.1278239     1 0.4364813
      866  Item1  0.7717730     1 0.5847767
      867  Item1  2.0596712     1 0.8368960
      868  Item1  0.4497985     1 0.5093386
      869  Item1 -0.1941507     0 0.5825445
      870  Item1 -0.8380998     1 0.2639710
      871  Item1 -0.1941507     0 0.5825445
      872  Item1  1.4157221     0 0.8870283
      873  Item1  0.1278239     0 0.6607947
      874  Item1 -0.1941507     1 0.3698991
      875  Item1  1.7376967     0 0.9181070
      876  Item1  0.4497985     0 0.7326843
      877  Item1 -0.1941507     0 0.5825445
      878  Item1 -1.1600743     0 0.3567994
      879  Item1  0.1278239     1 0.4364813
      880  Item1  1.0937476     1 0.6585473
      881  Item1 -0.1941507     1 0.3698991
      882  Item1 -1.4820489     1 0.1954771
      883  Item1 -0.5161252     0 0.5025621
      884  Item1  1.4157221     0 0.8870283
      885  Item1 -0.1941507     0 0.5825445
      886  Item1  0.1278239     1 0.4364813
      887  Item1  0.1278239     0 0.6607947
      888  Item1 -0.1941507     0 0.5825445
      889  Item1 -0.1941507     1 0.3698991
      890  Item1  0.7717730     0 0.7950139
      891  Item1 -0.8380998     0 0.4258949
      892  Item1 -1.4820489     1 0.1954771
      893  Item1 -0.8380998     0 0.4258949
      894  Item1  1.0937476     1 0.6585473
      895  Item1  0.7717730     1 0.5847767
      896  Item1  0.1278239     1 0.4364813
      897  Item1 -0.5161252     1 0.3120550
      898  Item1  2.0596712     1 0.8368960
      899  Item1  1.0937476     1 0.6585473
      900  Item1  0.1278239     0 0.6607947
      901  Item1 -0.1941507     0 0.5825445
      902  Item1 -0.5161252     1 0.3120550
      903  Item1  1.7376967     1 0.7866563
      904  Item1 -0.5161252     1 0.3120550
      905  Item1  0.4497985     0 0.7326843
      906  Item1 -0.8380998     1 0.2639710
      907  Item1  0.4497985     0 0.7326843
      908  Item1  0.7717730     1 0.5847767
      909  Item1 -0.5161252     1 0.3120550
      910  Item1  0.7717730     0 0.7950139
      911  Item1  0.1278239     0 0.6607947
      912  Item1 -0.1941507     1 0.3698991
      913  Item1  0.7717730     1 0.5847767
      914  Item1 -0.1941507     0 0.5825445
      915  Item1 -0.1941507     1 0.3698991
      916  Item1  0.7717730     0 0.7950139
      917  Item1 -0.1941507     1 0.3698991
      918  Item1  0.1278239     1 0.4364813
      919  Item1  0.7717730     1 0.5847767
      920  Item1  1.4157221     0 0.8870283
      921  Item1  0.7717730     1 0.5847767
      922  Item1 -1.1600743     0 0.3567994
      923  Item1 -0.8380998     0 0.4258949
      924  Item1 -0.5161252     0 0.5025621
      925  Item1  0.1278239     0 0.6607947
      926  Item1 -1.4820489     1 0.1954771
      927  Item1 -0.1941507     0 0.5825445
      928  Item1  0.7717730     1 0.5847767
      929  Item1 -0.5161252     0 0.5025621
      930  Item1  0.7717730     1 0.5847767
      931  Item1  0.4497985     0 0.7326843
      932  Item1  1.7376967     1 0.7866563
      933  Item1 -0.1941507     0 0.5825445
      934  Item1 -0.8380998     0 0.4258949
      935  Item1 -0.1941507     0 0.5825445
      936  Item1 -0.1941507     1 0.3698991
      937  Item1  0.7717730     1 0.5847767
      938  Item1  1.4157221     1 0.7267631
      939  Item1 -1.4820489     1 0.1954771
      940  Item1  0.4497985     0 0.7326843
      941  Item1  0.4497985     1 0.5093386
      942  Item1 -0.8380998     0 0.4258949
      943  Item1 -0.1941507     1 0.3698991
      944  Item1  1.4157221     0 0.8870283
      945  Item1 -0.5161252     1 0.3120550
      946  Item1  0.7717730     1 0.5847767
      947  Item1 -1.4820489     1 0.1954771
      948  Item1 -1.8040234     0 0.2500383
      949  Item1 -0.1941507     0 0.5825445
      950  Item1 -0.5161252     0 0.5025621
      951  Item1  0.7717730     1 0.5847767
      952  Item1  0.4497985     1 0.5093386
      953  Item1 -0.1941507     1 0.3698991
      954  Item1  1.4157221     0 0.8870283
      955  Item1  0.1278239     0 0.6607947
      956  Item1 -1.4820489     1 0.1954771
      957  Item1 -0.5161252     0 0.5025621
      958  Item1  0.4497985     1 0.5093386
      959  Item1 -1.1600743     1 0.2254449
      960  Item1  1.0937476     0 0.8463985
      961  Item1  1.7376967     1 0.7866563
      962  Item1 -0.8380998     1 0.2639710
      963  Item1 -1.4820489     1 0.1954771
      964  Item1  0.1278239     0 0.6607947
      965  Item1 -1.1600743     1 0.2254449
      966  Item1 -1.1600743     1 0.2254449
      967  Item1  0.1278239     1 0.4364813
      968  Item1  1.0937476     1 0.6585473
      969  Item1  0.1278239     1 0.4364813
      970  Item1 -0.8380998     1 0.2639710
      971  Item1 -0.1941507     1 0.3698991
      972  Item1 -1.8040234     1 0.1726988
      973  Item1 -0.1941507     0 0.5825445
      974  Item1  1.4157221     1 0.7267631
      975  Item1 -0.1941507     1 0.3698991
      976  Item1  0.1278239     0 0.6607947
      977  Item1  1.4157221     1 0.7267631
      978  Item1  1.4157221     1 0.7267631
      979  Item1  0.1278239     0 0.6607947
      980  Item1  0.4497985     0 0.7326843
      981  Item1  1.0937476     1 0.6585473
      982  Item1  1.7376967     0 0.9181070
      983  Item1 -0.1941507     0 0.5825445
      984  Item1  0.7717730     0 0.7950139
      985  Item1 -1.1600743     1 0.2254449
      986  Item1  0.1278239     0 0.6607947
      987  Item1 -0.1941507     0 0.5825445
      988  Item1 -0.8380998     1 0.2639710
      989  Item1  0.4497985     1 0.5093386
      990  Item1  0.7717730     1 0.5847767
      991  Item1 -2.7699471     1 0.1339969
      992  Item1  0.7717730     1 0.5847767
      993  Item1  0.4497985     1 0.5093386
      994  Item1 -0.1941507     1 0.3698991
      995  Item1  0.4497985     0 0.7326843
      996  Item1 -1.1600743     0 0.3567994
      997  Item1  1.7376967     0 0.9181070
      998  Item1 -0.1941507     1 0.3698991
      999  Item1  1.4157221     0 0.8870283
      1000 Item1  0.1278239     0 0.6607947
      1001 Item1 -0.1941507     0 0.5825445
      1002 Item1 -1.1600743     0 0.3567994
      1003 Item1 -1.1600743     1 0.2254449
      1004 Item1 -0.8380998     0 0.4258949
      1005 Item1  0.4497985     0 0.7326843
      1006 Item1 -1.4820489     0 0.2979029
      1007 Item1  2.3816458     0 0.9582384
      1008 Item1  0.1278239     0 0.6607947
      1009 Item1  0.7717730     1 0.5847767
      1010 Item1 -0.5161252     0 0.5025621
      1011 Item1 -1.1600743     1 0.2254449
      1012 Item1  0.1278239     0 0.6607947
      1013 Item1 -2.7699471     0 0.1632496
      1014 Item1  0.1278239     1 0.4364813
      1015 Item1 -0.1941507     0 0.5825445
      1016 Item1 -0.8380998     1 0.2639710
      1017 Item1 -1.8040234     1 0.1726988
      1018 Item1  0.4497985     0 0.7326843
      1019 Item1 -1.1600743     0 0.3567994
      1020 Item1 -0.1941507     0 0.5825445
      1021 Item1  0.4497985     0 0.7326843
      1022 Item1 -0.8380998     0 0.4258949
      1023 Item1  1.7376967     0 0.9181070
      1024 Item1 -0.8380998     0 0.4258949
      1025 Item1  1.0937476     1 0.6585473
      1026 Item1  0.1278239     1 0.4364813
      1027 Item1  0.1278239     0 0.6607947
      1028 Item1 -1.1600743     1 0.2254449
      1029 Item1 -0.5161252     1 0.3120550
      1030 Item1  0.1278239     0 0.6607947
      1031 Item1 -0.8380998     0 0.4258949
      1032 Item1  0.7717730     1 0.5847767
      1033 Item1  0.4497985     1 0.5093386
      1034 Item1 -1.4820489     1 0.1954771
      1035 Item1  1.4157221     1 0.7267631
      1036 Item1 -0.1941507     0 0.5825445
      1037 Item1 -2.1259980     1 0.1556872
      1038 Item1 -0.8380998     0 0.4258949
      1039 Item1  0.4497985     0 0.7326843
      1040 Item1 -2.4479725     0 0.1842596
      1041 Item1  0.1278239     0 0.6607947
      1042 Item1 -0.1941507     1 0.3698991
      1043 Item1 -0.8380998     0 0.4258949
      1044 Item1  1.0937476     1 0.6585473
      1045 Item1  1.0937476     1 0.6585473
      1046 Item1  0.1278239     0 0.6607947
      1047 Item1 -0.5161252     1 0.3120550
      1048 Item1 -1.1600743     0 0.3567994
      1049 Item1 -0.1941507     1 0.3698991
      1050 Item1  0.7717730     0 0.7950139
      1051 Item1 -0.8380998     1 0.2639710
      1052 Item1 -0.5161252     1 0.3120550
      1053 Item1  0.1278239     0 0.6607947
      1054 Item1 -0.8380998     0 0.4258949
      1055 Item1  0.4497985     1 0.5093386
      1056 Item1  0.1278239     1 0.4364813
      1057 Item1 -1.8040234     0 0.2500383
      1058 Item1  0.1278239     1 0.4364813
      1059 Item1 -0.1941507     1 0.3698991
      1060 Item1 -0.1941507     1 0.3698991
      1061 Item1 -1.4820489     0 0.2979029
      1062 Item1 -1.1600743     0 0.3567994
      1063 Item1  0.7717730     1 0.5847767
      1064 Item1 -0.5161252     0 0.5025621
      1065 Item1  0.4497985     0 0.7326843
      1066 Item1  0.4497985     0 0.7326843
      1067 Item1  0.7717730     0 0.7950139
      1068 Item1  1.0937476     0 0.8463985
      1069 Item1 -1.1600743     0 0.3567994
      1070 Item1  0.1278239     0 0.6607947
      1071 Item1  0.1278239     1 0.4364813
      1072 Item1 -0.8380998     0 0.4258949
      1073 Item1  0.1278239     1 0.4364813
      1074 Item1 -2.1259980     1 0.1556872
      1075 Item1  0.7717730     0 0.7950139
      1076 Item1  0.7717730     0 0.7950139
      1077 Item1 -2.4479725     1 0.1431489
      1078 Item1 -1.1600743     1 0.2254449
      1079 Item1 -0.5161252     0 0.5025621
      1080 Item1 -0.8380998     1 0.2639710
      1081 Item1 -0.8380998     0 0.4258949
      1082 Item1 -1.1600743     1 0.2254449
      1083 Item1  2.0596712     0 0.9412824
      1084 Item1 -1.8040234     1 0.1726988
      1085 Item1 -0.5161252     0 0.5025621
      1086 Item1 -0.8380998     1 0.2639710
      1087 Item1 -1.8040234     0 0.2500383
      1088 Item1 -0.5161252     0 0.5025621
      1089 Item1 -2.1259980     0 0.2126244
      1090 Item1 -0.8380998     0 0.4258949
      1091 Item1  0.7717730     1 0.5847767
      1092 Item1  0.7717730     0 0.7950139
      1093 Item1  1.4157221     0 0.8870283
      1094 Item1  0.7717730     0 0.7950139
      1095 Item1  0.1278239     0 0.6607947
      1096 Item1  0.4497985     1 0.5093386
      1097 Item1  0.7717730     1 0.5847767
      1098 Item1 -1.4820489     1 0.1954771
      1099 Item1 -0.5161252     1 0.3120550
      1100 Item1 -0.5161252     1 0.3120550
      1101 Item1  2.0596712     0 0.9412824
      1102 Item1 -1.8040234     0 0.2500383
      1103 Item1  0.4497985     0 0.7326843
      1104 Item1 -0.8380998     1 0.2639710
      1105 Item1  1.4157221     1 0.7267631
      1106 Item1  0.7717730     1 0.5847767
      1107 Item1 -0.5161252     1 0.3120550
      1108 Item1 -0.8380998     0 0.4258949
      1109 Item1  0.4497985     1 0.5093386
      1110 Item1 -0.8380998     0 0.4258949
      1111 Item1  0.7717730     1 0.5847767
      1112 Item1  0.1278239     1 0.4364813
      1113 Item1 -0.1941507     1 0.3698991
      1114 Item1 -1.8040234     0 0.2500383
      1115 Item1  0.4497985     0 0.7326843
      1116 Item1  1.0937476     1 0.6585473
      1117 Item1 -0.5161252     0 0.5025621
      1118 Item1  0.1278239     0 0.6607947
      1119 Item1  0.4497985     1 0.5093386
      1120 Item1  0.7717730     0 0.7950139
      1121 Item1  1.4157221     0 0.8870283
      1122 Item1  0.4497985     0 0.7326843
      1123 Item1 -0.5161252     0 0.5025621
      1124 Item1  0.1278239     0 0.6607947
      1125 Item1 -0.1941507     0 0.5825445
      1126 Item1 -0.1941507     0 0.5825445
      1127 Item1 -1.1600743     0 0.3567994
      1128 Item1 -0.1941507     1 0.3698991
      1129 Item1 -0.8380998     0 0.4258949
      1130 Item1  0.1278239     0 0.6607947
      1131 Item1 -1.8040234     1 0.1726988
      1132 Item1 -0.1941507     1 0.3698991
      1133 Item1  2.0596712     1 0.8368960
      1134 Item1 -0.8380998     0 0.4258949
      1135 Item1  1.4157221     0 0.8870283
      1136 Item1 -0.8380998     0 0.4258949
      1137 Item1 -1.4820489     0 0.2979029
      1138 Item1 -0.5161252     0 0.5025621
      1139 Item1 -1.8040234     0 0.2500383
      1140 Item1 -0.1941507     0 0.5825445
      1141 Item1 -0.1941507     1 0.3698991
      1142 Item1 -1.8040234     1 0.1726988
      1143 Item1 -0.1941507     1 0.3698991
      1144 Item1 -0.1941507     1 0.3698991
      1145 Item1  0.7717730     1 0.5847767
      1146 Item1  0.7717730     1 0.5847767
      1147 Item1  0.7717730     0 0.7950139
      1148 Item1  0.4497985     1 0.5093386
      1149 Item1 -0.1941507     1 0.3698991
      1150 Item1  0.1278239     1 0.4364813
      1151 Item1  0.1278239     0 0.6607947
      1152 Item1 -1.8040234     0 0.2500383
      1153 Item1 -1.8040234     0 0.2500383
      1154 Item1 -1.1600743     1 0.2254449
      1155 Item1  0.7717730     0 0.7950139
      1156 Item1  1.7376967     0 0.9181070
      1157 Item1  1.4157221     0 0.8870283
      1158 Item1  0.1278239     1 0.4364813
      1159 Item1  1.7376967     0 0.9181070
      1160 Item1  0.4497985     0 0.7326843
      1161 Item1 -2.1259980     0 0.2126244
      1162 Item1 -1.1600743     1 0.2254449
      1163 Item1 -0.5161252     0 0.5025621
      1164 Item1  1.4157221     1 0.7267631
      1165 Item1  0.4497985     0 0.7326843
      1166 Item1 -2.1259980     0 0.2126244
      1167 Item1 -0.5161252     0 0.5025621
      1168 Item1 -1.1600743     1 0.2254449
      1169 Item1 -0.5161252     0 0.5025621
      1170 Item1  0.4497985     0 0.7326843
      1171 Item1 -0.8380998     0 0.4258949
      1172 Item1 -0.8380998     0 0.4258949
      1173 Item1 -1.4820489     0 0.2979029
      1174 Item1  2.7036203     1 0.9091805
      1175 Item1  2.0596712     0 0.9412824
      1176 Item1  1.4157221     1 0.7267631
      1177 Item1  0.7717730     0 0.7950139
      1178 Item1  0.4497985     1 0.5093386
      1179 Item1 -2.1259980     1 0.1556872
      1180 Item1 -0.1941507     0 0.5825445
      1181 Item1  0.7717730     0 0.7950139
      1182 Item1 -0.5161252     0 0.5025621
      1183 Item1 -0.5161252     0 0.5025621
      1184 Item1  0.1278239     0 0.6607947
      1185 Item1  0.1278239     1 0.4364813
      1186 Item1 -0.1941507     0 0.5825445
      1187 Item1 -0.5161252     1 0.3120550
      1188 Item1  0.7717730     1 0.5847767
      1189 Item1  0.4497985     1 0.5093386
      1190 Item1 -0.8380998     0 0.4258949
      1191 Item1  0.1278239     0 0.6607947
      1192 Item1  2.3816458     1 0.8774494
      1193 Item1  1.7376967     1 0.7866563
      1194 Item1  0.4497985     1 0.5093386
      1195 Item1  0.7717730     0 0.7950139
      1196 Item1 -0.5161252     1 0.3120550
      1197 Item1  0.7717730     0 0.7950139
      1198 Item1  0.1278239     1 0.4364813
      1199 Item1 -1.8040234     0 0.2500383
      1200 Item1  1.7376967     1 0.7866563
      1201 Item1  1.0937476     1 0.6585473
      1202 Item1  0.7717730     1 0.5847767
      1203 Item1 -1.1600743     0 0.3567994
      1204 Item1  0.1278239     0 0.6607947
      1205 Item1 -0.8380998     0 0.4258949
      1206 Item1  1.4157221     0 0.8870283
      1207 Item1  1.7376967     0 0.9181070
      1208 Item1 -0.8380998     1 0.2639710
      1209 Item1  1.7376967     0 0.9181070
      1210 Item1 -0.5161252     1 0.3120550
      1211 Item1 -0.5161252     1 0.3120550
      1212 Item1  0.1278239     0 0.6607947
      1213 Item1 -0.1941507     1 0.3698991
      1214 Item1  2.0596712     0 0.9412824
      1215 Item1 -0.1941507     1 0.3698991
      1216 Item1  0.1278239     1 0.4364813
      1217 Item1  1.0937476     1 0.6585473
      1218 Item1  1.0937476     1 0.6585473
      1219 Item1  2.0596712     1 0.8368960
      1220 Item1 -1.8040234     1 0.1726988
      1221 Item1  0.4497985     1 0.5093386
      1222 Item1  0.7717730     0 0.7950139
      1223 Item1  0.1278239     1 0.4364813
      1224 Item1 -0.1941507     0 0.5825445
      1225 Item1 -0.5161252     1 0.3120550
      1226 Item1  0.7717730     0 0.7950139
      1227 Item1 -0.1941507     1 0.3698991
      1228 Item1  1.4157221     1 0.7267631
      1229 Item1  0.4497985     0 0.7326843
      1230 Item1  0.1278239     1 0.4364813
      1231 Item1  0.4497985     1 0.5093386
      1232 Item1  0.7717730     0 0.7950139
      1233 Item1  0.4497985     1 0.5093386
      1234 Item1  0.4497985     0 0.7326843
      1235 Item1  1.7376967     0 0.9181070
      1236 Item1 -1.1600743     0 0.3567994
      1237 Item1  0.7717730     0 0.7950139
      1238 Item1 -0.8380998     0 0.4258949
      1239 Item1  0.4497985     0 0.7326843
      1240 Item1 -0.5161252     1 0.3120550
      1241 Item1 -0.1941507     0 0.5825445
      1242 Item1  0.1278239     0 0.6607947
      1243 Item1 -0.1941507     0 0.5825445
      1244 Item1  0.4497985     0 0.7326843
      1245 Item1  1.4157221     1 0.7267631
      1246 Item1 -0.5161252     0 0.5025621
      1247 Item1  1.4157221     1 0.7267631
      1248 Item1 -0.1941507     0 0.5825445
      1249 Item1  2.0596712     0 0.9412824
      1250 Item1 -0.5161252     1 0.3120550
      1251 Item1 -0.5161252     1 0.3120550
      1252 Item1 -0.5161252     1 0.3120550
      1253 Item1  0.1278239     1 0.4364813
      1254 Item1  0.4497985     1 0.5093386
      1255 Item1 -0.1941507     1 0.3698991
      1256 Item1 -1.1600743     1 0.2254449
      1257 Item1  0.4497985     1 0.5093386
      1258 Item1  0.4497985     0 0.7326843
      1259 Item1 -0.5161252     0 0.5025621
      1260 Item1 -0.1941507     0 0.5825445
      1261 Item1  0.4497985     1 0.5093386
      1262 Item1 -1.4820489     1 0.1954771
      1263 Item1 -0.5161252     1 0.3120550
      1264 Item1  0.1278239     0 0.6607947
      1265 Item1 -0.1941507     0 0.5825445
      1266 Item1 -1.8040234     1 0.1726988
      1267 Item1 -0.5161252     0 0.5025621
      1268 Item1  0.1278239     0 0.6607947
      1269 Item1 -0.5161252     0 0.5025621
      1270 Item1 -1.4820489     0 0.2979029
      1271 Item1 -1.4820489     0 0.2979029
      1272 Item1  0.4497985     1 0.5093386
      1273 Item1  1.4157221     1 0.7267631
      1274 Item1 -1.1600743     0 0.3567994
      1275 Item1  1.7376967     1 0.7866563
      1276 Item1  0.4497985     0 0.7326843
      1277 Item1 -0.5161252     1 0.3120550
      1278 Item1  1.0937476     0 0.8463985
      1279 Item1  0.1278239     1 0.4364813
      1280 Item1  1.0937476     1 0.6585473
      1281 Item1 -0.5161252     1 0.3120550
      1282 Item1  1.7376967     0 0.9181070
      1283 Item1 -1.8040234     1 0.1726988
      1284 Item1  0.7717730     1 0.5847767
      1285 Item1  0.7717730     1 0.5847767
      1286 Item1 -1.8040234     0 0.2500383
      1287 Item1 -0.5161252     0 0.5025621
      1288 Item1  2.0596712     0 0.9412824
      1289 Item1 -1.8040234     1 0.1726988
      1290 Item1  0.4497985     1 0.5093386
      1291 Item1  1.0937476     0 0.8463985
      1292 Item1 -1.8040234     1 0.1726988
      1293 Item1  0.7717730     1 0.5847767
      1294 Item1  1.0937476     1 0.6585473
      1295 Item1  0.1278239     0 0.6607947
      1296 Item1  0.1278239     1 0.4364813
      1297 Item1  1.0937476     1 0.6585473
      1298 Item1  1.0937476     0 0.8463985
      1299 Item1 -0.1941507     1 0.3698991
      1300 Item1  0.7717730     1 0.5847767
      1301 Item1  0.7717730     0 0.7950139
      1302 Item1 -1.8040234     1 0.1726988
      1303 Item1  0.7717730     0 0.7950139
      1304 Item1 -0.5161252     1 0.3120550
      1305 Item1  1.7376967     1 0.7866563
      1306 Item1  0.1278239     0 0.6607947
      1307 Item1 -0.8380998     1 0.2639710
      1308 Item1 -0.1941507     0 0.5825445
      1309 Item1 -0.5161252     0 0.5025621
      1310 Item1  1.0937476     0 0.8463985
      1311 Item1  1.0937476     0 0.8463985
      1312 Item1 -0.8380998     0 0.4258949
      1313 Item1 -0.1941507     1 0.3698991
      1314 Item1 -1.1600743     1 0.2254449
      1315 Item1  0.4497985     1 0.5093386
      1316 Item1  0.4497985     0 0.7326843
      1317 Item1  0.7717730     0 0.7950139
      1318 Item1  1.4157221     0 0.8870283
      1319 Item1  1.4157221     1 0.7267631
      1320 Item1  0.1278239     0 0.6607947
      1321 Item1  0.7717730     1 0.5847767
      1322 Item1 -0.1941507     1 0.3698991
      1323 Item1 -0.5161252     0 0.5025621
      1324 Item1  0.7717730     0 0.7950139
      1325 Item1  1.0937476     1 0.6585473
      1326 Item1 -0.8380998     1 0.2639710
      1327 Item1 -0.5161252     1 0.3120550
      1328 Item1  0.4497985     1 0.5093386
      1329 Item1  1.0937476     0 0.8463985
      1330 Item1 -1.4820489     0 0.2979029
      1331 Item1  1.0937476     1 0.6585473
      1332 Item1 -0.5161252     0 0.5025621
      1333 Item1  0.4497985     0 0.7326843
      1334 Item1 -0.1941507     1 0.3698991
      1335 Item1 -0.5161252     0 0.5025621
      1336 Item1  0.7717730     0 0.7950139
      1337 Item1 -0.8380998     1 0.2639710
      1338 Item1 -0.1941507     0 0.5825445
      1339 Item1  0.7717730     0 0.7950139
      1340 Item1 -0.8380998     1 0.2639710
      1341 Item1 -0.5161252     1 0.3120550
      1342 Item1  1.7376967     0 0.9181070
      1343 Item1 -0.1941507     0 0.5825445
      1344 Item1 -1.4820489     0 0.2979029
      1345 Item1 -0.1941507     0 0.5825445
      1346 Item1  0.1278239     1 0.4364813
      1347 Item1 -0.5161252     0 0.5025621
      1348 Item1 -1.1600743     1 0.2254449
      1349 Item1 -0.5161252     1 0.3120550
      1350 Item1  0.4497985     1 0.5093386
      1351 Item1 -0.1941507     1 0.3698991
      1352 Item1 -0.5161252     0 0.5025621
      1353 Item1  1.4157221     0 0.8870283
      1354 Item1  1.7376967     1 0.7866563
      1355 Item1 -1.1600743     0 0.3567994
      1356 Item1  0.7717730     1 0.5847767
      1357 Item1  0.4497985     1 0.5093386
      1358 Item1 -0.1941507     0 0.5825445
      1359 Item1  1.7376967     1 0.7866563
      1360 Item1  1.0937476     0 0.8463985
      1361 Item1 -0.8380998     1 0.2639710
      1362 Item1  0.1278239     0 0.6607947
      1363 Item1 -0.1941507     0 0.5825445
      1364 Item1 -1.1600743     1 0.2254449
      1365 Item1  0.4497985     1 0.5093386
      1366 Item1  0.1278239     0 0.6607947
      1367 Item1  1.7376967     0 0.9181070
      1368 Item1 -0.1941507     1 0.3698991
      1369 Item1  0.1278239     0 0.6607947
      1370 Item1  1.7376967     0 0.9181070
      1371 Item1  1.0937476     1 0.6585473
      1372 Item1  0.1278239     0 0.6607947
      1373 Item1  2.7036203     1 0.9091805
      1374 Item1 -0.5161252     1 0.3120550
      1375 Item1  0.1278239     1 0.4364813
      1376 Item1  0.4497985     1 0.5093386
      1377 Item1  0.7717730     0 0.7950139
      1378 Item1  0.1278239     1 0.4364813
      1379 Item1 -0.1941507     0 0.5825445
      1380 Item1 -0.8380998     0 0.4258949
      1381 Item1 -1.1600743     1 0.2254449
      1382 Item1 -0.5161252     0 0.5025621
      1383 Item1 -0.1941507     0 0.5825445
      1384 Item1 -1.4820489     1 0.1954771
      1385 Item1  0.7717730     0 0.7950139
      1386 Item1 -0.5161252     1 0.3120550
      1387 Item1 -0.1941507     1 0.3698991
      1388 Item1 -1.4820489     1 0.1954771
      1389 Item1 -2.1259980     1 0.1556872
      1390 Item1  0.7717730     0 0.7950139
      1391 Item1  0.4497985     1 0.5093386
      1392 Item1  0.4497985     1 0.5093386
      1393 Item1  0.4497985     0 0.7326843
      1394 Item1  1.7376967     1 0.7866563
      1395 Item1  1.7376967     1 0.7866563
      1396 Item1  0.4497985     0 0.7326843
      1397 Item1 -0.8380998     0 0.4258949
      1398 Item1  0.7717730     1 0.5847767
      1399 Item1  0.1278239     1 0.4364813
      1400 Item1 -2.1259980     0 0.2126244
      1401 Item1  0.7717730     0 0.7950139
      1402 Item1  2.7036203     0 0.9704721
      1403 Item1 -0.8380998     0 0.4258949
      1404 Item1  0.7717730     0 0.7950139
      1405 Item1 -0.1941507     1 0.3698991
      1406 Item1 -0.1941507     1 0.3698991
      1407 Item1  0.1278239     0 0.6607947
      1408 Item1  0.4497985     1 0.5093386
      1409 Item1  2.3816458     1 0.8774494
      1410 Item1  0.7717730     0 0.7950139
      1411 Item1 -1.8040234     0 0.2500383
      1412 Item1 -0.5161252     0 0.5025621
      1413 Item1 -0.8380998     1 0.2639710
      1414 Item1 -1.1600743     0 0.3567994
      1415 Item1 -0.8380998     0 0.4258949
      1416 Item1  1.7376967     0 0.9181070
      1417 Item1  1.0937476     1 0.6585473
      1418 Item1  0.4497985     0 0.7326843
      1419 Item1 -2.1259980     0 0.2126244
      1420 Item1  0.7717730     1 0.5847767
      1421 Item1 -0.5161252     1 0.3120550
      1422 Item1  0.4497985     1 0.5093386
      1423 Item1  0.1278239     1 0.4364813
      1424 Item1  1.0937476     0 0.8463985
      1425 Item1  0.1278239     0 0.6607947
      1426 Item1  0.4497985     0 0.7326843
      1427 Item1  0.1278239     0 0.6607947
      1428 Item1 -1.4820489     0 0.2979029
      1429 Item1 -0.8380998     0 0.4258949
      1430 Item1 -1.4820489     1 0.1954771
      1431 Item1  1.4157221     1 0.7267631
      1432 Item1 -0.5161252     1 0.3120550
      1433 Item1 -0.1941507     0 0.5825445
      1434 Item1 -0.5161252     0 0.5025621
      1435 Item1 -0.8380998     0 0.4258949
      1436 Item1 -1.4820489     1 0.1954771
      1437 Item1  0.4497985     0 0.7326843
      1438 Item1  2.3816458     0 0.9582384
      1439 Item1  0.4497985     0 0.7326843
      1440 Item1 -0.5161252     0 0.5025621
      1441 Item1 -1.4820489     1 0.1954771
      1442 Item1  0.4497985     0 0.7326843
      1443 Item1  0.7717730     1 0.5847767
      1444 Item1 -0.1941507     0 0.5825445
      1445 Item1  1.0937476     0 0.8463985
      1446 Item1 -0.8380998     1 0.2639710
      1447 Item1  1.7376967     1 0.7866563
      1448 Item1 -1.1600743     0 0.3567994
      1449 Item1  0.1278239     0 0.6607947
      1450 Item1  1.4157221     1 0.7267631
      1451 Item1  1.4157221     0 0.8870283
      1452 Item1  0.1278239     1 0.4364813
      1453 Item1 -0.1941507     1 0.3698991
      1454 Item1 -0.8380998     0 0.4258949
      1455 Item1  0.7717730     1 0.5847767
      1456 Item1  1.0937476     1 0.6585473
      1457 Item1  0.4497985     0 0.7326843
      1458 Item1 -0.5161252     1 0.3120550
      1459 Item1  0.4497985     1 0.5093386
      1460 Item1 -1.8040234     0 0.2500383
      1461 Item1 -0.5161252     0 0.5025621
      1462 Item1  0.7717730     1 0.5847767
      1463 Item1 -0.5161252     1 0.3120550
      1464 Item1 -0.8380998     1 0.2639710
      1465 Item1  0.7717730     0 0.7950139
      1466 Item1  0.4497985     1 0.5093386
      1467 Item1  0.4497985     1 0.5093386
      1468 Item1  0.4497985     1 0.5093386
      1469 Item1  0.1278239     0 0.6607947
      1470 Item1 -1.4820489     1 0.1954771
      1471 Item1 -0.5161252     0 0.5025621
      1472 Item1  2.0596712     1 0.8368960
      1473 Item1 -2.1259980     0 0.2126244
      1474 Item1  0.7717730     0 0.7950139
      1475 Item1 -0.1941507     1 0.3698991
      1476 Item1 -1.4820489     0 0.2979029
      1477 Item1  0.4497985     0 0.7326843
      1478 Item1 -2.1259980     1 0.1556872
      1479 Item1  1.0937476     0 0.8463985
      1480 Item1  0.4497985     0 0.7326843
      1481 Item1 -0.1941507     1 0.3698991
      1482 Item1  1.0937476     0 0.8463985
      1483 Item1 -0.1941507     1 0.3698991
      1484 Item1  2.3816458     0 0.9582384
      1485 Item1  0.1278239     1 0.4364813
      1486 Item1  0.4497985     1 0.5093386
      1487 Item1 -1.4820489     0 0.2979029
      1488 Item1  1.4157221     1 0.7267631
      1489 Item1  0.1278239     1 0.4364813
      1490 Item1  0.1278239     0 0.6607947
      1491 Item1  0.1278239     0 0.6607947
      1492 Item1 -0.5161252     1 0.3120550
      1493 Item1  0.4497985     1 0.5093386
      1494 Item1  0.4497985     0 0.7326843
      1495 Item1 -0.1941507     0 0.5825445
      1496 Item1 -0.1941507     1 0.3698991
      1497 Item1  0.1278239     1 0.4364813
      1498 Item1  0.7717730     0 0.7950139
      1499 Item1  0.1278239     0 0.6607947
      1500 Item1 -0.1941507     0 0.5825445
      1501 Item1  0.4497985     0 0.7326843
      1502 Item1  0.4497985     1 0.5093386
      1503 Item1  1.7376967     0 0.9181070
      1504 Item1 -1.4820489     1 0.1954771
      1505 Item1  0.7717730     0 0.7950139
      1506 Item1  0.1278239     0 0.6607947
      1507 Item1 -1.1600743     1 0.2254449
      1508 Item1  0.4497985     1 0.5093386
      1509 Item1 -1.4820489     1 0.1954771
      1510 Item1  0.4497985     1 0.5093386
      1511 Item1 -0.8380998     1 0.2639710
      1512 Item1  0.1278239     1 0.4364813
      1513 Item1 -0.1941507     1 0.3698991
      1514 Item1 -0.8380998     1 0.2639710
      1515 Item1 -0.1941507     0 0.5825445
      1516 Item1 -0.8380998     0 0.4258949
      1517 Item1 -0.1941507     0 0.5825445
      1518 Item1 -0.5161252     0 0.5025621
      1519 Item1 -1.8040234     1 0.1726988
      1520 Item1  0.4497985     0 0.7326843
      1521 Item1  0.1278239     1 0.4364813
      1522 Item1  1.0937476     1 0.6585473
      1523 Item1 -0.5161252     0 0.5025621
      1524 Item1  0.7717730     0 0.7950139
      1525 Item1  0.4497985     1 0.5093386
      1526 Item1  0.1278239     0 0.6607947
      1527 Item1 -1.8040234     0 0.2500383
      1528 Item1  0.1278239     0 0.6607947
      1529 Item1 -0.1941507     0 0.5825445
      1530 Item1  0.1278239     0 0.6607947
      1531 Item1 -0.8380998     0 0.4258949
      1532 Item1  1.7376967     1 0.7866563
      1533 Item1  0.4497985     0 0.7326843
      1534 Item1  0.1278239     1 0.4364813
      1535 Item1 -0.5161252     1 0.3120550
      1536 Item1  2.0596712     0 0.9412824
      1537 Item1 -0.8380998     1 0.2639710
      1538 Item1 -0.5161252     0 0.5025621
      1539 Item1  0.1278239     0 0.6607947
      1540 Item1 -0.1941507     0 0.5825445
      1541 Item1  1.0937476     0 0.8463985
      1542 Item1  0.1278239     0 0.6607947
      1543 Item1 -1.8040234     0 0.2500383
      1544 Item1 -0.1941507     1 0.3698991
      1545 Item1  1.0937476     0 0.8463985
      1546 Item1  1.0937476     0 0.8463985
      1547 Item1 -0.5161252     1 0.3120550
      1548 Item1  0.1278239     0 0.6607947
      1549 Item1  0.1278239     0 0.6607947
      1550 Item1 -1.8040234     1 0.1726988
      1551 Item1 -0.8380998     1 0.2639710
      1552 Item1 -1.1600743     1 0.2254449
      1553 Item1 -1.4820489     0 0.2979029
      1554 Item1 -0.1941507     1 0.3698991
      1555 Item1  0.1278239     1 0.4364813
      1556 Item1 -0.5161252     1 0.3120550
      1557 Item1  0.7717730     1 0.5847767
      1558 Item1 -1.1600743     1 0.2254449
      1559 Item1  1.0937476     1 0.6585473
      1560 Item1 -1.1600743     0 0.3567994
      1561 Item1 -2.4479725     0 0.1842596
      1562 Item1  0.7717730     1 0.5847767
      1563 Item1  2.0596712     0 0.9412824
      1564 Item1  0.7717730     1 0.5847767
      1565 Item1  1.0937476     1 0.6585473
      1566 Item1  0.1278239     0 0.6607947
      1567 Item1 -0.5161252     0 0.5025621
      1568 Item1  2.0596712     0 0.9412824
      1569 Item1 -1.8040234     1 0.1726988
      1570 Item1  0.1278239     1 0.4364813
      1571 Item1  0.7717730     0 0.7950139
      1572 Item1  1.0937476     1 0.6585473
      1573 Item1  0.4497985     0 0.7326843
      1574 Item1  0.1278239     1 0.4364813
      1575 Item1 -0.1941507     1 0.3698991
      1576 Item1  0.7717730     1 0.5847767
      1577 Item1 -0.5161252     1 0.3120550
      1578 Item1  0.7717730     1 0.5847767
      1579 Item1  0.7717730     1 0.5847767
      1580 Item1  1.0937476     0 0.8463985
      1581 Item1 -1.8040234     0 0.2500383
      1582 Item1 -0.1941507     1 0.3698991
      1583 Item1  2.0596712     1 0.8368960
      1584 Item1 -1.8040234     1 0.1726988
      1585 Item1  1.4157221     0 0.8870283
      1586 Item1  1.4157221     1 0.7267631
      1587 Item1  0.7717730     1 0.5847767
      1588 Item1 -1.4820489     0 0.2979029
      1589 Item1 -1.4820489     1 0.1954771
      1590 Item1  0.4497985     0 0.7326843
      1591 Item1  0.4497985     0 0.7326843
      1592 Item1 -1.1600743     0 0.3567994
      1593 Item1  0.7717730     1 0.5847767
      1594 Item1 -0.8380998     1 0.2639710
      1595 Item1  0.7717730     1 0.5847767
      1596 Item1  0.4497985     1 0.5093386
      1597 Item1  0.7717730     0 0.7950139
      1598 Item1 -0.8380998     1 0.2639710
      1599 Item1  0.7717730     0 0.7950139
      1600 Item1  0.4497985     1 0.5093386
      1601 Item1  0.7717730     1 0.5847767
      1602 Item1  2.7036203     0 0.9704721
      1603 Item1 -2.7699471     0 0.1632496
      1604 Item1 -0.1941507     1 0.3698991
      1605 Item1  0.1278239     0 0.6607947
      1606 Item1  0.4497985     0 0.7326843
      1607 Item1 -0.1941507     1 0.3698991
      1608 Item1 -0.1941507     1 0.3698991
      1609 Item1 -1.4820489     0 0.2979029
      1610 Item1  0.4497985     1 0.5093386
      1611 Item1 -0.1941507     0 0.5825445
      1612 Item1 -0.1941507     1 0.3698991
      1613 Item1  0.4497985     0 0.7326843
      1614 Item1 -1.8040234     0 0.2500383
      1615 Item1  1.4157221     0 0.8870283
      1616 Item1 -0.1941507     0 0.5825445
      1617 Item1  0.4497985     1 0.5093386
      1618 Item1 -0.8380998     1 0.2639710
      1619 Item1  0.1278239     1 0.4364813
      1620 Item1 -1.4820489     1 0.1954771
      1621 Item1  0.7717730     1 0.5847767
      1622 Item1  0.7717730     0 0.7950139
      1623 Item1 -0.1941507     0 0.5825445
      1624 Item1  0.4497985     1 0.5093386
      1625 Item1 -1.1600743     0 0.3567994
      1626 Item1 -2.1259980     0 0.2126244
      1627 Item1  0.1278239     0 0.6607947
      1628 Item1  0.4497985     0 0.7326843
      1629 Item1  1.4157221     0 0.8870283
      1630 Item1  0.4497985     0 0.7326843
      1631 Item1 -0.1941507     0 0.5825445
      1632 Item1 -0.8380998     0 0.4258949
      1633 Item1  0.4497985     1 0.5093386
      1634 Item1  0.1278239     0 0.6607947
      1635 Item1 -0.8380998     1 0.2639710
      1636 Item1  0.4497985     0 0.7326843
      1637 Item1  0.4497985     0 0.7326843
      1638 Item1  0.4497985     0 0.7326843
      1639 Item1 -0.5161252     1 0.3120550
      1640 Item1  0.4497985     1 0.5093386
      1641 Item1  1.4157221     0 0.8870283
      1642 Item1  0.1278239     0 0.6607947
      1643 Item1 -0.8380998     0 0.4258949
      1644 Item1  0.1278239     0 0.6607947
      1645 Item1  0.4497985     1 0.5093386
      1646 Item1  0.7717730     0 0.7950139
      1647 Item1 -1.4820489     0 0.2979029
      1648 Item1  0.4497985     0 0.7326843
      1649 Item1 -0.5161252     0 0.5025621
      1650 Item1 -0.5161252     0 0.5025621
      1651 Item1 -0.5161252     1 0.3120550
      1652 Item1  0.7717730     0 0.7950139
      1653 Item1 -0.5161252     1 0.3120550
      1654 Item1  0.4497985     1 0.5093386
      1655 Item1  0.1278239     1 0.4364813
      1656 Item1 -0.1941507     0 0.5825445
      1657 Item1 -0.8380998     1 0.2639710
      1658 Item1  0.1278239     1 0.4364813
      1659 Item1 -1.4820489     1 0.1954771
      1660 Item1  0.7717730     0 0.7950139
      1661 Item1  1.0937476     1 0.6585473
      1662 Item1  0.7717730     0 0.7950139
      1663 Item1  2.0596712     0 0.9412824
      1664 Item1  0.4497985     1 0.5093386
      1665 Item1 -1.4820489     0 0.2979029
      1666 Item1  0.4497985     1 0.5093386
      1667 Item1  0.7717730     1 0.5847767
      1668 Item1  1.0937476     0 0.8463985
      1669 Item1 -2.4479725     1 0.1431489
      1670 Item1  0.1278239     0 0.6607947
      1671 Item1 -0.5161252     1 0.3120550
      1672 Item1 -0.5161252     1 0.3120550
      1673 Item1 -0.5161252     0 0.5025621
      1674 Item1 -2.1259980     0 0.2126244
      1675 Item1 -0.8380998     0 0.4258949
      1676 Item1 -0.5161252     0 0.5025621
      1677 Item1  0.4497985     0 0.7326843
      1678 Item1  0.4497985     1 0.5093386
      1679 Item1  0.4497985     1 0.5093386
      1680 Item1  0.4497985     0 0.7326843
      1681 Item1 -0.8380998     0 0.4258949
      1682 Item1 -1.4820489     0 0.2979029
      1683 Item1 -0.1941507     0 0.5825445
      1684 Item1  0.4497985     0 0.7326843
      1685 Item1 -0.5161252     0 0.5025621
      1686 Item1 -0.8380998     0 0.4258949
      1687 Item1 -0.8380998     1 0.2639710
      1688 Item1 -0.8380998     1 0.2639710
      1689 Item1 -1.1600743     1 0.2254449
      1690 Item1  1.4157221     1 0.7267631
      1691 Item1 -0.1941507     1 0.3698991
      1692 Item1 -0.1941507     0 0.5825445
      1693 Item1 -0.5161252     0 0.5025621
      1694 Item1 -1.8040234     0 0.2500383
      1695 Item1  1.0937476     1 0.6585473
      1696 Item1 -0.5161252     1 0.3120550
      1697 Item1 -0.1941507     1 0.3698991
      1698 Item1  1.0937476     1 0.6585473
      1699 Item1  0.1278239     1 0.4364813
      1700 Item1  0.1278239     1 0.4364813
      1701 Item1 -2.1259980     1 0.1556872
      1702 Item1 -2.4479725     1 0.1431489
      1703 Item1 -0.1941507     0 0.5825445
      1704 Item1 -0.5161252     0 0.5025621
      1705 Item1 -0.1941507     1 0.3698991
      1706 Item1 -0.8380998     1 0.2639710
      1707 Item1  1.4157221     1 0.7267631
      1708 Item1  0.1278239     0 0.6607947
      1709 Item1  1.7376967     0 0.9181070
      1710 Item1 -0.1941507     0 0.5825445
      1711 Item1 -1.4820489     1 0.1954771
      1712 Item1 -1.1600743     0 0.3567994
      1713 Item1 -0.8380998     1 0.2639710
      1714 Item1 -0.1941507     0 0.5825445
      1715 Item1 -0.5161252     1 0.3120550
      1716 Item1  0.1278239     1 0.4364813
      1717 Item1  2.0596712     0 0.9412824
      1718 Item1 -0.5161252     0 0.5025621
      1719 Item1 -1.1600743     1 0.2254449
      1720 Item1 -0.8380998     1 0.2639710
      1721 Item1  0.1278239     0 0.6607947
      1722 Item1 -1.1600743     1 0.2254449
      1723 Item1  0.4497985     0 0.7326843
      1724 Item1 -0.1941507     1 0.3698991
      1725 Item1  0.4497985     1 0.5093386
      1726 Item1  1.0937476     1 0.6585473
      1727 Item1  0.7717730     1 0.5847767
      1728 Item1 -1.1600743     1 0.2254449
      1729 Item1  0.7717730     1 0.5847767
      1730 Item1 -1.4820489     1 0.1954771
      1731 Item1 -0.1941507     1 0.3698991
      1732 Item1  0.1278239     1 0.4364813
      1733 Item1  1.0937476     0 0.8463985
      1734 Item1 -0.1941507     0 0.5825445
      1735 Item1  0.1278239     0 0.6607947
      1736 Item1  0.4497985     1 0.5093386
      1737 Item1 -1.8040234     1 0.1726988
      1738 Item1  1.0937476     1 0.6585473
      1739 Item1 -0.8380998     1 0.2639710
      1740 Item1  0.4497985     1 0.5093386
      1741 Item1  0.7717730     1 0.5847767
      1742 Item1 -1.4820489     0 0.2979029
      1743 Item1  0.1278239     1 0.4364813
      1744 Item1  2.7036203     0 0.9704721
      1745 Item1  0.4497985     1 0.5093386
      1746 Item1 -0.1941507     1 0.3698991
      1747 Item1 -0.8380998     1 0.2639710
      1748 Item1 -0.5161252     1 0.3120550
      1749 Item1  1.0937476     0 0.8463985
      1750 Item1 -1.8040234     1 0.1726988
      1751 Item1 -0.8380998     0 0.4258949
      1752 Item1  0.4497985     0 0.7326843
      1753 Item1 -0.8380998     1 0.2639710
      1754 Item1  2.3816458     0 0.9582384
      1755 Item1 -0.5161252     1 0.3120550
      1756 Item1  1.0937476     1 0.6585473
      1757 Item1 -0.5161252     0 0.5025621
      1758 Item1 -0.8380998     1 0.2639710
      1759 Item1 -0.5161252     1 0.3120550
      1760 Item1  1.4157221     1 0.7267631
      1761 Item1  1.0937476     0 0.8463985
      1762 Item1 -1.8040234     0 0.2500383
      1763 Item1 -0.5161252     1 0.3120550
      1764 Item1 -0.5161252     0 0.5025621
      1765 Item1  0.7717730     1 0.5847767
      1766 Item1  2.3816458     1 0.8774494
      1767 Item1  2.3816458     0 0.9582384
      1768 Item1  0.1278239     0 0.6607947
      1769 Item1  0.4497985     1 0.5093386
      1770 Item1  1.0937476     0 0.8463985
      1771 Item1 -1.1600743     0 0.3567994
      1772 Item1 -1.4820489     0 0.2979029
      1773 Item1  0.7717730     0 0.7950139
      1774 Item1  0.7717730     1 0.5847767
      1775 Item1 -2.4479725     0 0.1842596
      1776 Item1  1.4157221     0 0.8870283
      1777 Item1  0.1278239     0 0.6607947
      1778 Item1  0.1278239     1 0.4364813
      1779 Item1 -1.1600743     1 0.2254449
      1780 Item1 -0.1941507     1 0.3698991
      1781 Item1  1.7376967     1 0.7866563
      1782 Item1 -1.4820489     0 0.2979029
      1783 Item1 -0.8380998     1 0.2639710
      1784 Item1  0.4497985     1 0.5093386
      1785 Item1 -2.1259980     0 0.2126244
      1786 Item1 -1.8040234     1 0.1726988
      1787 Item1 -0.1941507     1 0.3698991
      1788 Item1  1.0937476     1 0.6585473
      1789 Item1  0.7717730     0 0.7950139
      1790 Item1  0.7717730     0 0.7950139
      1791 Item1 -0.8380998     0 0.4258949
      1792 Item1  0.7717730     1 0.5847767
      1793 Item1  0.7717730     0 0.7950139
      1794 Item1  0.7717730     1 0.5847767
      1795 Item1  2.0596712     0 0.9412824
      1796 Item1  1.0937476     1 0.6585473
      1797 Item1 -0.1941507     1 0.3698991
      1798 Item1  0.7717730     0 0.7950139
      1799 Item1  0.7717730     1 0.5847767
      1800 Item1 -0.1941507     0 0.5825445
      1801 Item1 -0.5161252     1 0.3120550
      1802 Item1  0.7717730     1 0.5847767
      1803 Item1  1.7376967     1 0.7866563
      1804 Item1 -0.5161252     1 0.3120550
      1805 Item1 -0.1941507     0 0.5825445
      1806 Item1 -0.1941507     0 0.5825445
      1807 Item1 -1.1600743     0 0.3567994
      1808 Item1 -0.5161252     0 0.5025621
      1809 Item1  0.1278239     1 0.4364813
      1810 Item1 -0.1941507     0 0.5825445
      1811 Item1 -0.8380998     0 0.4258949
      1812 Item1  1.4157221     0 0.8870283
      1813 Item1 -0.5161252     1 0.3120550
      1814 Item1  0.4497985     1 0.5093386
      1815 Item1 -2.1259980     0 0.2126244
      1816 Item1 -0.1941507     1 0.3698991
      1817 Item1  1.0937476     0 0.8463985
      1818 Item1 -1.1600743     1 0.2254449
      1819 Item1  0.1278239     0 0.6607947
      1820 Item1 -1.1600743     1 0.2254449
      1821 Item1 -0.1941507     1 0.3698991
      1822 Item1  1.7376967     0 0.9181070
      1823 Item1  0.1278239     1 0.4364813
      1824 Item1 -0.5161252     1 0.3120550
      1825 Item1 -1.1600743     1 0.2254449
      1826 Item1 -0.8380998     1 0.2639710
      1827 Item1  0.4497985     0 0.7326843
      1828 Item1  1.7376967     1 0.7866563
      1829 Item1 -1.8040234     1 0.1726988
      1830 Item1 -1.8040234     1 0.1726988
      1831 Item1 -0.1941507     0 0.5825445
      1832 Item1  0.4497985     1 0.5093386
      1833 Item1  0.1278239     0 0.6607947
      1834 Item1 -0.1941507     1 0.3698991
      1835 Item1 -1.1600743     1 0.2254449
      1836 Item1 -1.4820489     0 0.2979029
      1837 Item1  0.4497985     1 0.5093386
      1838 Item1 -1.1600743     0 0.3567994
      1839 Item1  0.1278239     1 0.4364813
      1840 Item1  0.4497985     1 0.5093386
      1841 Item1 -0.5161252     0 0.5025621
      1842 Item1  0.4497985     0 0.7326843
      1843 Item1  1.7376967     1 0.7866563
      1844 Item1 -0.1941507     1 0.3698991
      1845 Item1 -0.5161252     0 0.5025621
      1846 Item1  1.7376967     1 0.7866563
      1847 Item1  0.1278239     0 0.6607947
      1848 Item1 -1.8040234     1 0.1726988
      1849 Item1  0.1278239     0 0.6607947
      1850 Item1 -1.4820489     1 0.1954771
      1851 Item1 -0.5161252     0 0.5025621
      1852 Item1 -0.8380998     1 0.2639710
      1853 Item1 -0.8380998     1 0.2639710
      1854 Item1  0.1278239     0 0.6607947
      1855 Item1  0.7717730     1 0.5847767
      1856 Item1  1.0937476     0 0.8463985
      1857 Item1 -1.1600743     1 0.2254449
      1858 Item1 -0.5161252     1 0.3120550
      1859 Item1 -0.1941507     0 0.5825445
      1860 Item1  0.1278239     1 0.4364813
      1861 Item1  0.1278239     1 0.4364813
      1862 Item1 -1.1600743     0 0.3567994
      1863 Item1 -2.1259980     0 0.2126244
      1864 Item1 -1.1600743     1 0.2254449
      1865 Item1 -0.5161252     1 0.3120550
      1866 Item1  0.7717730     0 0.7950139
      1867 Item1  0.7717730     0 0.7950139
      1868 Item1  0.1278239     1 0.4364813
      1869 Item1 -0.8380998     1 0.2639710
      1870 Item1  0.7717730     1 0.5847767
      1871 Item1  1.0937476     1 0.6585473
      1872 Item1 -0.1941507     0 0.5825445
      1873 Item1  1.0937476     0 0.8463985
      1874 Item1  0.1278239     0 0.6607947
      1875 Item1  1.0937476     1 0.6585473
      1876 Item1 -0.1941507     1 0.3698991
      1877 Item1 -1.1600743     0 0.3567994
      1878 Item1  1.0937476     1 0.6585473
      1879 Item1  0.1278239     0 0.6607947
      1880 Item1  0.7717730     0 0.7950139
      1881 Item1  1.4157221     0 0.8870283
      1882 Item1 -0.1941507     0 0.5825445
      1883 Item1 -0.1941507     1 0.3698991
      1884 Item1 -1.4820489     0 0.2979029
      1885 Item1  1.4157221     1 0.7267631
      1886 Item1  1.0937476     1 0.6585473
      1887 Item1  0.4497985     0 0.7326843
      1888 Item1  0.1278239     1 0.4364813
      1889 Item1  1.0937476     1 0.6585473
      1890 Item1 -0.8380998     0 0.4258949
      1891 Item1 -1.8040234     1 0.1726988
      1892 Item1 -0.5161252     0 0.5025621
      1893 Item1 -1.4820489     1 0.1954771
      1894 Item1  0.4497985     1 0.5093386
      1895 Item1 -0.8380998     0 0.4258949
      1896 Item1 -0.5161252     0 0.5025621
      1897 Item1 -0.1941507     0 0.5825445
      1898 Item1 -0.1941507     0 0.5825445
      1899 Item1  1.0937476     0 0.8463985
      1900 Item1 -0.1941507     0 0.5825445
      1901 Item1  0.1278239     1 0.4364813
      1902 Item1  0.7717730     1 0.5847767
      1903 Item1  0.1278239     0 0.6607947
      1904 Item1 -0.5161252     1 0.3120550
      1905 Item1  0.4497985     0 0.7326843
      1906 Item1  1.4157221     1 0.7267631
      1907 Item1 -1.4820489     0 0.2979029
      1908 Item1  0.4497985     0 0.7326843
      1909 Item1  0.4497985     0 0.7326843
      1910 Item1 -0.5161252     1 0.3120550
      1911 Item1  0.4497985     0 0.7326843
      1912 Item1  0.1278239     0 0.6607947
      1913 Item1 -0.5161252     1 0.3120550
      1914 Item1  1.0937476     0 0.8463985
      1915 Item1 -0.1941507     1 0.3698991
      1916 Item1 -0.5161252     0 0.5025621
      1917 Item1  1.4157221     1 0.7267631
      1918 Item1  0.7717730     0 0.7950139
      1919 Item1 -0.5161252     1 0.3120550
      1920 Item1  0.4497985     0 0.7326843
      1921 Item1 -0.1941507     1 0.3698991
      1922 Item1 -0.1941507     1 0.3698991
      1923 Item1 -1.4820489     1 0.1954771
      1924 Item1 -1.8040234     1 0.1726988
      1925 Item1  1.7376967     0 0.9181070
      1926 Item1 -0.8380998     1 0.2639710
      1927 Item1 -0.1941507     0 0.5825445
      1928 Item1 -1.1600743     0 0.3567994
      1929 Item1  1.0937476     1 0.6585473
      1930 Item1 -0.8380998     0 0.4258949
      1931 Item1 -1.8040234     0 0.2500383
      1932 Item1  0.4497985     1 0.5093386
      1933 Item1  0.1278239     0 0.6607947
      1934 Item1 -0.8380998     1 0.2639710
      1935 Item1 -0.5161252     0 0.5025621
      1936 Item1  0.4497985     1 0.5093386
      1937 Item1  1.0937476     0 0.8463985
      1938 Item1 -0.8380998     1 0.2639710
      1939 Item1 -1.8040234     0 0.2500383
      1940 Item1 -0.1941507     0 0.5825445
      1941 Item1  0.1278239     1 0.4364813
      1942 Item1  0.4497985     1 0.5093386
      1943 Item1  0.1278239     0 0.6607947
      1944 Item1 -1.1600743     1 0.2254449
      1945 Item1  0.1278239     1 0.4364813
      1946 Item1  1.4157221     0 0.8870283
      1947 Item1  0.7717730     1 0.5847767
      1948 Item1  0.4497985     0 0.7326843
      1949 Item1  0.4497985     0 0.7326843
      1950 Item1 -0.5161252     1 0.3120550
      1951 Item1  1.0937476     1 0.6585473
      1952 Item1  2.7036203     1 0.9091805
      1953 Item1 -1.4820489     0 0.2979029
      1954 Item1  1.4157221     1 0.7267631
      1955 Item1 -0.5161252     0 0.5025621
      1956 Item1 -0.8380998     0 0.4258949
      1957 Item1  0.1278239     0 0.6607947
      1958 Item1 -0.5161252     1 0.3120550
      1959 Item1  0.4497985     0 0.7326843
      1960 Item1  0.4497985     0 0.7326843
      1961 Item1 -1.1600743     0 0.3567994
      1962 Item1  1.0937476     0 0.8463985
      1963 Item1  0.4497985     1 0.5093386
      1964 Item1  0.7717730     1 0.5847767
      1965 Item1 -0.1941507     0 0.5825445
      1966 Item1 -1.1600743     0 0.3567994
      1967 Item1  1.0937476     1 0.6585473
      1968 Item1  1.4157221     1 0.7267631
      1969 Item1  0.1278239     1 0.4364813
      1970 Item1  1.0937476     0 0.8463985
      1971 Item1  0.7717730     1 0.5847767
      1972 Item1 -0.1941507     0 0.5825445
      1973 Item1 -0.1941507     0 0.5825445
      1974 Item1 -1.4820489     1 0.1954771
      1975 Item1 -0.1941507     0 0.5825445
      1976 Item1  0.4497985     0 0.7326843
      1977 Item1 -0.5161252     0 0.5025621
      1978 Item1 -0.8380998     0 0.4258949
      1979 Item1 -0.5161252     1 0.3120550
      1980 Item1 -2.1259980     1 0.1556872
      1981 Item1 -1.1600743     0 0.3567994
      1982 Item1  0.1278239     0 0.6607947
      1983 Item1  0.4497985     1 0.5093386
      1984 Item1 -1.1600743     0 0.3567994
      1985 Item1 -0.8380998     1 0.2639710
      1986 Item1 -1.1600743     0 0.3567994
      1987 Item1  0.1278239     1 0.4364813
      1988 Item1  0.4497985     0 0.7326843
      1989 Item1 -1.4820489     0 0.2979029
      1990 Item1  2.0596712     1 0.8368960
      1991 Item1 -0.5161252     1 0.3120550
      1992 Item1  0.1278239     0 0.6607947
      1993 Item1 -1.4820489     0 0.2979029
      1994 Item1  0.4497985     0 0.7326843
      1995 Item1  2.0596712     1 0.8368960
      1996 Item1  0.4497985     1 0.5093386
      1997 Item1  0.1278239     1 0.4364813
      1998 Item1  0.4497985     0 0.7326843
      1999 Item1  0.4497985     0 0.7326843
      2000 Item1  1.4157221     1 0.7267631

---

    Code
      predict(fit1, item = 1, match = 0, group = c(0, 1))
    Output
         item match group      prob
      1 Item1     0     0 0.6302562
      2 Item1     0     1 0.4091277

---

    Code
      AIC(fit1)
    Output
       [1] 2515.030 2549.043 2342.008 2013.198 1670.650 2455.279 2518.547 2598.912
       [9] 2693.296 2695.274 2371.996 2694.215 2221.522 2624.144 2737.446 2527.643
      [17] 2738.945 2484.224 2607.867 2613.890

---

    Code
      BIC(fit1)
    Output
       [1] 2543.035 2577.048 2358.811 2030.000 1687.453 2472.082 2546.552 2615.714
       [9] 2710.099 2712.076 2388.799 2711.018 2238.325 2640.947 2754.248 2544.446
      [17] 2755.748 2501.027 2635.871 2630.693

---

    Code
      logLik(fit1)
    Output
       [1] -1252.515 -1269.522 -1168.004 -1003.599  -832.325 -1224.639 -1254.274
       [8] -1296.456 -1343.648 -1344.637 -1182.998 -1344.108 -1107.761 -1309.072
      [15] -1365.723 -1260.821 -1366.473 -1239.112 -1298.933 -1303.945

---

    Code
      AIC(fit1, item = 1)
    Output
      [1] 2515.03

---

    Code
      BIC(fit1, item = 1)
    Output
      [1] 2543.035

---

    Code
      logLik(fit1, item = 1)
    Output
      'log Lik.' -1252.515 (df=5)

---

    Code
      (fit2 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", test = "W"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression Wald test statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  41.9145      0.0000 ***
      Item2  14.7397      0.0006 ***
      Item3   0.6903      0.7081    
      Item4   2.8622      0.2390    
      Item5   1.0890      0.5801    
      Item6   0.1547      0.9256    
      Item7   5.6898      0.0581 .  
      Item8   2.4127      0.2993    
      Item9   0.4219      0.8098    
      Item10  1.1699      0.5571    
      Item11  1.2022      0.5482    
      Item12  1.0143      0.6022    
      Item13  3.8549      0.1455    
      Item14  1.4149      0.4929    
      Item15  1.1084      0.5745    
      Item16  0.1394      0.9327    
      Item17  2.5649      0.2774    
      Item18  1.9413      0.3788    
      Item19  4.8067      0.0904 .  
      Item20  3.1155      0.2106    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2

---

    Code
      (fit3 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", test = "F"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression F-test statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             F-value P-value    
      Item1  41.7833  0.0000 ***
      Item2  14.2267  0.0000 ***
      Item3   0.3414  0.7108    
      Item4   1.6500  0.1923    
      Item5   0.5979  0.5501    
      Item6   0.0784  0.9246    
      Item7   4.1498  0.0159 *  
      Item8   1.4304  0.2395    
      Item9   0.2269  0.7970    
      Item10  0.6739  0.5098    
      Item11  0.6202  0.5379    
      Item12  0.5257  0.5912    
      Item13  2.2039  0.1106    
      Item14  0.7454  0.4747    
      Item15  0.6525  0.5208    
      Item16  0.0710  0.9314    
      Item17  1.5809  0.2060    
      Item18  1.0083  0.3650    
      Item19  3.1244  0.0442 *  
      Item20  1.7407  0.1757    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 3.0002 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7
       Item19

---

    Code
      (fit4 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", sandwich = TRUE))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  82.0689      0.0000 ***
      Item2  28.3232      0.0000 ***
      Item3   0.6845      0.7102    
      Item4   3.3055      0.1915    
      Item5   1.1984      0.5492    
      Item6   0.1573      0.9244    
      Item7   8.3032      0.0157 *  
      Item8   2.8660      0.2386    
      Item9   0.4549      0.7966    
      Item10  1.3507      0.5090    
      Item11  1.2431      0.5371    
      Item12  1.0537      0.5905    
      Item13  4.4139      0.1100    
      Item14  1.4940      0.4738    
      Item15  1.3079      0.5200    
      Item16  0.1424      0.9313    
      Item17  3.1673      0.2052    
      Item18  2.0206      0.3641    
      Item19  6.2546      0.0438 *  
      Item20  3.4871      0.1749    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7
       Item19

---

    Code
      (fit5 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", p.adjust.method = "BH")
      )
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      Multiple comparisons made with Benjamini-Hochberg adjustment of p-values
      
             Chisq-value P-value Adj. P-value    
      Item1  82.0689      0.0000  0.0000      ***
      Item2  28.3232      0.0000  0.0000      ***
      Item3   0.6845      0.7102  0.8355         
      Item4   3.3055      0.1915  0.5131         
      Item5   1.1984      0.5492  0.7323         
      Item6   0.1573      0.9244  0.9313         
      Item7   8.3032      0.0157  0.1049         
      Item8   2.8660      0.2386  0.5302         
      Item9   0.4549      0.7966  0.8851         
      Item10  1.3507      0.5090  0.7323         
      Item11  1.2431      0.5371  0.7323         
      Item12  1.0537      0.5905  0.7381         
      Item13  4.4139      0.1100  0.4401         
      Item14  1.4940      0.4738  0.7323         
      Item15  1.3079      0.5200  0.7323         
      Item16  0.1424      0.9313  0.9313         
      Item17  3.1673      0.2052  0.5131         
      Item18  2.0206      0.3641  0.7282         
      Item19  6.2546      0.0438  0.2192         
      Item20  3.4871      0.1749  0.5131         
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2

---

    Code
      (fit6 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", purify = TRUE))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was applied with 2 iterations.
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  78.1279      0.0000 ***
      Item2  27.7354      0.0000 ***
      Item3   0.0027      0.9986    
      Item4   2.0028      0.3674    
      Item5   1.8701      0.3926    
      Item6   1.1317      0.5679    
      Item7   4.2269      0.1208    
      Item8   3.8019      0.1494    
      Item9   0.2162      0.8975    
      Item10  0.3917      0.8221    
      Item11  3.1631      0.2057    
      Item12  0.2259      0.8932    
      Item13  2.4394      0.2953    
      Item14  0.4483      0.7992    
      Item15  0.4197      0.8107    
      Item16  1.0382      0.5950    
      Item17  1.4373      0.4874    
      Item18  0.1553      0.9253    
      Item19  3.1764      0.2043    
      Item20  5.3659      0.0684 .  
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2

---

    Code
      (fit7 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", match = "score"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  82.0689      0.0000 ***
      Item2  28.3232      0.0000 ***
      Item3   0.6845      0.7102    
      Item4   3.3055      0.1915    
      Item5   1.1984      0.5492    
      Item6   0.1573      0.9244    
      Item7   8.3032      0.0157 *  
      Item8   2.8660      0.2386    
      Item9   0.4549      0.7966    
      Item10  1.3507      0.5090    
      Item11  1.2431      0.5371    
      Item12  1.0537      0.5905    
      Item13  4.4139      0.1100    
      Item14  1.4940      0.4738    
      Item15  1.3079      0.5200    
      Item16  0.1424      0.9313    
      Item17  3.1673      0.2052    
      Item18  2.0206      0.3641    
      Item19  6.2546      0.0438 *  
      Item20  3.4871      0.1749    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7
       Item19

---

    Code
      (fit8 <- difNLR(Data, group, focal.name = 1, model = "4PLcgdg", type = "udif"))
    Output
      Detection of uniform differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model with fixed guessing and inattention parameter for groups 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  81.9549      0.0000 ***
      Item2  14.5542      0.0001 ***
      Item3   0.3153      0.5745    
      Item4   2.4851      0.1149    
      Item5   0.0007      0.9793    
      Item6   0.0716      0.7890    
      Item7   7.9741      0.0047 ** 
      Item8   0.1516      0.6970    
      Item9   0.0948      0.7582    
      Item10  0.9293      0.3350    
      Item11  0.3832      0.5359    
      Item12  0.5839      0.4448    
      Item13  2.0124      0.1560    
      Item14  1.1316      0.2874    
      Item15  0.8492      0.3568    
      Item16  0.0204      0.8864    
      Item17  2.8934      0.0889 .  
      Item18  1.7608      0.1845    
      Item19  2.1632      0.1414    
      Item20  1.6239      0.2025    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 3.8415 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7

---

    Code
      (fit9 <- difNLR(Data, group, focal.name = 1, model = "2PL", type = "nudif"))
    Output
      Detection of non-uniform differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 2PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1   1.4694      0.2254    
      Item2  12.8761      0.0003 ***
      Item3   0.2241      0.6359    
      Item4   0.8464      0.3576    
      Item5   1.7056      0.1916    
      Item6   0.0902      0.7639    
      Item7   0.3291      0.5662    
      Item8   2.7878      0.0950 .  
      Item9   0.3482      0.5551    
      Item10  0.4159      0.5190    
      Item11  0.8829      0.3474    
      Item12  1.1279      0.2882    
      Item13  4.2949      0.0382 *  
      Item14  0.4103      0.5218    
      Item15  0.4587      0.4982    
      Item16  0.2215      0.6379    
      Item17  0.1550      0.6938    
      Item18  0.1909      0.6622    
      Item19  3.6780      0.0551 .  
      Item20  1.0065      0.3157    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 3.8415 (significance level: 0.05)
      
      Items detected as DIF items:
       Item2
       Item13

---

    Code
      (fit10 <- difNLR(Data, group, focal.name = 1, model = "4PL", constraints = "ac",
        type = "b"))
    Output
      Detection of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model  with constraints on parameters a, c 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  17.3612      0.0000 ***
      Item2  17.5307      0.0000 ***
      Item3   0.0337      0.8543    
      Item4   0.0239      0.8771    
      Item5   0.0007      0.9793    
      Item6   0.0507      0.8218    
      Item7   3.3095      0.0689 .  
      Item8   1.3556      0.2443    
      Item9   0.1936      0.6599    
      Item10  0.4760      0.4902    
      Item11  0.0073      0.9319    
      Item12  0.2910      0.5896    
      Item13  0.1490      0.6995    
      Item14  0.4523      0.5012    
      Item15  0.5203      0.4707    
      Item16  0.0204      0.8864    
      Item17  1.0202      0.3125    
      Item18  1.3394      0.2471    
      Item19  4.8954      0.0269 *  
      Item20  1.0550      0.3044    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 3.8415 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item19

---

    Code
      (fit11 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", method = "mle"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using maximum likelihood method 
      with the L-BFGS-B algorithm
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  74.3235      0.0000 ***
      Item2  27.1120      0.0000 ***
      Item3   0.7401      0.6907    
      Item4   3.4097      0.1818    
      Item5   0.1188      0.9423    
      Item6   0.0989      0.9517    
      Item7   7.2097      0.0272 *  
      Item8   5.5471      0.0624 .  
      Item9   0.4107      0.8144    
      Item10  1.2497      0.5353    
      Item11  0.9490      0.6222    
      Item12  0.6327      0.7288    
      Item13  2.5885      0.2741    
      Item14  1.8876      0.3891    
      Item15  1.4200      0.4916    
      Item16  0.5303      0.7671    
      Item17  3.1490      0.2071    
      Item18  1.3752      0.5028    
      Item19  5.6279      0.0600 .  
      Item20  3.1076      0.2114    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7

---

    Code
      (fit13 <- difNLR(Data, group, focal.name = 1, model = "3PLcg", method = "plf"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 3PL model with fixed guessing for groups 
      
      Parameters were estimated using maximum likelihood method 
      with the PLF algorithm
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  73.5354      0.0000 ***
      Item2  27.6368      0.0000 ***
      Item3   0.7401      0.6907    
      Item4   3.4110      0.1817    
      Item5   0.6804      0.7116    
      Item6   0.1073      0.9478    
      Item7   7.2092      0.0272 *  
      Item8   4.9733      0.0832 .  
      Item9   0.4276      0.8075    
      Item10  1.3559      0.5076    
      Item11  1.0097      0.6036    
      Item12  1.0773      0.5835    
      Item13  3.2177      0.2001    
      Item14  2.3594      0.3074    
      Item15  1.4200      0.4916    
      Item16  0.8646      0.6490    
      Item17  3.1339      0.2087    
      Item18  1.3752      0.5028    
      Item19  5.0306      0.0808 .  
      Item20  3.7682      0.1520    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7

---

    Code
      (fit14 <- difNLR(Data, group, focal.name = 1, model = "2PL", method = "irls"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 2PL model 
      
      Parameters were estimated using maximum likelihood method 
      with the iteratively reweighted least squares algorithm
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1  73.5146      0.0000 ***
      Item2  27.5609      0.0000 ***
      Item3   0.7401      0.6907    
      Item4   3.4110      0.1817    
      Item5   0.6860      0.7096    
      Item6   0.1072      0.9478    
      Item7   7.2092      0.0272 *  
      Item8   4.9704      0.0833 .  
      Item9   0.4278      0.8074    
      Item10  1.3567      0.5075    
      Item11  1.0111      0.6032    
      Item12  1.0835      0.5817    
      Item13  3.2220      0.1997    
      Item14  2.3760      0.3048    
      Item15  1.4200      0.4916    
      Item16  0.8831      0.6430    
      Item17  3.1335      0.2087    
      Item18  1.3752      0.5028    
      Item19  5.0045      0.0819 .  
      Item20  3.7580      0.1527    
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 5.9915 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item7

# testing paper code - R Journal 2020 - generated data

    Code
      head(df[, c(1:5, 16)])
    Output
        Item1 Item2 Item3 Item4 Item5 group
      1     0     1     1     1     1     0
      2     0     1     1     0     1     0
      3     0     1     0     0     1     0
      4     1     1     1     0     1     0
      5     1     1     0     1     1     0
      6     0     1     0     0     1     0

---

    Code
      (fit1 <- difNLR(DataDIF, groupDIF, focal.name = 1, model = "4PL", type = "all"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1   6.2044      0.1844    
      Item2   0.2802      0.9911    
      Item3   2.7038      0.6086    
      Item4   5.8271      0.2124    
      Item5  48.0052      0.0000 ***
      Item6   7.2060      0.1254    
      Item7   3.2390      0.5187    
      Item8  16.8991      0.0020 ** 
      Item9   2.1595      0.7064    
      Item10  4.6866      0.3210    
      Item11 69.5328      0.0000 ***
      Item12  8.1931      0.0848 .  
      Item13  2.5850      0.6295    
      Item14  2.9478      0.5666    
      Item15 20.6589      0.0004 ***
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 9.4877 (significance level: 0.05)
      
      Items detected as DIF items:
       Item5
       Item8
       Item11
       Item15

---

    Code
      round(coef(fit1, simplify = TRUE), 3)
    Output
                           a      b      c     d   aDif   bDif   cDif   dDif
      Item1 estimate   1.484  1.294  0.049 1.000  0.000  0.000  0.000  0.000
      Item1 CI2.5      0.730  0.726 -0.022 0.633  0.000  0.000  0.000  0.000
      Item1 CI97.5     2.237  1.861  0.119 1.367  0.000  0.000  0.000  0.000
      Item2 estimate   1.176  0.153  0.000 1.000  0.000  0.000  0.000  0.000
      Item2 CI2.5      0.417 -0.279 -0.242 0.751  0.000  0.000  0.000  0.000
      Item2 CI97.5     1.936  0.584  0.242 1.249  0.000  0.000  0.000  0.000
      Item3 estimate   1.281  1.766  0.001 1.000  0.000  0.000  0.000  0.000
      Item3 CI2.5      0.548  0.773 -0.063 0.381  0.000  0.000  0.000  0.000
      Item3 CI97.5     2.014  2.758  0.065 1.619  0.000  0.000  0.000  0.000
      Item4 estimate   1.450  0.421  0.000 1.000  0.000  0.000  0.000  0.000
      Item4 CI2.5      0.785  0.122 -0.128 0.802  0.000  0.000  0.000  0.000
      Item4 CI97.5     2.115  0.719  0.128 1.198  0.000  0.000  0.000  0.000
      Item5 estimate   1.965 -1.147  0.000 0.868 -0.408  0.769  0.023 -0.006
      Item5 CI2.5      0.310 -1.939 -0.602 0.780 -2.455 -0.177 -0.654 -0.188
      Item5 CI97.5     3.619 -0.356  0.602 0.955  1.640  1.715  0.699  0.177
      Item6 estimate   1.458 -0.527  0.000 0.954  0.000  0.000  0.000  0.000
      Item6 CI2.5      0.670 -0.953 -0.288 0.837  0.000  0.000  0.000  0.000
      Item6 CI97.5     2.246 -0.101  0.288 1.071  0.000  0.000  0.000  0.000
      Item7 estimate   0.888  1.392  0.000 1.000  0.000  0.000  0.000  0.000
      Item7 CI2.5     -0.076 -0.526 -0.209 0.059  0.000  0.000  0.000  0.000
      Item7 CI97.5     1.852  3.311  0.209 1.941  0.000  0.000  0.000  0.000
      Item8 estimate   1.162  1.407  0.000 0.866 -0.117  0.974  0.007  0.134
      Item8 CI2.5     -0.004 -0.078 -0.139 0.109 -1.975 -3.428 -0.173 -2.270
      Item8 CI97.5     2.329  2.892  0.139 1.622  1.741  5.375  0.186  2.539
      Item9 estimate   1.482 -1.337  0.000 0.928  0.000  0.000  0.000  0.000
      Item9 CI2.5      0.426 -2.385 -0.705 0.850  0.000  0.000  0.000  0.000
      Item9 CI97.5     2.538 -0.290  0.705 1.005  0.000  0.000  0.000  0.000
      Item10 estimate  1.375 -0.570  0.007 0.967  0.000  0.000  0.000  0.000
      Item10 CI2.5     0.572 -1.070 -0.323 0.841  0.000  0.000  0.000  0.000
      Item10 CI97.5    2.178 -0.069  0.338 1.093  0.000  0.000  0.000  0.000
      Item11 estimate  1.071 -1.027  0.000 0.969  1.173 -0.499  0.000  0.011
      Item11 CI2.5    -0.199 -2.862 -1.022 0.763 -0.948 -2.500 -1.293 -0.204
      Item11 CI97.5    2.341  0.808  1.022 1.175  3.294  1.502  1.293  0.225
      Item12 estimate  1.051  1.560  0.080 1.000  0.000  0.000  0.000  0.000
      Item12 CI2.5     0.035 -0.162 -0.056 0.141  0.000  0.000  0.000  0.000
      Item12 CI97.5    2.066  3.283  0.215 1.859  0.000  0.000  0.000  0.000
      Item13 estimate  1.009  1.348  0.084 1.000  0.000  0.000  0.000  0.000
      Item13 CI2.5    -0.013 -0.253 -0.084 0.217  0.000  0.000  0.000  0.000
      Item13 CI97.5    2.030  2.949  0.253 1.783  0.000  0.000  0.000  0.000
      Item14 estimate  1.093  1.659  0.141 1.000  0.000  0.000  0.000  0.000
      Item14 CI2.5    -0.065 -0.300  0.016 0.064  0.000  0.000  0.000  0.000
      Item14 CI97.5    2.252  3.618  0.266 1.936  0.000  0.000  0.000  0.000
      Item15 estimate  0.875 -0.565  0.000 0.945  0.205  0.348  0.000 -0.142
      Item15 CI2.5    -0.789 -2.871 -1.192 0.460 -2.042 -2.203 -1.312 -0.739
      Item15 CI97.5    2.539  1.740  1.192 1.429  2.452  2.900  1.312  0.454

---

    Code
      round(coef(fit1, SE = TRUE)[[5]], 3)
    Output
                   a      b   aDif   bDif      c   cDif     d   dDif
      estimate 1.965 -1.147 -0.408  0.769  0.000  0.023 0.868 -0.006
      SE       0.844  0.404  1.045  0.483  0.307  0.345 0.044  0.093
      CI2.5    0.310 -1.939 -2.455 -0.177 -0.602 -0.654 0.780 -0.188
      CI97.5   3.619 -0.356  1.640  1.715  0.602  0.699 0.955  0.177

---

    Code
      (fit2 <- difNLR(DataDIF, groupDIF, focal.name = 1, model = model, type = "all"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1   3.7724      0.0521 .  
      Item2   0.2487      0.8831    
      Item3   2.0373      0.3611    
      Item4   5.8151      0.1210    
      Item5  46.2121      0.0000 ***
      Item6   6.9990      0.0719 .  
      Item7   3.2390      0.3562    
      Item8  16.8991      0.0020 ** 
      Item9   2.1595      0.7064    
      Item10  4.6866      0.3210    
      Item11 69.5328      0.0000 ***
      Item12  8.1931      0.0848 .  
      Item13  2.5850      0.6295    
      Item14  2.9478      0.5666    
      Item15 20.6589      0.0004 ***
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      
      Items detected as DIF items:
       Item5
       Item8
       Item11
       Item15

---

    Code
      (fit3 <- difNLR(DataDIF, groupDIF, focal.name = 1, model = model, type = type))
    Output
      Detection of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value   
      Item1   3.7724      0.0521 . 
      Item2   0.2487      0.8831   
      Item3   2.0373      0.3611   
      Item4   5.8151      0.1210   
      Item5  10.0923      0.0015 **
      Item6   6.9990      0.0719 . 
      Item7   3.2390      0.3562   
      Item8   0.0681      0.7941   
      Item9   2.1595      0.7064   
      Item10  4.6866      0.3210   
      Item11  0.0000      1.0000   
      Item12  8.1931      0.0848 . 
      Item13  2.5850      0.6295   
      Item14  2.9478      0.5666   
      Item15  0.3552      0.5512   
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      
      Items detected as DIF items:
       Item5

---

    Code
      (fit4 <- difNLR(DataDIF, groupDIF, focal.name = 1, model = model, constraints = constraints,
        type = type))
    Output
      Detection of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1   3.7724      0.0521 .  
      Item2   0.2487      0.8831    
      Item3   2.0373      0.3611    
      Item4   5.8151      0.1210    
      Item5  46.1905      0.0000 ***
      Item6   6.9990      0.0719 .  
      Item7   3.2390      0.3562    
      Item8  11.6006      0.0007 ***
      Item9   2.1595      0.7064    
      Item10  4.6866      0.3210    
      Item11 35.2213      0.0000 ***
      Item12  8.1931      0.0848 .  
      Item13  2.5850      0.6295    
      Item14  2.9478      0.5666    
      Item15 17.7716      0.0000 ***
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      
      Items detected as DIF items:
       Item5
       Item8
       Item11
       Item15

---

    Code
      (df <- data.frame(AIC = c(AIC(fit2), AIC(fit3), AIC(fit4)), BIC = c(BIC(fit2),
      BIC(fit3), BIC(fit4)), Fit = paste("fit", rep(2:4, each = 15), sep = ""), Item = as.factor(
        rep(1:15, 3))))
    Output
               AIC       BIC  Fit Item
      1   903.5972  913.4127 fit2    1
      2  1183.4245 1193.2400 fit2    2
      3   557.5339  567.3495 fit2    3
      4  1054.5443 1069.2676 fit2    4
      5  1169.9188 1199.3653 fit2    5
      6  1138.6881 1153.4114 fit2    6
      7  1035.9053 1050.6286 fit2    7
      8   641.3773  680.6393 fit2    8
      9  1004.7217 1024.3527 fit2    9
      10 1143.9437 1163.5747 fit2   10
      11  860.0053  899.2674 fit2   11
      12 1096.9640 1116.5950 fit2   12
      13 1172.5120 1192.1430 fit2   13
      14 1190.0824 1209.7134 fit2   14
      15 1311.7767 1351.0387 fit2   15
      16  903.5972  913.4127 fit3    1
      17 1183.4245 1193.2400 fit3    2
      18  557.5339  567.3495 fit3    3
      19 1054.5443 1069.2676 fit3    4
      20 1169.9188 1199.3653 fit3    5
      21 1138.6881 1153.4114 fit3    6
      22 1035.9053 1050.6286 fit3    7
      23  639.4454  673.7997 fit3    8
      24 1004.7217 1024.3527 fit3    9
      25 1143.9437 1163.5747 fit3   10
      26  858.0053  892.3596 fit3   11
      27 1096.9640 1116.5950 fit3   12
      28 1172.5120 1192.1430 fit3   13
      29 1190.0824 1209.7134 fit3   14
      30 1310.1319 1344.4861 fit3   15
      31  903.5972  913.4127 fit4    1
      32 1183.4245 1193.2400 fit4    2
      33  557.5339  567.3495 fit4    3
      34 1054.5443 1069.2676 fit4    4
      35 1165.9404 1185.5715 fit4    5
      36 1138.6881 1153.4114 fit4    6
      37 1035.9053 1050.6286 fit4    7
      38  640.6757  665.2145 fit4    8
      39 1004.7217 1024.3527 fit4    9
      40 1143.9437 1163.5747 fit4   10
      41  888.3168  912.8556 fit4   11
      42 1096.9640 1116.5950 fit4   12
      43 1172.5120 1192.1430 fit4   13
      44 1190.0824 1209.7134 fit4   14
      45 1308.6640 1333.2028 fit4   15

---

    Code
      logLik(fit3, item = 8)
    Output
      'log Lik.' -312.7227 (df=7)

---

    Code
      logLik(fit4, item = 8)
    Output
      'log Lik.' -315.3379 (df=5)

---

    Code
      predict(fit1, item = 5, group = c(0, 1), match = 0)
    Output
         item match group      prob
      1 Item5     0     0 0.7851726
      2 Item5     0     1 0.5624891

---

    Code
      fit9$difPur
    Output
            Item1 Item2 Item3 Item4 Item5 Item6
      Step0     0     0     0     0     1     1
      Step1     0     0     0     0     1     0
      Step2     0     0     0     0     1     0

---

    Code
      fit14$difPur
    Output
             Item1 Item2 Item3 Item4 Item5 Item6 Item7 Item8 Item9 Item10 Item11
      Step0      0     0     0     0     1     0     0     1     0      0      1
      Step1      1     0     0     0     1     0     0     1     0      0      1
      Step2      0     0     0     0     1     0     0     1     0      0      1
      Step3      1     0     0     0     1     0     0     1     0      0      1
      Step4      0     0     0     0     1     0     0     1     0      0      1
      Step5      1     0     0     0     1     0     0     1     0      0      1
      Step6      0     0     0     0     1     0     0     1     0      0      1
      Step7      1     0     0     0     1     0     0     1     0      0      1
      Step8      0     0     0     0     1     0     0     1     0      0      1
      Step9      1     0     0     0     1     0     0     1     0      0      1
      Step10     0     0     0     0     1     0     0     1     0      0      1
             Item12
      Step0       0
      Step1       0
      Step2       0
      Step3       0
      Step4       0
      Step5       0
      Step6       0
      Step7       0
      Step8       0
      Step9       0
      Step10      0

# testing paper code - R Journal 2020 - LearningToLearn

    Code
      predict(fitex3, match = rep(c(-1, 0, 1), 2), group = rep(c(0, 1), each = 3),
      item = 1, interval = "confidence")
    Output
            item match group      prob  lwr.conf  upr.conf
      1 Item6A_9    -1     0 0.6785773 0.6188773 0.7382773
      2 Item6A_9     0     0 0.7773050 0.7269066 0.8277034
      3 Item6A_9     1     0 0.8781427 0.8114574 0.9448281
      4 Item6A_9    -1     1 0.7802954 0.7186997 0.8418912
      5 Item6A_9     0     1 0.8431037 0.7869870 0.8992204
      6 Item6A_9     1     1 0.9290799 0.8549497 1.0032100

# testing paper code - R Journal 2020 - special cases (not included)

    Code
      head(df[, c(1:5, 16)])
    Output
        Item1 Item2 Item3 Item4 Item5 group
      1     0     1     1     1     1     0
      2     0     1     1     0     1     0
      3     0     1     0     0     1     0
      4     1     1     1     0     1     0
      5     1     1     0     1     1     0
      6     0     1     0     0     1     0

---

    Code
      coef(fit12b, item = 14)
    Output
      $Item14
                       a        b          c  d
      estimate 0.9294854 1.329411 0.06799893  1
      CI2.5           NA       NA         NA NA
      CI97.5          NA       NA         NA NA
      

---

    Code
      fit12c
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression Wald test statistics
      based on 4PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value     
      Item1   43.3878      0.0000 ***
      Item2  155.8403      0.0000 ***
      Item3  153.4009      0.0000 ***
      Item4  111.2974      0.0000 ***
      Item5  533.3646      0.0000 ***
      Item6  107.9470      0.0000 ***
      Item7   11.5948      0.0206 *  
      Item8   53.3736      0.0000 ***
      Item9  453.2297      0.0000 ***
      Item10 145.8386      0.0000 ***
      Item11 910.1895      0.0000 ***
      Item12  68.7672      0.0000 ***
      Item13  28.3833      0.0000 ***
      Item14       NA          NA    
      Item15  96.6385      0.0000 ***
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 9.4877 (significance level: 0.05)
      
      Items detected as DIF items:
       Item1
       Item2
       Item3
       Item4
       Item5
       Item6
       Item7
       Item8
       Item9
       Item10
       Item11
       Item12
       Item13
       Item15

---

    Code
      fit12d
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value    
      Item1   2.0935      0.7186    
      Item2   0.7896      0.9398    
      Item3  17.6515      0.0014 ** 
      Item4   4.8403      0.3041    
      Item5  13.1573      0.0105 *  
      Item6   3.8714      0.4237    
      Item7   1.5778      0.8128    
      Item8  10.9093      0.0276 *  
      Item9   0.6097      0.9620    
      Item10  2.4853      0.6473    
      Item11 26.6071      0.0000 ***
      Item12  5.2838      0.2594    
      Item13  2.8016      0.5916    
      Item14      NA          NA    
      Item15 12.8104      0.0122 *  
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 9.4877 (significance level: 0.05)
      
      Items detected as DIF items:
       Item3
       Item5
       Item8
       Item11
       Item15

---

    Code
      (fit15a <- difNLR(DataDIF[, -c(5, 8, 11, 15)], groupDIF, focal.name = 1, model = "4PL",
      type = "all"))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was not applied
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value  
      Item1  9.1344      0.0578  .
      Item2  1.1944      0.8790   
      Item3  4.5018      0.3423   
      Item4  2.9407      0.5678   
      Item6  6.2007      0.1847   
      Item7  0.8918      0.9257   
      Item9  1.2215      0.8746   
      Item10 1.6226      0.8047   
      Item12 7.2585      0.1228   
      Item13 5.6248      0.2290   
      Item14 1.5104      0.8248   
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 9.4877 (significance level: 0.05)
      None of items is detected as DIF 

---

    Code
      (fit15b <- difNLR(DataDIF[, -c(5, 8, 11, 15)], groupDIF, focal.name = 1, model = "4PL",
      type = "all", purify = TRUE))
    Output
      Detection of all types of differential item functioning
      using the generalized logistic regression model
      
      Generalized logistic regression likelihood ratio chi-square statistics
      based on 4PL model 
      
      Parameters were estimated using non-linear least squares
      
      Item purification was applied with 0 iteration.
      No p-value adjustment for multiple comparisons
      
             Chisq-value P-value  
      Item1  9.1344      0.0578  .
      Item2  1.1944      0.8790   
      Item3  4.5018      0.3423   
      Item4  2.9407      0.5678   
      Item6  6.2007      0.1847   
      Item7  0.8918      0.9257   
      Item9  1.2215      0.8746   
      Item10 1.6226      0.8047   
      Item12 7.2585      0.1228   
      Item13 5.6248      0.2290   
      Item14 1.5104      0.8248   
      
      Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
      
      Detection thresholds: 9.4877 (significance level: 0.05)
      None of items is detected as DIF 

