% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{decision_6}
\alias{decision_6}
\title{Decision 6: choose method of calculating prescription duration}
\usage{
decision_6(data, decision = "c")
}
\arguments{
\item{data}{a data frame}

\item{decision}{one of the following strings:
\describe{
\item{"a"}{\code{numdays}}
\item{"b"}{\code{dose_duration}}
\item{"c"}{\code{qty / ndd}}
}}
}
\description{
This is just shorthand for defining a column equal to one of the specified
formulae. If the column(s) corresponding to \code{decision} are missing, an
error will be thrown.
If you have already calculated or obtained the column \code{duration} from
elsewhere, this step is not necessary.
}
\note{
This step actually takes place \emph{before} \code{\link{decision_5}}.
}
\seealso{
Other decision functions: 
\code{\link{decision_10}()},
\code{\link{decision_1}()},
\code{\link{decision_2}()},
\code{\link{decision_3}()},
\code{\link{decision_4}()},
\code{\link{decision_5}()},
\code{\link{decision_7}()},
\code{\link{decision_8}()},
\code{\link{decision_9}()},
\code{\link{drug_prep}()}
}
\concept{decision functions}
