% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{eth_parse_date}
\alias{eth_parse_date}
\title{Parse Ethiopian Date}
\usage{
eth_parse_date(x, format = "\%Y-\%m-\%d", lang = c("lat", "amh", "en"))
}
\arguments{
\item{x}{a character vector.}

\item{format}{a format in in which x is composed. See \code{\link[base]{strptime}}.}

\item{lang}{a language in which month names are written, if included in x.
Use "lat" for Amharic month names written in Latin alphabets, "amh" for month names
written in Amharic alphabets, and "en" for English month names.}
}
\value{
a vector of  an'ethdate' object.
}
\description{
Parse Ethiopian date from character vector that has a non-digit separator.
}
\details{
x must include a non-digit separator and exactly three components of the date (year, month, and day).
}
\examples{
eth_parse_date("2017-01-01")
s <- c("01/01/2013", "06/13/2011")
eth_parse_date(s, format = "\%d/\%m/\%Y")
}
\seealso{
\code{\link[=eth_date]{eth_date()}} \code{\link[=eth_make_date]{eth_make_date()}}
}
\author{
Gutama Girja Urago
}
