% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_coefficients.R
\name{coef.modeler}
\alias{coef.modeler}
\title{Coefficients for an object of class \code{modeler}}
\usage{
\method{coef}{modeler}(object, id = NULL, metadata = FALSE, df = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{modeler}, typically the result of calling
the \code{modeler()} function.}

\item{id}{An optional unique identifier to filter by a specific group. Default is \code{NULL}.}

\item{metadata}{Logical. If \code{TRUE}, metadata is included along with the coefficients. Default is \code{FALSE}.}

\item{df}{Logical. If \code{TRUE}, the degrees of freedom for the fitted model
are returned alongside the coefficients. Default is \code{FALSE}.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{data.frame} containing the model's estimated coefficients,
standard errors, and optional metadata or degrees of freedom if specified.
}
\description{
Extract the estimated coefficients from an object of class \code{modeler}.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
coef(mod_1, id = 2)
}
\author{
Johan Aparicio [aut]
}
