% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mdim_info}
\alias{mdim_info}
\title{Report structure and content of a multidimensional dataset}
\usage{
mdim_info(
  dsn,
  array_name = "",
  pretty = TRUE,
  detailed = FALSE,
  limit = -1L,
  stats = FALSE,
  array_options = NULL,
  allowed_drivers = NULL,
  open_options = NULL,
  cout = TRUE
)
}
\arguments{
\item{dsn}{Character string giving the data source name of the
multidimensional raster (e.g., file, VSI path).}

\item{array_name}{Character string giving the name of the MDarray in
\code{dsn}.}

\item{pretty}{Logical value, \code{FALSE} to output a single line without any
indentation. Defaults to \code{TRUE}.}

\item{detailed}{Logical value, \code{TRUE} for verbose output. Report attribute
data types and array values. Defaults to \code{FALSE}.}

\item{limit}{Integer value. Number of values in each dimension that is used
to limit the display of array values. By default, unlimited. Only taken into
account if used with \code{detailed = TRUE}. Set to a positive integer to enable.}

\item{stats}{Logical value, \code{TRUE} to read and display array statistics.
Forces computation if no statistics are stored in an array. Defaults to
\code{FALSE}.}

\item{array_options}{Optional character vector of \code{"NAME=VALUE"} pairs to
filter reported arrays. Such option is format specific. Consult driver
documentation (passed to \code{GDALGroup::GetMDArrayNames()}).}

\item{allowed_drivers}{Optional character vector of driver short names that
must be considered when opening \code{dsn}. It is generally not necessary to
specify it, but it can be used to skip automatic driver detection, when it
fails to select the appropriate driver.}

\item{open_options}{Optional character vector of format-specific dataset
openoptions as \code{"NAME=VALUE"} pairs.}

\item{cout}{Logical value, \code{TRUE} to print info to the console (the
default), or \code{FALSE} to suppress console output.}
}
\value{
Invisibly, a JSON string containing information about the
multidimensional raster dataset. By default, the info string is also printed
to the console unless \code{cout} is set to \code{FALSE}.
}
\description{
\code{mdim_info()} is an interface to the \command{gdalmdiminfo} command-line
utility (see \url{https://gdal.org/en/stable/programs/gdalmdiminfo.html}).
This function lists various information about a GDAL supported
multidimensional raster dataset as JSON output. It follows the JSON schema
\href{https://github.com/OSGeo/gdal/blob/release/3.11/apps/data/gdalmdiminfo_output.schema.json}{gdalmdiminfo_output.schema.json}.
Requires GDAL >= 3.2.
}
\examples{
\dontshow{if (gdal_version_num() >= gdal_compute_version(3, 2, 0) && isTRUE(gdal_formats("netCDF")$multidim_raster)) withAutoprint(\{ # examplesIf}
f <- system.file("extdata/byte.nc", package="gdalraster")
mdim_info(f)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=mdim_as_classic]{mdim_as_classic()}}, \code{\link[=mdim_translate]{mdim_translate()}}
}
