% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_addINFO.R
\name{addINFO}
\alias{addINFO}
\alias{sites}
\title{Add Infomation to Haplotype Results}
\usage{
addINFO(hap,
        tag = "", values = values,
        replace = FALSE, sep = ";")

sites(hap)
}
\arguments{
\item{hap}{object of \code{hapResult} or \code{hapSummary} class}

\item{tag}{tag names, usually is a single word used before "="}

\item{values}{annotation for each site.
Length of values must be equal with sites in hapResult}

\item{replace}{whether replace origin INFOs in hapResult or not.
Default as FALSE}

\item{sep}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}
}
\value{
object of hapSummary or hapResult class with added/replaced INFOs
}
\description{
add annotations to INFO fields used for \code{plotHapTable()}
}
\examples{

data("geneHapR_test")

# length of values must be equal with number of sites in hap result
values <- paste0("newInfo",c(1:9))
hapResult <- addINFO(hapResult, tag = "new", values = values, replace = TRUE)

data("geneHapR_test")

# check how many sites were concluded in hapResult/hapSummary
sites(hapResult)

}
\seealso{
\code{\link[geneHapR:plotHapTable]{plotHapTable()}}

\code{\link[geneHapR:plotHapTable]{plotHapTable()}}
}
