% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_coordinates}
\alias{GC_coordinates}
\title{Modify Coordinates in a GC Chart}
\usage{
GC_coordinates(
  GC_chart,
  show = TRUE,
  tickValuesTop = NULL,
  tickValuesBottom = NULL,
  ticksFormat = NULL,
  tickStyle = list(),
  textStyle = list(),
  cluster = NULL,
  ...
)
}
\arguments{
\item{GC_chart}{The GC chart object to be modified.}

\item{show}{Logical, whether to show the tick values or not. Can be a single
value or a vector.}

\item{tickValuesTop}{Numeric vector or NULL, custom tick values to be used at
the top of the cluster. If NULL, the default tick values are used.}

\item{tickValuesBottom}{Numeric vector or NULL, custom tick values to be used
at the bottom of the cluster. If NULL, the default tick values are used.}

\item{ticksFormat}{Format for tick labels. Default is ",.0f".}

\item{tickStyle}{List, styling options for the ticks.}

\item{textStyle}{List, styling options for the text.
the coordinate modifications. If NULL, applies to all clusters.}

\item{cluster}{Numeric or character vector or NULL; specifies which clusters
to generate coordinates for.
       If NULL, labels will be applied to all clusters. Default is NULL.}

\item{...}{Additional arguments to be passed to the coordinate options.}
}
\value{
Returns the GC chart object with updated coordinates.
}
\description{
This function updates a GC chart by modifying the coordinates settings. It
allows for showing or hiding tick values, applying custom tick values for the
top and bottom axes, and supports several other customizations for specific
or all clusters in the chart.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5'),
  cluster = c(1, 1, 2, 2, 2)
)

# Add coordinates to all clusters
GC_chart(genes_data, cluster = "cluster", group = "name", height = "200px") \%>\%
GC_coordinates()

# Modify coordinates of a specific cluster
GC_chart(genes_data, cluster = "cluster", group = "name", height = "200px") \%>\%
GC_coordinates() \%>\%
GC_coordinates(
  cluster = 2,
  show = TRUE,
  tickValuesTop = c(130, 170, 210, 240),
  tickValuesBottom = c(160, 200),
  ticksFormat = ",.0f", # ".2s",
  rotate = -45,
  yPositionTop = 55,
  yPositionBottom = 45,
  overlapThreshold = 20,
  tickStyle = list(
  stroke = "black",
  strokeWidth = 1,
  lineLength = 6
  ),
  textStyle = list(
  fill = "black",
  fontSize = "12px",
  fontFamily = "Arial",
  cursor = "default"
  )
)

}
