% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_sequence}
\alias{GC_sequence}
\title{Update Sequence Display of a GC Chart Cluster}
\usage{
GC_sequence(
  GC_chart,
  show = TRUE,
  cluster = NULL,
  y = 50,
  sequenceStyle = list(),
  markerStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{show}{Logical, whether to display the sequence (default is TRUE).}

\item{cluster}{Numeric or character vector specifying clusters to update.}

\item{y}{Vertical position of the sequence line (default is 50).}

\item{sequenceStyle}{A list of styling options for the sequence line.}

\item{markerStyle}{A list of styling options for the sequence break markers.}

\item{...}{Additional customization arguments for sequence display.}
}
\value{
An updated GC chart with modified sequence display settings.
}
\description{
Modify the sequence display and break markers of specified clusters within a GC chart.
}
\details{
This function allows customization of the sequence line and break markers in a GC chart.
It offers options to adjust the sequence line (`sequenceStyle`) and break markers (`markerStyle`).
The `y` parameter can be used to set the vertical position of the sequence.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 2, 2, 2)
)

# Basic usage
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
GC_labels("name") \%>\%
GC_sequence(show = TRUE, y = 50, cluster = NULL)

# Customize sequence and marker styles
GC_chart(genes_data, cluster="cluster", group = "group", height = "200px") \%>\%
  GC_scale(hidden = TRUE, scale_breaks = TRUE) \%>\%
  GC_sequence(
    start = NULL,
    end = NULL,
    sequenceStyle = list(
      stroke = "blue",
      strokeWidth = 1
      # Any other CSS style
    ),
    markerStyle = list(
      stroke = "blue",
      strokeWidth = 1,
      gap = 3,
      tiltAmount = 5
      # Any other CSS style
    )
  ) \%>\%
  GC_legend(FALSE)

}
