% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-spatial-join.R
\name{multiscale_operations}
\alias{multiscale_operations}
\title{Multi-scale spatial operations}
\usage{
multiscale_operations(
  spatial_data,
  target_scales = c(1, 2, 4, 8),
  operation = "mean",
  pyramid = FALSE
)
}
\arguments{
\item{spatial_data}{Input spatial data}

\item{target_scales}{Vector of scale factors}

\item{operation}{Operation to perform at each scale}

\item{pyramid}{Create image pyramid}
}
\value{
List of results at different scales
}
\description{
Handle multi-scale operations including up-scaling, down-scaling,
and pyramid operations for efficient processing.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Create multi-scale analysis
scales <- multiscale_operations("data.tif", c(1, 2, 4, 8), "mean")
}

}
